#!/bin/bash
################################################################################
## Copyright:   HUAWEI Tech. Co., Ltd.
## Filename:    set_firewall_rule.sh
## Des: 设置防火墙规则，支持独立运行
################################################################################

CURRENT_USER="`/usr/bin/id -u -n`"
if [ "${CURRENT_USER}" != "root" ]; then
    echo "only the root user can run this script, now the user is ${CURRENT_USER}"
    exit 1
fi

SOURCE="${BASH_SOURCE[0]}"
SCRIPT_FILE_PATH=`/usr/bin/readlink -e ${SOURCE}`
SCRIPT_DIR=`/usr/bin/dirname ${SCRIPT_FILE_PATH}`
APP_PATH=`/usr/bin/dirname ${SCRIPT_DIR}`
PYTHON_PATH=${APP_PATH}/rtsp/python/bin


if [ $# -gt 1 ]; then
    echo "error: unsupported option. -h for help"
    exit 1
fi

. ${APP_PATH}/lbin/env_profile.sh "${APP_PATH}"
${PYTHON_PATH}/python ${APP_PATH}/tools/pyscript/set_firewall_rule.pyc --local $1
result=$?
if [ ${result} -ne 0 ]; then
    echo "Set firewall rule failed."
fi
. ${APP_PATH}/lbin/syslog.sh $0 $result $@
exit $result
