#!/usr/bin/env bash
SOURCE="${BASH_SOURCE[0]}"
SCRIPT_FILE_PATH=`/usr/bin/readlink -e ${SOURCE}`
SCRIPT_DIR=`/usr/bin/dirname ${SCRIPT_FILE_PATH}`
APP_PATH=`/usr/bin/dirname ${SCRIPT_DIR}`
APP_PARENT_PATH=`/usr/bin/dirname ${APP_PATH}`

if [[ ${USER} != "root" ]]; then
    echo "only the root user can run this script, now the user is ${USER}"
    exit 1
fi

if [ $# -gt 0 ]; then
    echo "error: unsupported option."
    exit 1
fi


function fn_delete_folder()
{
    rm -rf ${APP_PATH} > /dev/null 2>&1
}

function delete_pub()
{
    #if there is /pub directory in the same directory with the /ODAEDeployTool, then delete the pub, or some files in it
    if [[ -d ${APP_PARENT_PATH}/pub ]]
    then
        # delete the component_define.json file
        if [[ -f ${APP_PARENT_PATH}/pub/component_define.json ]]
        then
            rm -f ${APP_PARENT_PATH}/pub/component_define.json
        fi
        # delete the release_version.properties file
        if [[ -f ${APP_PARENT_PATH}/pub/release_version.properties ]]
        then
            rm -f ${APP_PARENT_PATH}/pub/release_version.properties
        fi
        #delete the release.yaml file
        if [[ -f ${APP_PARENT_PATH}/pub/release.yaml ]]
        then
            rm -f ${APP_PARENT_PATH}/pub/release.yaml
        fi
        # if the pub directory become empty then delete the directory
        pubFileNum=$(ls ${APP_PARENT_PATH}/pub | wc -w)
        if [[ ${pubFileNum} = '0' ]]
        then
            rm -rf ${APP_PARENT_PATH}/pub/
        fi
    fi
}

function save_log()
{
    LOG_FOLDER="/var/log/tools/odaeswiftdeploy/"
    if [[ -d ${LOG_FOLDER} ]]; then
        rm -rf ${LOG_FOLDER} > /dev/null 2>&1
    fi
    mkdir -p ${LOG_FOLDER}
    cp -rf ${APP_PATH}/var/logs/* ${LOG_FOLDER}
    chmod -R 400 ${LOG_FOLDER} > /dev/null 2>&1
}

function sys_log()
{
    declare source="$0"
    [ -e "$source" ] && source=`/usr/bin/readlink -e $source`
    if [ $# -gt 1 ]; then
        shift 1
        source="$source $@"
    fi

    OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
    if [[ "$1" == "0" ]]
    then
        logger -t $USER -p local0.info "[$source] return code=[$1], execute success from ${OPERIP:-127.0.0.1}"
    else
        logger -t $USER -p local0.info "[$source] return code=[$1], execute failed from ${OPERIP:-127.0.0.1}"
    fi
}

function fn_main()
{
    save_log

    fn_delete_folder

    delete_pub

    echo "uninstall ODAEDeployTool success!"
    return 0
}

fn_main
result=$?
sys_log $result $@
exit $result
