#!/bin/bash

app_path=$1

function adapt_euler29()
{
    grep -i euler /etc/os-release > /dev/null 2>&1
    if [[ $? -ne 0 ]]
    then
      return 0
    fi

    so_name=libffi.so.6
    result=$("${app_path}"/rtsp/python/bin/python -c "try: import paramiko
except ImportError as e: print(e)")
    if [[ "${result}" =~ ${so_name} ]]
    then
      lib_path=${app_path}/rtsp/lib
      libffi_path="${lib_path}"/"${so_name}"
      if [[ ! -f "${libffi_path}" ]]
      then
        so_file=$(/usr/bin/readlink -e /usr/lib64/libffi.so* | uniq)
        mkdir -p "${lib_path}"
        ln -s "${so_file}" "${libffi_path}"
      fi
      export LD_LIBRARY_PATH="${lib_path}"
      return 0
    fi
}

function avoid_pem_file() {
    file_path=${app_path}/rtsp/python/lib/python3.8/site-packages/certifi/cacert.pem
    if [[ ! -f "${file_path}" ]]
    then
      touch "${file_path}"
      chmod 400 "${file_path}"
    fi
}

function set_env_profile() {
    avoid_pem_file
    adapt_euler29
    return $?
}

set_env_profile
