#!/usr/bin/env bash
SOURCE="${BASH_SOURCE[0]}"
SCRIPT_FILE_PATH=`/usr/bin/readlink -e ${SOURCE}`
SCRIPT_DIR=`/usr/bin/dirname ${SCRIPT_FILE_PATH}`
APP_PATH=`/usr/bin/dirname ${SCRIPT_DIR}`
APP_PARENT_PATH=`/usr/bin/dirname ${APP_PATH}`

CURRENT_USER="`/usr/bin/id -u -n`"
if [ "${CURRENT_USER}" != "root" ]; then
    echo "only the root user can run this script, now the user is ${CURRENT_USER}"
    exit 1
fi

function fn_chown_folder()
{
    /usr/bin/chown -R root:root ${APP_PATH} > /dev/null 2>&1
    /usr/bin/chmod -R 700 ${APP_PATH} > /dev/null 2>&1
    /usr/bin/find ${APP_PATH} -type f -name "*.*" | xargs -I {} /usr/bin/chmod 600 {} > /dev/null 2>&1
    /usr/bin/find "${APP_PATH}" -type f -name "*.sh" | xargs -I {} chmod 500 {} > /dev/null 2>&1
    /usr/bin/find ${APP_PATH} -type f -name "*.log" | xargs -I {} /usr/bin/chmod 640 {} > /dev/null 2>&1

    return $?
}

function delete_pub()
{
    #if there is /pub directory in the same directory with the /ODAEDeployTool, then delete the pub, or some files in it
    if [[ -d ${APP_PARENT_PATH}/pub ]]
    then
        # delete the component_define.json file
        if [[ -f ${APP_PARENT_PATH}/pub/component_define.json ]]
        then
            rm -f ${APP_PARENT_PATH}/pub/component_define.json
        fi
        # delete the release_version.properties file
        if [[ -f ${APP_PARENT_PATH}/pub/release_version.properties ]]
        then
            rm -f ${APP_PARENT_PATH}/pub/release_version.properties
        fi
        #delete the release.yaml file
        if [[ -f ${APP_PARENT_PATH}/pub/release.yaml ]]
        then
            rm -f ${APP_PARENT_PATH}/pub/release.yaml
        fi
        # if the pub directory become empty then delete the directory
        pubFileNum=$(ls ${APP_PARENT_PATH}/pub | wc -w)
        if [[ ${pubFileNum} = '0' ]]
        then
            rm -rf ${APP_PARENT_PATH}/pub/
        fi
    fi
}

function fn_main()
{
    delete_pub

    if [[ ! -d ${APP_PATH}/var/logs ]]
    then
        mkdir -p ${APP_PATH}/var/logs
    fi

    export _APP_LOG_DIR=${APP_PATH}/var/logs

    fn_chown_folder

    return 0
}

fn_main