#!/bin/bash
OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
if [ -z "${APP_ROOT}" -o -z "${PROCESS_NAME}" -o -z "${PROCESS_INSTANCE_ID}" ];
then
    echo "APP_ROOT or PROCESS_NAME or PROCESS_INSTANCE_ID is empty."
    logger -t $USER -p local0.info "startJavaProcess.sh;Failed;${OPERIP:-127.0.0.1};Run java process ${PROCESS_INSTANCE_ID}."
    exit 1
fi


if [ -z "$JAVA_HOME" ]
then
    echo "There is no JAVA_HOME"
    logger -t $USER -p local0.info "startJavaProcess.sh;Failed;${OPERIP:-127.0.0.1};Run java process ${PROCESS_INSTANCE_ID}."
    exit 1
fi

if [ -z "$CATALINA_HOME" ]
then
    echo "There is no CATALINA_HOME"
    logger -t $USER -p local0.info "startJavaProcess.sh;Failed;${OPERIP:-127.0.0.1};Run java process ${PROCESS_INSTANCE_ID}."
    exit 1
fi


export CATALINA_BASE=$APP_ROOT
export COMPLETE_PROCESS_NAME=$PROCESS_NAME-$NODE_ID-$PROCESS_SLOT
LOG_PATH=$_APP_LOG_DIR/$COMPLETE_PROCESS_NAME

JVM_EXT_OPT="-Djava.awt.headless=true -Dsun.zip.disableMemoryMapping"

if [ -f ${APP_ROOT}/etc/roa/roa.${PROCESS_NAME}.xml ]; then
    ROA_INSTANCE_CONF="-Droa.instance.conf=${APP_ROOT}/etc/roa/roa.${PROCESS_NAME}.xml"
else
    ROA_INSTANCE_CONF=
fi

JVM_MEMORY_OPT="-server -Xms64m -Xmx1024m -XX:InitialCodeCacheSize=32m -XX:ReservedCodeCacheSize=64m -XX:MetaspaceSize=48m 
-XX:MaxMetaspaceSize=128m -Xss512k -XX:MaxInlineLevel=1 -XX:InlineSmallCode=25 -XX:OnStackReplacePercentage=14000 -XX:+DisableExplicitGC -XX:+UseConcMarkSweepGC -XX:+UseCMSInitiatingOccupancyOnly 
-XX:CMSInitiatingOccupancyFraction=62 -XX:-UseLargePages -XX:+UseFastAccessorMethods -XX:+CMSClassUnloadingEnabled"


JAVA_OPTS="-Dfile.encoding=UTF-8"
JAVA_OPTS="$JAVA_OPTS -Dlog.dir=$LOG_PATH"
JAVA_OPTS="$JAVA_OPTS -DAPP_ROOT=$APP_ROOT"
JAVA_OPTS="$JAVA_OPTS $JVM_MEMORY_OPT $ROA_INSTANCE_CONF $JVM_EXT_OPT"

export TOMCAT_LOG_DIR=$_APP_LOG_DIR/$COMPLETE_PROCESS_NAME/tomcatlog
mkdir -p $TOMCAT_LOG_DIR
export TOMCAT_WORK_DIR=$_APP_SHARE_DIR/$COMPLETE_PROCESS_NAME/tomcatwork
export CATALINA_OUT=$TOMCAT_LOG_DIR/catalina.out



export JAVA_OPTS="-DNFW=$COMPLETE_PROCESS_NAME -Dprocname=$COMPLETE_PROCESS_NAME $JAVA_OPTS -DTOMCAT_LOG_DIR=$TOMCAT_LOG_DIR  -DTOMCAT_WORK_DIR=$TOMCAT_WORK_DIR"

#delete monitor file, make sure the main process create new one
monitorFullPath=${_APP_SHARE_DIR}/${COMPLETE_PROCESS_NAME}.monitor
if [ -f ${monitorFullPath} ]
then
    /bin/rm -r ${monitorFullPath}
fi
$CATALINA_HOME/bin/catalina.sh start

exitCode=$?

#Logger
if [[ "$exitCode" == "0" ]]
then
    logger -t $USER -p local0.info "startJavaProcess.sh;Successful:$exitCode;${OPERIP:-127.0.0.1};Run java process ${PROCESS_INSTANCE_ID}."
else
    logger -t $USER -p local0.info "startJavaProcess.sh;Failed:$exitCode;${OPERIP:-127.0.0.1};Run java process ${PROCESS_INSTANCE_ID}."
fi

exit $exitCode
