#!/bin/bash
_CURRENT_DIR=$(cd `dirname $0`; pwd)
_PARENT_DIR=$(cd `dirname $0`; dirname "$PWD")
LOG_FILE=/var/log/tools/FusionInsight/CheckPackage.log


source ${_PARENT_DIR}/common/logger.sh
mkdir -p `dirname $LOG_FILE`
# use common package to install
FI_HD_VERSION=`ls $_CURRENT_DIR | grep ^FusionInsight_HD | grep tar.gz$ | sort -r | head -1`
FI_HD_PATCH=`ls $_CURRENT_DIR | grep ^FusionInsight_HD_6.5.1\\\. | grep tar.gz$`
FI_BASE_VERSION=`ls $_CURRENT_DIR | grep ^FusionInsight_BASE | grep tar.gz$ | sort -r | head -1`
FI_BASE_PATCH=`ls $_CURRENT_DIR | grep ^FusionInsight_BASE_6.5.1\\\. | grep tar.gz$`
FI_MANAGER_VERSION=`ls $_CURRENT_DIR | grep ^FusionInsight_Manager | grep tar.gz$ | sort -r | head -1`
FI_MANAGER_PATCH=`ls $_CURRENT_DIR | grep ^FusionInsight_Manager_6.5.1\\\. | grep tar.gz$`
FI_SPARK2_VERSION=`ls $_CURRENT_DIR | grep ^FusionInsight_Spark2x | grep tar.gz$ | sort -r | head -1`
FI_SPARK2_PATCH=`ls $_CURRENT_DIR | grep ^FusionInsight_Spark2x_6.5.1\\\. | grep tar.gz$`
FI_SETUP_VERSION=`ls $_CURRENT_DIR | grep ^FusionInsight_SetupTool | grep tar.gz$ | sort -r | head -1`

FI_DIR='FusionInsight_Manager'

function uploadSettings()
{ 
  local software_dir="/Remote_Tool/FusionInsight/software"
  local setting_dir="${software_dir}/install_cluster ${software_dir}/install_oms"
  for dir in ${setting_dir}
  do
      if [ ! -d $dir ];then
          log ERROR "$dir do not exit,Please Upload Software  Settings" ${LOG_FILE}
          exit 1
      fi
  done
  cp -u -r ${software_dir} /opt/$FI_DIR/
  if [ $? -ne 0 ]; then
      log ERROR "Copy config file to opt/${FI_DIR} Failed!, source folder: ${software_dir}" ${LOG_FILE}
      exit 1
  else
      log INFO "Copy Software Settings Success" ${LOG_FILE}
  fi
}

function CheckPackage()
{
    if [ -d /opt/$FI_DIR ];then
        rm -rf /opt/$FI_DIR
    fi

    if [ -f $_CURRENT_DIR/${FI_MANAGER_VERSION} ];then
        log INFO "Start to unzip file: ${FI_MANAGER_VERSION}.tar.gz" ${LOG_FILE}
        tar -xzvf $_CURRENT_DIR/${FI_MANAGER_VERSION} -C /opt 2>&1
        if [ $? -ne 0 ]; then
            log ERROR "Unzip file ${FI_MANAGER_VERSION}.tar.gz failed." ${LOG_FILE}
            exit 1
        else
            log INFO "Unzip ${FI_MANAGER_VERSION}.tar.gz Success" ${LOG_FILE}
        fi
        if [ -n "${FI_MANAGER_PATCH}" ]; then
            mkdir -p /opt/FusionInsight_Manager/software/patch
            if [ $? -eq 0 ]; then
                cp $_CURRENT_DIR/${FI_MANAGER_PATCH} /opt/FusionInsight_Manager/software/patch/
                chmod 777 /opt/FusionInsight_Manager/software/patch/${FI_MANAGER_PATCH}
            else
                log ERROR "create FusionInsight_Manager patch dir fail!" ${LOG_FILE}
            fi
        fi
        #unzip SetupTool and preset
        log INFO "Start to preset: ${FI_SETUP_VERSION}.tar.gz" ${LOG_FILE}
        if [ -f $_CURRENT_DIR/${FI_SETUP_VERSION} ]; then
            tar -zxvf $_CURRENT_DIR/${FI_SETUP_VERSION} -C $_CURRENT_DIR
            if [ $? -ne 0 ]; then
                log ERROR "Unzip file ${FI_SETUP_VERSION}.tar.gz failed." ${LOG_FILE}
                exit 1
            else
                log INFO "Unzip ${FI_SETUP_VERSION}.tar.gz Success, path is $_CURRENT_DIR" ${LOG_FILE}
                bash $_CURRENT_DIR/FusionInsight_SetupTool/preset/preset.sh
            fi
        fi


        # copy package to fi manage package
        if [ -f $_CURRENT_DIR/${FI_HD_VERSION} ];then
            log INFO "found fi package ${FI_HD_VERSION}, copy to manager packs" ${LOG_FILE}
            cp $_CURRENT_DIR/${FI_HD_VERSION}   /opt/FusionInsight_Manager/software/packs/
        fi
        if [ -n "${FI_HD_PATCH}" ]; then
            chmod 777 $_CURRENT_DIR/${FI_HD_PATCH}
        fi

        if [ -f $_CURRENT_DIR/${FI_SPARK2_VERSION} ];then
            log INFO "found fi package ${FI_SPARK2_VERSION}, copy to manager packs" ${LOG_FILE}
            cp $_CURRENT_DIR/${FI_SPARK2_VERSION}  /opt/FusionInsight_Manager/software/packs/
        fi
        if [ -n "${FI_SPARK2_PATCH}" ]; then
            chmod 777 $_CURRENT_DIR/${FI_SPARK2_PATCH}
        fi

        if [ -f $_CURRENT_DIR/${FI_BASE_VERSION} ];then
            log INFO "found fi package ${FI_BASE_VERSION}, copy to manager packs" ${LOG_FILE}
            cp $_CURRENT_DIR/${FI_BASE_VERSION}  /opt/FusionInsight_Manager/software/packs/
        fi
        if [ -n "${FI_BASE_PATCH}" ]; then
            chmod 777 $_CURRENT_DIR/${FI_BASE_PATCH}
        fi

    else
        log ERROR "FusionInsight Package is Null,Please Upload!!!" ${LOG_FILE}
        exit 1
     fi
}
CheckPackage
uploadSettings



