#!/bin/bash
manager_ip=$1
is_disable_fi_ntp=$2
need_preset=$3
FI_DIR='FusionInsight_Manager'

CURRENT_PATH=$(cd `dirname $0`; pwd)
_PARENT_DIR=$(cd `dirname $0`; dirname "$PWD")
source ${_PARENT_DIR}/common/logger.sh
. /opt/$FI_DIR/software/preinstall/preinstall.ini
LOG_FILE=/var/log/tools/FusionInsight/install_FI_Manager.log
INSTALL_Manager_LOG=/var/log/tools/FusionInsight/install_Manager.log
mkdir -p `dirname $LOG_FILE`
FI_SETUP_VERSION=`ls $CURRENT_PATH | grep ^FusionInsight_SetupTool | grep tar.gz$ | sort -r | head -1`

function install_Manager()
{
    cd /opt/$FI_DIR/software
    rm ${INSTALL_Manager_LOG}

    if [ ${is_disable_fi_ntp} = 'True' ]; then
      export USE_EXTERNAL_NTP=YES
    fi
    # check whether fi double mode
    if [ -f /opt/${FI_DIR}/software/install_oms/${manager_ip}.ini ]; then
./install.sh -f /opt/$FI_DIR/software/install_oms/"$manager_ip".ini<<eof|tee -a ${INSTALL_Manager_LOG}
y
y
eof
fi
    # check whether fi singleton mode
    if [ -f /opt/${FI_DIR}/software/install_oms/fi_singleton.ini ]; then
       ./install.sh -f /opt/$FI_DIR/software/install_oms/fi_singleton.ini<<eof|tee -a ${INSTALL_Manager_LOG}
y
y
eof
fi
    unset USE_EXTERNAL_NTP
    # log file rights must be 640
    chmod 640 ${INSTALL_Manager_LOG}
    cat ${INSTALL_Manager_LOG} | grep Successfully
    if [ $? -eq 0 ]
    then
        echo -e "\nSuccess to install Manager.\n"
        log INFO "Install manager successfully." ${LOG_FILE}
        return 0
    else
        echo -e "\nFailed to install Manager! \n"
        log ERROR "Install manager failed, please check install_Manager.log" ${LOG_FILE}
        return 2
    fi
}

function delete_old_log()
{
    rm ${LOG_FILE}
    rm ${INSTALL_Manager_LOG}
}

##############################################################
## @Usage preset
## @Return
## @Description 卸载OMS之后，需要重新执行preset，否则再次安装OMS失败
##############################################################
function preset()
{
    if [[ ${need_preset} == 1 ]] && [[ -f ${CURRENT_PATH}/${FI_SETUP_VERSION} ]]; then
        tar -zxvf ${CURRENT_PATH}/${FI_SETUP_VERSION} -C ${CURRENT_PATH}
        if [ $? -ne 0 ]
        then
            log ERROR "Unzip file ${FI_SETUP_VERSION}.tar.gz failed." ${LOG_FILE}
            exit 1
        else
            log INFO "Unzip ${FI_SETUP_VERSION}.tar.gz Success, path is $CURRENT_PATH" ${LOG_FILE}
            if [[ -f ${CURRENT_PATH}/FusionInsight_SetupTool/preset/preset.sh ]]
            then
                log INFO "start to preset." ${LOG_FILE}
                bash ${CURRENT_PATH}/FusionInsight_SetupTool/preset/preset.sh
                log INFO "preset done." ${LOG_FILE}
            else
                log INFO "preset.sh is not exist." ${LOG_FILE}
                exit 1
            fi
        fi
    fi
}

function uninstall_fi_manager()
{
    if [[ -f /opt/huawei/Bigdata/om-server/om/inst/uninstall.sh ]]; then
        log WARNING "fi manager already exist, start to uninstall manager" ${LOG_FILE}
        bash /opt/huawei/Bigdata/om-server/om/inst/uninstall.sh<<eof | tee -a ${LOG_FILE}
y
eof

    fi
}

function main()
{
    delete_old_log
    uninstall_fi_manager
    preset
    install_Manager
    # log info may lost after retry to install FI
}


main $@



