#!/bin/bash

################################################################################
## Copyright:   HUAWEI Tech. Co., Ltd.
## Filename:    krb-krb5-syn.sh
## Description: 
## Version:     FusionInsight
## Created:     Dec 18, 2017
################################################################################

get_curpath()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    g_curPath="${PWD}"
    cd - > /dev/null
    echo $g_curPath
}

get_etc_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")/../../../.."
    g_etc_Path="${PWD}"
    cd - > /dev/null
    echo $g_etc_Path
}

outputDetailLog()
{
    outputDetailLogtool  "${1}" "${2}" "${3}" "${4}" "${5}" "${g_script_name}"
}

main()
{
    outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${INFO} "Begin to generate krb5.conf"

    if [ -f "${krbclient_krb5Conf}" ]; then
        outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${INFO} "Begin to remove old krb5.conf"
        rm -f "${krbclient_krb5Conf}"
    fi

    cp -f "${etc_krb5Conf}" "${krbclient_krb5Conf}"
    if [ $? -ne 0 ] ; then
        outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${ERR} "cp -f ${etc_krb5Conf} ${krbclient_krb5Conf}."
        return 1
    fi

    outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${INFO} "Begin to synchronize krb5.conf"
    genKrb5Conf
    if [ $? -ne 0 ]; then
        outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${ERR} "Execute genKrb5Conf failed."
        return 1
    fi

    modify_logConf
    if [ $? -ne 0 ]; then
        outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${ERR} "Execute modify_logConf failed."
        return 1
    fi

    chown omm:ficommon "${krbclient_krb5Conf}"
    if [ $? -ne 0 ]; then
        outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${ERR} "Execute modify_logConf failed."
    fi

    return 0

}

getKadmKpasswdList()
{
    local loop_entry=""
    local list_string=""

    list_string="${list_string}\ndatabase_module = openldap_ldapconf\nsupported_enctypes = aes256-cts-hmac-sha1-96:special aes128-cts-hmac-sha1-96:special"

    echo "${list_string}"
    return $RET_OK
}

genKrb5Conf()
{
    local password_file="${KRB_HOME}/var/krb5kdc/KerberosServer_service_passwd"
    local krb5_db_dir="${KRB_HOME}/lib/krb5/plugins/kdb"
    local string_to_replace=$(grep -w "kpasswd_server =" "${krbclient_krb5Conf}" | grep -v "#" | tail -1)
    local replace_string="${string_to_replace}""$(getKadmKpasswdList)"
    local ldap_server_list="$(getLdapServerIPList " ")"
    local ldap_conf="
[dbdefaults]
        ldap_kerberos_container_dn = cn=krbcontainer,dc=hadoop,dc=com

[dbmodules]
db_module_dir = ${krb5_db_dir}
openldap_ldapconf = {
        db_library = kldap
        disable_last_success = true
        ldap_kerberos_container_dn = cn=krbcontainer,dc=hadoop,dc=com
        ldap_kdc_dn = \"cn=root,dc=hadoop,dc=com\"
        ldap_kadmind_dn = \"cn=root,dc=hadoop,dc=com\"
        ldap_service_password_file = ${password_file}
        ldap_servers = ${ldap_server_list}
        ldap_conns_per_server = 5
        ldap_search_timeout = ${LDAP_SEARCH_TIMEOUT}
        ldap_option_timeout = ${LDAP_OPTION_TIMEOUT}
}"
    sed -i "s#${string_to_replace}#${replace_string}#g" "${krbclient_krb5Conf}"
    if [ $? -ne 0 ];then
        outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${ERR} "sed -i s#${string_to_replace}#${replace_string}#g ${krbclient_krb5Conf} failed!"
        return 1
    fi

    echo "${ldap_conf}" >> "${krbclient_krb5Conf}"

    return 0
}

function getLdapServerIPList()
{
    local ldap_ip_list=($(echo "${LDAP_SERVER_LIST}" | awk -F',' '{for(i=1; i<=NF; i++){print $i;};}'))
    local ldap_ip_list_upgrade=($(echo "${LDAP_SERVER_LIST_UPGRADE}" | awk -F',' '{for(i=1; i<=NF; i++){print $i;};}'))
    local ip_list_upgrade_num=0
    local provider_ip="${LDAP_PROVIDER_IP}"
    local float_ip="${LDAP_FLOAT_IP}"
    local ldap_port="${LDAP_SERVER_PORT}"
    local ip_list_num=${#ldap_ip_list[@]}
    local ldap_url_list=""
    local url_list_separater="${1}"

    if [ -z "${ldap_ip_list}" ];then
        echo ""
        return
    fi

    local om_float_ip="${OMS_FLOAT_IP}"
    if [ -z "${om_float_ip}" ]; then
        om_float_ip=$(echo $KEYTAB_REPO | awk -F : '{print $1}')
        if [ -z "${om_float_ip}" ]; then
            outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${ERR} "Failed to get om_float_ip"
            echo ""
            return
        fi
    fi

    local oldap_port="${OLDAP_PORT}"
    if [ -z "${oldap_port}" ]; then
        oldap_port=21750
    fi

    ldap_url_list="ldaps://${om_float_ip}:${oldap_port}"

    for((i=0;i<${ip_list_num};i++));
    do
        ldap_url_list="${ldap_url_list}${url_list_separater}ldaps://${ldap_ip_list[${i}]}:${ldap_port}"
    done

    if [ -n "${float_ip}" ];then
        ldap_url_list="${ldap_url_list}${url_list_separater}ldaps://${float_ip}:${ldap_port}"
    fi
    if [ -n "${provider_ip}" ];then
        ldap_url_list="${ldap_url_list}${url_list_separater}ldaps://${provider_ip}:${ldap_port}"
    fi
    if [ -n "${LDAP_EXTERNAL_IP}" ]; then
        ldap_url_list="${ldap_url_list}${url_list_separater}ldaps://${LDAP_EXTERNAL_IP}:${ldap_port}"
    fi
    if [ -n "${ldap_ip_list_upgrade}" ]; then
        ip_list_upgrade_num=${#ldap_ip_list_upgrade[@]}
    fi
    for((i=0;i<${ip_list_upgrade_num};i++));
    do
        if [ "${ldap_ip_list_upgrade[${i}]}" != "${ldap_url_first_ip}" ];then
            ldap_url_list="${ldap_url_list}${url_list_separater}ldaps://${ldap_ip_list_upgrade[${i}]}:${ldap_port}"
        fi
    done
    echo "${ldap_url_list}"

    return
}

modify_logConf()
{
    local kdcConf="kdc = SYSLOG:INFO:DAEMON"
    local replace_kdcConf="kdc = FILE:/var/log/Bigdata/kerberos/krb5kdc.log"
    local admin_serverConf="admin_server = SYSLOG:INFO:DAEMON"

    admin_serverLineNo=$(grep -n "${admin_serverConf}" "${krbclient_krb5Conf}" | awk -F ':' '{print $1}')

    cp -af "${krbclient_krb5Conf}" "${krbclient_krb5Conf_tmp}"
    if [ $? -ne 0 ]; then
        outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${ERR} "cp ${krbclient_krb5Conf} to ${krbclient_krb5Conf_tmp} failed, the disk need be checked."
        return 1
    fi

    sed -i "${admin_serverLineNo}d" "${krbclient_krb5Conf_tmp}"
    if [ $? -ne 0 ]; then
        outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${ERR} "Remove admin_server logging failed."
    fi

    sed -i "s#${kdcConf}#${replace_kdcConf}#g" "${krbclient_krb5Conf_tmp}"
    if [ $? -ne 0 ]; then
        outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${ERR} "Modify kdc logging failed,sed ${kdcConf} to ${replace_kdcConf} ${krbclient_krb5Conf}."
        return 1
    fi

    mv -f "${krbclient_krb5Conf_tmp}" "${krbclient_krb5Conf}"
    if [ $? -ne 0 ]; then
        outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${ERR} "mv ${krbclient_krb5Conf_tmp} to ${krbclient_krb5Conf} failed."
        return 1
    fi

    return 0
}

g_script_name="$(basename "${BASH_SOURCE-$0}")"
ETC_CONF_PATH=$(get_etc_path)
DETAIL_LOG_FILE_PATH="${BIGDATA_LOG_HOME}/kerberos/krb-krb5-syn.log"
if [ ! -f "${DETAIL_LOG_FILE_PATH}" ] ; then
    touch "${DETAIL_LOG_FILE_PATH}"
fi

. $(get_curpath)/../../../../*_*_KerberosClient/etc/ENV_VARS
. $(get_curpath)/../../common/scripts/output-detail-log.sh

isKerberosNode=$(find "${ETC_CONF_PATH}" -name *KerberosServer* -type d )
if [ ! -z "${isKerberosNode}" ] ; then
    LAUNCHROLE="KrbServer"
    outputDetailLog "${LINENO}" ${DETAIL_LOG_FILE_PATH} ${LAUNCHROLE} ${INFO} "Skip to execute krb-krb5-syn.sh on Kerberos Server node."
    exit 0
fi

etc_krb5Conf="${KCLIENT_CONF_PATH}"/krb5.conf
krbclient_krb5Conf="${KRB_HOME}"/var/krb5kdc/krb5.conf
krbclient_krb5Conf_tmp="${BIGDATA_TMP}"/krb5.conf.tmp
LAUNCHROLE="KrbClient"

main

exit $?

