#!/bin/bash
source /home/omm/.profile
LOG_FILE="/var/log/Bigdata/omm/oms/pms/pms_monitor.log"

log()
{
    echo "[$(date +'%Y-%m-%d %H:%M:%S')] $* " >> "${LOG_FILE}"
}

main()
{
    local roleStatus="${OMS_RUN_PATH}/workspace/ha/module/hacom/script/get_harole.sh"
    if [ ! -f "${roleStatus}" ] ; then
        log "ERROR" "${LINENO}" "The ${roleStatus} file does not exist."
        return 1
    fi

    if [ "active" != "$(${roleStatus})" ]; then
        log "INFO" "${LINENO}" "The current node is not active OMS, no need to monitor pms."
        return 0
    fi
    
    log "INFO" "${LINENO}" "Begin to restart pms"
    restart_app pms
    log "INFO" "${LINENO}" "End to restart pms"
    
    return 0
}

main
exit $?