#!/bin/bash

declare -r fi_update_work="/opt/fiupdate"
declare fi_update_log=''
declare work_curPath=''
declare product_dir='/opt/fiupdate/NCE_info'
declare root_pwd=''
declare admin_pwd=''
declare mainoms=''

TMOUT=0
User_ID=`/usr/bin/id -u`
if [ $User_ID -ne 0 ] 
then
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run user must be root"
    exit 1
fi

read -s -p "please input root password:" root_pwd
echo -e "\n"

read -s -p "please input admin password:" admin_pwd
echo -e "\n"

root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")

function get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    work_curPath="${PWD}"
    fi_scriptName="$(basename "${BASH_SOURCE-$0}")"
    cd - >/dev/null
}

logDef()
{
    local funcName="$1"; shift
    local logLevel="$1"; shift
    local lineNO="$1"; shift

    local logTime="$(date -d today +'%Y-%m-%d %H:%M:%S')"
    printf "[${logTime}] ${logLevel} $* [${g_scriptName}(${funcName}):${lineNO}]($$)\n" \
        >> "${fi_update_log}" 2>&1
}

log_error()
{
    logDef "${FUNCNAME[1]}" "ERROR" "$@"
}

log_info()
{
    logDef "${FUNCNAME[1]}" "INFO" "$@"
}

function init_log()
{
    if [ ! -d "$fi_update_work/log/" ]
    then
        mkdir "$fi_update_work/log/"
    fi
    
    fi_update_log="$fi_update_work/log/pre_work.log"
    [ ! -f "${fi_update_log}" ] && touch "${fi_update_log}"
    chmod 600 "${fi_update_log}"
    echo > ${fi_update_log}
    
}

trap 'onCtrlC' INT
function onCtrlC () {
    echo 'exit program'
    exit 1
}

function get_mainoms_ip()
{
    product_name=$1
    if [ ! -f "/opt/fiupdate/NCE_info/nodes_${product_name}.ini" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: FI nodes config file not exists,please check"
        log_error "${LINENO}" "$product_name: platform nodelist json not exists,please check"
        return 1
    fi
    mainOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep mainOms= |sed 's/mainOms=//g'`

    return 0
    
}

function runpre()
{
    product_name=$1
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name:  start to do precheck work "
    log_info "${LINENO}" "$product_name: start to do precheck work "
    expect <<END
            spawn ssh -t root@${mainOms} "cd /opt/fiupdate ; bash pre_update_fi.sh"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$root_pwd\r"}
            }
            expect "*assword:"
            send "$root_pwd\r"
            expect "*assword:"
            send "$admin_pwd\r"
            set timeout 1800
            expect eof
END

    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: start to get prework result "
    log_info "${LINENO}" "$product_name: start to get prework result "
    expect <<END
            spawn scp -p root@${mainOms}:/opt/fiupdate/log/pre_update_8021.log  /opt/fiupdate/log/
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$root_pwd\r"}
            }
            set timeout 180
            expect eof
END

    if [ ! -f "/opt/fiupdate/log/pre_update_8021.log" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: Prework Run Failed "
        log_error "${LINENO}" "$product_name: Prework Run Failed "
        return 1
    fi

    runresult=`cat /opt/fiupdate/log/pre_update_8021.log | grep 'run odae precheck script success'`

    if [ ! -n "$runresult" ]
    then
        expect <<END
                spawn ssh -t root@${mainOms} "cd /opt/fiupdate ; bash pre_update_fi.sh"
                expect {
                "*yes/no*" {send "yes\r";exp_continue}
                "assword:" {send "$root_pwd\r"}
                }
                expect "*assword:"
                send "$root_pwd\r"
                expect "*assword:"
                send "$admin_pwd\r"
                set timeout 1800
                expect eof
END

        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: start to get prework result again"
        log_info "${LINENO}" "$product_name: start to get prework result again"
        expect <<END
                spawn scp -p root@${mainOms}:/opt/fiupdate/log/pre_update_8021.log  /opt/fiupdate/log/
                expect {
                "*yes/no*" {send "yes\r";exp_continue}
                "assword:" {send "$root_pwd\r"}
                }
                set timeout 180
                expect eof
END
    
        if [ ! -f "/opt/fiupdate/log/pre_update_8021.log" ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: Prework Run Failed again"
            log_error "${LINENO}" "$product_name: Prework Run Failed again"
            return 1
        fi
        
        runresult=`cat /opt/fiupdate/log/pre_update_8021.log | grep 'run odae precheck script success'`
        
        if [ ! -n "$runresult" ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: Prework Run Failed again"
            log_error "${LINENO}" "$product_name: Prework Run Failed again"
            return 1
        fi
    fi
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: Prework Run Success "
    log_info "${LINENO}" "$product_name: Prework Run Success "
    
    return 0
}



function unset_parameters()
{
    unset root_pwd
    unset admin_pwd
}


function Main()
{
    log_info "${LINENO}" "start to update fi to 8.0.2.1"
    log_info "${LINENO}" "start to output product info"
    if [ ! -d "$product_dir" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] product conf dir not exists ,please run safeunlock.sh"
        log_error "${LINENO}" "product conf dir not exists ,please run safeunlock.sh"
        return 1
    fi
    product_all=`find $product_dir/ -name "node*.ini" -type f`
    if [ ! -n "$product_all" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] the product config file not exists,please check"
        log_error "${LINENO}" " the product config file not exists,please check"
        return 1
    else
        log_info "${LINENO}" "precheck the product config file success"
    fi
    for i in ${product_all}
    do
    {
        product_one=$(basename $i .ini|sed 's/nodes_//g')
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to do $product_one product"
        log_info "${LINENO}" "Start to do $product_one product"
        break_out=`cat $i|grep 'prework=0'`
        if [ -n "${break_out}" ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] config show $product_one product break prework stage"
            log_info "${LINENO}" " config show $product_one product break prework stage"
            continue
        else
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] config show $product_one product not break prework stage"
            log_info "${LINENO}" " config show $product_one product not break prework stage"
        fi
        get_mainoms_ip $product_one
        if [ $? -ne 0 ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_one: prework get mainoms ip failed"
            log_error "${LINENO}" " $product_one: prework get mainoms ip failed"
            return 1
        fi     
        runpre $product_one
        if [ $? -ne 0 ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`]  $product_one: prework run odae precheck failed"
            log_error "${LINENO}" " $product_one: prework run odae precheck failed"
            return 1
        fi
    
    }
    done
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] script in stage Prepare all FI system success"
    log_info "${LINENO}" "script in stage Prepare all FI system success"
    
    return 0
}



get_cur_path
cd "${work_curPath}"

init_log || return $?

Main
mainresult=$?
unset_parameters
exit $mainresult



