#!/bin/bash

declare -r fi_update_work="/opt/fiupdate"
declare fi_update_log=''
declare work_curPath=''
declare pro_info="NCE_info"
declare fiweb=''
declare analyzer_scene=''
declare analyzer_scale=''
declare update_config=''
declare oms_config=''
declare real_config=''
declare real_dir=''
declare root_pwd=''
declare admin_pwd=''
declare mainOms=''
declare odae_work='/opt/fiupgrade'
declare SysVer
declare SysVerDetail
declare analyzer_nodes=''
declare fi_version=''
declare product_dir='/opt/fiupdate/NCE_info'

TMOUT=0
User_ID=`/usr/bin/id -u`
if [ $User_ID -ne 0 ] 
then
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run user must be root"
    exit 1
fi
read -s -p "please input root password:" root_pwd
echo -e "\n"

read -s -p "please input FI admin password:" admin_pwd
echo -e "\n"

root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")

SysVerInfo=`cat /etc/os-release`
if [[ "$SysVerInfo" =~ "SLES" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE"
    SysVer="SUSE"
    if [[ "$SysVerInfo" =~ "12.2" ]];then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE12SP2" 
        SysVerDetail="SUSE12SP2"
    elif [[ "$SysVerInfo" =~ "12.4" ]];then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE12SP4" 
        SysVerDetail="SUSE12SP4"
    else
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is Suse, but not SUSE12SP2 and SUSE12SP4"
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] FI cannot update"
        exit 1
    fi
elif [[ "$SysVerInfo" =~ "EulerOS" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is EulerOS"
    SysVer="EulerOS"
    SysVerDetail="EULER2SP5"
else
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is not SUSE,is not EulerOS"
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] FI cannot update"
    exit 1
fi

function get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    work_curPath="${PWD}"
    fi_scriptName="$(basename "${BASH_SOURCE-$0}")"
    cd - >/dev/null
}

logDef()
{
    local funcName="$1"; shift
    local logLevel="$1"; shift
    local lineNO="$1"; shift

    local logTime="$(date -d today +'%Y-%m-%d %H:%M:%S')"
    printf "[${logTime}] ${logLevel} $* [${g_scriptName}(${funcName}):${lineNO}]($$)\n" \
        >> "${fi_update_log}" 2>&1
}

log_error()
{
    logDef "${FUNCNAME[1]}" "ERROR" "$@"
}

log_info()
{
    logDef "${FUNCNAME[1]}" "INFO" "$@"
}

function init_log()
{
    if [ ! -d "$fi_update_work/log" ]
    then
        mkdir "$fi_update_work/log"
    fi
    fi_update_log="$fi_update_work/log/pre_update_cluster_8021.log"
    [ ! -f "${fi_update_log}" ] && touch "${fi_update_log}"
    chmod 600 "${fi_update_log}"
    chown -R ossadm:ossgroup $fi_update_work/log
}

function set_premeters()
{

    if [ ! -f "/opt/fiupdate/conf/nodes.ini" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI nodes information config not exists"
        log_error "${LINENO}" "FI nodes information config not exists"
        return 1
    fi
    analyzer_nodes=`cat /opt/fiupdate/conf/nodes.ini|grep Analyzer_Calc`
    analyzer_scene=`cat /opt/fiupdate/conf/nodes.ini|grep feature |sed 's/feature=//g'|awk -F ';' '{print $1}'`
    analyzer_scene=`echo $analyzer_scene | tr A-Z a-z`
    analyzer_scale=`cat /opt/fiupdate/conf/nodes.ini|grep feature |sed 's/feature=//g'|awk -F ';' '{print $2}'`
    analyzer_scale=`echo $analyzer_scale | tr A-Z a-z`
    fiweb=`cat /opt/fiupdate/conf/nodes.ini|grep fiweb | sed  's/fiweb=//g'`
    mainOms=`cat /opt/fiupdate/conf/nodes.ini |grep mainOms= |sed 's/mainOms=//g'`
    fi_version=`cat /opt/fiupdate/conf/nodes.ini |grep fi_version= |sed 's/fi_version=//g'`
    product_all=`find $product_dir/ -name "node*.ini" -type f`
    if [ ! -n "$product_all" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] the product config file not exists,please check"
        log_error "${LINENO}" " the product config file not exists,please check"
        return 1
    else
        log_info "${LINENO}" "precheck the product config file success"
    fi
    for i in ${product_all}
    do
    {
        product_one=$(basename $i .ini|sed 's/nodes_//g')
        productinfo=`cat /opt/fiupdate/NCE_info/product_${product_one}.json`
        productdesc=${productinfo#*productdesc}
        productdesc=${productdesc%%,*}
        if [[ "$productdesc" == *Home* ]]
        then
            if [[ "$productdesc" == *SaaS* ]]
            then
                analyzer_scene="fan_home"
                log_info "${LINENO}" "Analyzer_scene does contain Home, Change analyzer_scene to fan_home."
                echo "Analyzer_scene does contain Home, Change analyzer_scene to fan_home."
            elif [[ "$productdesc" == *NCE-FAN* ]]
            then
                analyzer_scene="fan_home"
                log_info "${LINENO}" "Analyzer_scene does contain Home, Change analyzer_scene to fan_home."
                echo "Analyzer_scene does contain Home, Change analyzer_scene to fan_home."
            fi
        else
            log_info "${LINENO}" "Analyzer_scene does not contain Home, do nothing."
            echo "Analyzer_scene does not contain Home, do nothing."
        fi       
    }
    done
    return 0
}

function set_configfile()
{
    if [ ! -f "/opt/fiupdate/conf/FI_u2000.json" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI_u2000 config file  not exists"
        log_error "${LINENO}" "FI u2000 config file not exists"
        return 1
    fi
    sed -i "s/BigDataAnalyzer_float01_ip/$fiweb/g"  /opt/fiupdate/conf/FI_u2000.json
    update_config=$fi_update_work/conf/$analyzer_scene/$analyzer_scale/ficluster_conf.json
    oms_config=$fi_update_work/conf/$analyzer_scene/$analyzer_scale/fiscript_conf.json
    default_config=$fi_update_work/conf/ficluster_conf.json
    if [ ! -f "${update_config}" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] match scene scale config file  not exists, will do not use config file"
        log_info "${LINENO}" "match scene scale config file  not exists, will do not use config file"
		echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] update fi cluster config file is null "
        log_info "${LINENO}" "update fi cluster config file is null "
    else
        real_config=$update_config
        real_dir=$fi_update_work/conf/$analyzer_scene/$analyzer_scale/
		echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] update fi cluster config file is $real_config "
        log_info "${LINENO}" "update fi cluster config file is $real_config "
    fi
    
    return 0
           
}

function update_cluster()
{
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] use ODAE script to update fi cluster config file is  $real_config "
    log_info "${LINENO}" "update fi cluster config file is $real_config "
	
    if [ ! -f "$odae_work/ODAEDeployTool/bin/update_fi_cluster_config.sh" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] ODAE script not exists, please check "
        log_error "${LINENO}" "ODAE script not exists, please check "
        return 1
    fi
	
    update_config=$fi_update_work/conf/$analyzer_scene/$analyzer_scale/ficluster_conf.json
    oms_config=$fi_update_work/conf/$analyzer_scene/$analyzer_scale/fiscript_conf.json
    default_config=$fi_update_work/conf/ficluster_conf.json
    if [ -f "${update_config}" ]
    then
        real_config=$update_config
        real_dir=$fi_update_work/conf/$analyzer_scene/$analyzer_scale/
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] use ODAE script to update fi cluster premeters "
        log_info "${LINENO}" "use ODAE script to update fi cluster premeters "
        cp -f $fi_update_work/conf/FI_u2000.json  $odae_work/ODAEDeployTool/etc/datamodel
        cp -f $fi_update_work/py_work/edit_cluster.pyc $real_dir
        cd $real_dir && ${fi_update_work}/ODAESwiftDeployPlugin/ODAEDeployTool/rtsp/python/bin/python edit_cluster.pyc
        if [ ! -f "$real_dir/ficluster_conf_new.json" ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] recreate fi cluster conf failed, please check "
            log_error "${LINENO}" "recreate fi cluster conf failed , please check "
            return 1
        fi
        for i in ${analyzer_nodes}
        do
        {
            analyzer_node=`echo ${i}|cut -d '=' -f 1`
            analyzer_ip=`echo ${i}|cut -d '=' -f 2`
            analyzer_result=`cat ${real_dir}/ficluster_conf_new.json | grep ${analyzer_node}`
            if [ -n "${analyzer_result}" ]
            then
                echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] ${analyzer_node} need to be replaced "
                log_info "${LINENO}" "${analyzer_node} need to be replaced "
                sed -i "s/\${${analyzer_node}_eth0_ip}/${analyzer_ip}/g" ${real_dir}/ficluster_conf_new.json
            fi
        }
        done
    
        cp -f $real_dir/ficluster_conf_new.json $odae_work/ODAEDeployTool/etc/datamodel/ficluster_conf.json
        chown -R omm:wheel $odae_work/ODAEDeployTool/etc/datamodel/*
        cd /opt/
        if [ -f "${update_config}" ] && [ -n "${analyzer_scene}" ] && [ -n "${analyzer_scale}" ]
        then
            cp -r $odae_work/ODAEDeployTool/etc/datamodel /opt/huawei/Bigdata/ODAEFITool/etc/
            chown -R omm:wheel /opt/huawei/Bigdata/ODAEFITool/etc/datamodel/*
            chmod 600 -R /opt/huawei/Bigdata/ODAEFITool/etc/datamodel/*		
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] match scene scale config file exists, will reconfig cluster "
            log_info "${LINENO}" "match scene scale config file exists, will reconfig cluster"
            expect <<END
            spawn su - omm -c "bash /opt/huawei/Bigdata/ODAEFITool/bin/update_fi_cluster_config.sh -m"
            expect "*assword*"
            send "$admin_pwd\r"
            set timeout 600
            expect eof
END

        fi
    else
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] match scene scale config file not exists, still use 651 cluster parameters "
        log_error "${LINENO}" "match scene scale config file not exists, still use 651 cluster parameters "
    fi
    
    return 0
           
}

function unset_parameters()
{
    unset admin_pwd
	unset root_pwd
}

function Main()
{
    log_info "${LINENO}" "pre update cluster work for update fi to 8.0.2.1"    
    set_premeters
    set_configfile
    update_cluster
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`]pre update cluster work failed"
        log_error "${LINENO}" "pre update cluster work failed"
        return 1
    fi
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`]pre update cluster stage work success"
    log_info "${LINENO}" "pre update cluster stage work success"
 
    
    return 0    
}


get_cur_path
cd "${work_curPath}"

init_log || return $?

Main
mainresult=$?
unset_parameters
exit $mainresult
