#!/bin/bash

declare -r fi_update_work="/opt/fiupdate"
declare fi_update_log=''
declare work_curPath=''
declare product_dir='/opt/fiupdate/NCE_info'
declare root_pwd=''
declare -a nodesip

TMOUT=0
User_ID=`/usr/bin/id -u`
if [ $User_ID -ne 0 ] 
then
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run user must be root"
    exit 1
fi

read -s -p "please input ossadm password:" ossadm_pwd
echo -e "\n"

read -s -p "please input root password:" root_pwd
echo -e "\n"

ossadm_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${ossadm_pwd}")
root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")

function get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    work_curPath="${PWD}"
    fi_scriptName="$(basename "${BASH_SOURCE-$0}")"
    cd - >/dev/null
}

logDef()
{
    local funcName="$1"; shift
    local logLevel="$1"; shift
    local lineNO="$1"; shift

    local logTime="$(date -d today +'%Y-%m-%d %H:%M:%S')"
    printf "[${logTime}] ${logLevel} $* [${g_scriptName}(${funcName}):${lineNO}]($$)\n" \
        >> "${fi_update_log}" 2>&1
}

log_error()
{
    logDef "${FUNCNAME[1]}" "ERROR" "$@"
}

log_info()
{
    logDef "${FUNCNAME[1]}" "INFO" "$@"
}

function init_log()
{
    if [ ! -d "$fi_update_work/log/" ]
    then
        mkdir "$fi_update_work/log/"
    fi
    
    fi_update_log="$fi_update_work/log/restart_all_odae.log"
    [ ! -f "${fi_update_log}" ] && touch "${fi_update_log}"
    chmod 600 "${fi_update_log}"
    echo > ${fi_update_log}
    
}

trap 'onCtrlC' INT
function onCtrlC () {
    echo 'exit program'
    exit 1
}


function scpfile()
{
    product_name=$1
    if [ ! -f "/opt/fiupdate/NCE_info/nodes_${product_name}.ini" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: FI nodes config file not exists,please check"
        log_error "${LINENO}" "$product_name: platform nodelist json not exists,please check"
        return 1
    fi
    mainOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep mainOms= |sed 's/mainOms=//g'`
    return 0
    
}

function runsingle()
{
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] begin restart odae at node : $1"
    odaenode=$1
    expect <<END
            spawn scp -p /opt/fiupdate/restart_odae_fi.sh ossadm@${odaenode}:/tmp
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$ossadm_pwd\r"}
            }
            set timeout -1
            expect eof
END

    expect <<END
            spawn scp -p /opt/fiupdate/restart_odae_fi_ossadm.sh ossadm@${odaenode}:/tmp
            expect {
            "assword:" {send "$ossadm_pwd\r"}
            }
            set timeout -1
            expect eof
END

    expect <<END
            spawn ssh -t ossadm@${odaenode} "cd /tmp ; bash restart_odae_fi_ossadm.sh"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$ossadm_pwd\r"}
            }
            
            expect {
                "assword:" {send "$root_pwd\r"}
            }
            set timeout -1
            expect eof
END

    expect <<END
            spawn ssh -t ossadm@${odaenode} "cd /tmp ; rm -f restart_odae_fi*.sh"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$ossadm_pwd\r"}
            }
            set timeout -1
            expect eof
END
}


function runRestart()
{
    product_name=$1
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name:  start to restart all FI nodes ODAE services "
    log_info "${LINENO}" " $product_name:  start to restart all FI nodes ODAE services "
    nodes_info=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep finode= |sed 's/finode=//g'`
    mainOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep mainOms= |sed 's/mainOms=//g'`
    backupOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep backupOms= |sed 's/backupOms=//g'`
    nodesip=()
    nodesip[0]=$mainOms
    if [ "x$backupOms" != "x" ]
    then
        nodesip[1]=$backupOms
    else
        nodesip[1]=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep SINGLE_ODAE_NODE | awk -F'=' '{print $2}'`
    fi
    i=2
    for j in ${nodes_info}
    do
    {
        nodesip[${i}]=$j
        let i++
    }
    done
    
    tmp_fifofile="/tmp/$$.fifo"
    mkfifo $tmp_fifofile
    exec 6<>$tmp_fifofile
    rm $tmp_fifofile

    thread_num=5
    for ((i=0;i<${thread_num};i++));do
        echo
    done >&6

    for nodeip in ${nodesip[@]};do
        read -u6
        {
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name:  start to restart ${nodeip} ODAE services "
            log_info "${LINENO}" " $product_name:  start to restart ${nodeip} ODAE services "
            runsingle $nodeip
        } &
        echo >&6
    done

    wait
    exec 6>&-
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name:  finish to restart all FI nodes ODAE services "
    log_info "${LINENO}" " $product_name:  finish to restart all FI nodes ODAE services "
    return 0
    
    
}



function unset_parameters()
{
    unset root_pwd
}


function Main()
{
    log_info "${LINENO}" "start to restart all FI nodes ODAE services"
    if [ ! -d "$product_dir" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] product conf dir not exists ,please run safeunlock.sh"
        log_error "${LINENO}" "product conf dir not exists ,please run safeunlock.sh"
        return 1
    fi
    product_all=`find $product_dir/ -name "node*.ini" -type f`
    for i in ${product_all}
    do
    {
        product_one=$(basename $i .ini|sed 's/nodes_//g')
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to do $product_one product"
        log_info "${LINENO}" "Start to do $product_one product"
        break_out=`cat $i|grep 'restartODAE=0'`
        if [ -n "${break_out}" ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] config show $product_one product break restartODAE stage"
            log_info "${LINENO}" " config show $product_one product break restartODAE stage"
            continue
        else
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] config show $product_one product not break restartODAE stage"
            log_info "${LINENO}" " config show $product_one product not break restartODAE stage"
        fi
        runRestart $product_one
        if [ $? -ne 0 ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_one: restart all FI nodes ODAE services failed"
            log_error "${LINENO}" " $product_one: restart all FI nodes ODAE services failed"
            return 1
        fi     

    }
    done
    
    return 0
}



get_cur_path
cd "${work_curPath}"

init_log || return $?

Main
mainresult=$?
unset_parameters
exit $mainresult



