#!/bin/bash

declare -r fi_update_work="/opt/fiupdate"
declare fi_update_log=''
declare work_curPath=''
declare root_pwd=''
declare admin_pwd=''
declare mainOms=''
declare analyzer_scale=''
declare analyzer_scene=''
declare fiweb=''
declare odae_work='/opt/fiupgrade'
declare SysVer
declare SysVerDetail

SysVerInfo=`cat /etc/os-release`
if [[ "$SysVerInfo" =~ "SLES" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE"
    SysVer="SUSE"
    if [[ "$SysVerInfo" =~ "12.2" ]];then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE12SP2" 
        SysVerDetail="SUSE12SP2"
    elif [[ "$SysVerInfo" =~ "12.4" ]];then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE12SP4" 
        SysVerDetail="SUSE12SP4"
    else
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is Suse, but not SUSE12SP2 and SUSE12SP4"
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] FI cannot update"
        exit 1
    fi
elif [[ "$SysVerInfo" =~ "EulerOS" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is EulerOS"
    SysVer="EulerOS"
    SysVerDetail="EULER2SP5"
else
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is not SUSE,is not EulerOS"
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] FI cannot update"
    exit 1
fi

TMOUT=0
User_ID=`/usr/bin/id -u`
if [ $User_ID -ne 0 ] 
then
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run user must be root"
    exit 1
fi
read -s -p "please input root password:" root_pwd
echo -e "\n"

root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")


function get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    work_curPath="${PWD}"
    fi_scriptName="$(basename "${BASH_SOURCE-$0}")"
    cd - >/dev/null
}

logDef()
{
    local funcName="$1"; shift
    local logLevel="$1"; shift
    local lineNO="$1"; shift

    local logTime="$(date -d today +'%Y-%m-%d %H:%M:%S')"
    printf "[${logTime}] ${logLevel} $* [${g_scriptName}(${funcName}):${lineNO}]($$)\n" \
        >> "${fi_update_log}" 2>&1
}

log_error()
{
    logDef "${FUNCNAME[1]}" "ERROR" "$@"
}

log_info()
{
    logDef "${FUNCNAME[1]}" "INFO" "$@"
}

function init_log()
{
    if [ ! -d "$fi_update_work/log/" ]
    then
        mkdir "$fi_update_work/log/"
    fi
    fi_update_log="$fi_update_work/log/rollback_update_8021.log"
    [ ! -f "${fi_update_log}" ] && touch "${fi_update_log}"
    chmod 600 "${fi_update_log}"
    echo > ${fi_update_log}
       
}

function rollwork()
{
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] start to check rollback env"
    log_info "${LINENO}" "start to check rollback env "
    
    cd /opt
    if [ -f "/opt/FusionInsight_SetupTool/upgrade/etc/preinstall.ini" ]
    then
        rm -f /opt/FusionInsight_SetupTool/upgrade/etc/preinstall.ini
    fi
    
    if [ "$SysVerDetail" == "SUSE12SP2" ]
    then
        cp -f $fi_update_work/conf/preinstall/SUSE12SP2_preinstall.ini /opt/FusionInsight_SetupTool/upgrade/etc/preinstall.ini > /dev/null 2>&1
    fi
    
    if [ "$SysVerDetail" == "SUSE12SP4" ]
    then
        cp -f $fi_update_work/conf/preinstall/SUSE12SP4_preinstall.ini /opt/FusionInsight_SetupTool/upgrade/etc/preinstall.ini > /dev/null 2>&1
    fi
    
    if [ "$SysVerDetail" == "EULER2SP5" ]
    then
        cp -f $fi_update_work/conf/preinstall/EULER2SP5_preinstall.ini /opt/FusionInsight_SetupTool/upgrade/etc/preinstall.ini > /dev/null 2>&1
    fi
    
    if [ -f "/opt/FusionInsight_SetupTool/upgrade/upgrade_setup.sh" ]
    then
        sed -i 's/g_add_pkg=1/g_add_pkg=0/g' /opt/FusionInsight_SetupTool/upgrade/upgrade_setup.sh
    fi
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run odae rollback script success"
    log_info "${LINENO}" "run odae rollback script success"
    
    return 0
}

function set_premeters()
{

    if [ ! -f "/opt/fiupdate/conf/nodes.ini" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI nodes information config not exists"
        log_error "${LINENO}" "FI nodes information config not exists"
        return 1
    fi
    analyzer_scene=`cat /opt/fiupdate/conf/nodes.ini|grep feature |sed 's/feature=//g'|awk -F ';' '{print $1}'`
    analyzer_scale=`cat /opt/fiupdate/conf/nodes.ini|grep feature |sed 's/feature=//g'|awk -F ';' '{print $2}'`
    fiweb=`cat /opt/fiupdate/conf/nodes.ini|grep fiweb | sed  's/fiweb=//g'`
    mainOms=`cat /opt/fiupdate/conf/nodes.ini |grep mainOms= |sed 's/mainOms=//g'`
     
}

function unset_parameters()
{
    unset admin_pwd
    unset root_pwd
    unset fiweb
}


function Main()
{
    log_info "${LINENO}" "use ODAE RollScript to update fi to 651"
    set_premeters
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] rollwork set parameters failed"
        log_error "${LINENO}" "rollwork set paramters failed"
        return 1
    fi
    rollwork
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] rollwork run odae rollback script failed"
        log_error "${LINENO}" "rollwork run odae rollback script failed"
        return 1
    fi
    log_info "${LINENO}" "rollwork Run Success " 
    return 0    
}


get_cur_path
cd "${work_curPath}"

init_log || return $?

Main
mainresult=$?
unset_parameters
exit $mainresult
