#!/bin/bash

declare finode=/opt/fiupdate/NCE_info/nodes.ini
declare -r work_path="/opt/fiupdate"
declare lock_log=''
declare work_curPath=''
declare info_path="/opt/fiupdate/NCE_info"
declare product_dir='/opt/fiupdate/NCE_info'
declare ossadm_pwd=''
declare root_pwd=''
declare admin_pwd=''
declare whouser=''
declare mode=''


TMOUT=0
whouser=`whoami`
if [ "$whouser" == "root" ]
then
    read -s -p "please input root password:" root_pwd
    echo -e "\n"
fi

if [ "$whouser" == "ossadm" ]
then
    read -s -p "please input ossadm password:" ossadm_pwd
    echo -e "\n"
    
    read -s -p "please input root password:" root_pwd
    echo -e "\n"
    
    ossadm_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${ossadm_pwd}")
fi

root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
   
function get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    work_curPath="${PWD}"
    fi_scriptName="$(basename "${BASH_SOURCE-$0}")"
    cd - >/dev/null
}

logDef()
{
    local funcName="$1"; shift
    local logLevel="$1"; shift
    local lineNO="$1"; shift

    local logTime="$(date -d today +'%Y-%m-%d %H:%M:%S')"
    printf "[${logTime}] ${logLevel} $* [${g_scriptName}(${funcName}):${lineNO}]($$)\n" \
        >> "${lock_log}" 2>&1
}

log_error()
{
    logDef "${FUNCNAME[1]}" "ERROR" "$@"
}

log_info()
{
    logDef "${FUNCNAME[1]}" "INFO" "$@"
}

function init_log()
{
    if [ ! -d "$work_path/log/" ]
    then
        mkdir "$work_path/log/"
    fi
    lock_log="$work_path/log/lock_safe.log"
    [ ! -f "${lock_log}" ] && touch "${lock_log}"
    chmod 600 "${lock_log}"
    echo > ${lock_log}
    
}

function lockDao()
{

    product_name=$1
    if [ ! -f "/opt/fiupdate/NCE_info/nodes_${product_name}.ini" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: FI nodes config file not exists,please check"
        log_error "${LINENO}" "$product_name: platform nodelist json not exists,please check"
        return 1
    fi
    mode=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep mode= |sed 's/mode=//g'`
    if [ "$mode" == "single" ]
    then
        mainOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep mainOms= |sed 's/mainOms=//g'`
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] start to lock safe in FI mainOms node:${mainOms}"
        log_info "${LINENO}" "start to lock safe in FI mainOms node:${mainOms}"
        nodeDao ${mainOms}
        backupOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep SINGLE_ODAE_NODE | awk -F'=' '{print $2}'`
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] start to lock safe in FI SINGLE_ODAE_NODE:${backupOms}"
        log_info "${LINENO}" "start to lock safe in FI SINGLE_ODAE_NODE:${backupOms}"
        nodeDao ${backupOms}
    fi
    
    
    if [ "$mode" == "double" ]
    then
        nodes_info=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep finode= |sed 's/finode=//g'`
        mainOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep mainOms= |sed 's/mainOms=//g'`
        backupOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep backupOms= |sed 's/backupOms=//g'`
        
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] start to lock safe in FI mainOms node:${mainOms}"
        log_info "${LINENO}" "start to lock safe in FI mainOms node:${mainOms}"
        nodeDao ${mainOms}
            
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] start to lock safe in FI backupOms node:${backupOms}"
        log_info "${LINENO}" "start to lock safe in FI backupOms node:${backupOms}"
        nodeDao ${backupOms}
        
        for nodeip in ${nodes_info}
        do
        {
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] start to lock safe in node:${nodeip}"
            log_info "${LINENO}" "start to lock safe in node:${nodeip}"
            nodeDao ${nodeip}
        }
        done
    fi
    

}

function nodeDao()
{
    nodeip=$1
    if [ "$whouser" == "ossadm" ]
    then
        expect <<END
                spawn ssh -t ossadm@${nodeip} "su - root -c 'cd /opt/SEK/cmd;sh RollBackEnv.sh'"
                expect {
                "*yes/no*" {send "yes\r";exp_continue}
                "*assword:" {send "$ossadm_pwd\r"}
                }
                expect "*assword:"
                send "$root_pwd\r"
                set timeout 600
                expect eof
END
    fi
    
    if [ "$whouser" == "root" ]
    then
        expect <<END
            spawn ssh -t root@${nodeip} "cd /opt/SEK/cmd;sh RollBackEnv.sh"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "*assword:" {send "$root_pwd\r"}
            }
            set timeout 600
            expect eof
END
    
    fi
}

function CheckPwd()
{
    if [ "$whouser" == "root" ]
    then
        if [[ $root_pwd =~ " " ]]
        then
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] the root password you input is valid" 
            return 1
        fi
    fi
    
    if [ "$whouser" == "ossadm" ]
    then
        if [[ $root_pwd =~ " " ]]
        then
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] the root password you input is valid" 
            return 1
        fi
        if [[ $ossadm_pwd =~ " " ]]
        then
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] the ossadm password you input is valid" 
            return 1
        fi
    fi
   
    return 0
    
}

function CheckUser()
{
    User_ID=`/usr/bin/id -u`
    if [ $User_ID -ne 0 ] 
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run user must be root"
        log_error "${LINENO}" "run user must be root"
        return 1
    fi
    return 0
}

function unset_parameter()
{
    unset admin_pwd
    unset ossadm_pwd
    unset root_pwd
    unset whouser

}

function set_timeout()
{
    if [ -f "/etc/bashrc" ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] start to check sys tmout"
        log_info "${LINENO}" "start to check sys tmout"
        tmresult=`cat /etc/bashrc|grep TMOUT`
        if [ ! -n "$tmresult" ]
        then
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout not need to change"
            log_info "${LINENO}" "sys tmout not need to change"
            return 0
        fi
        cat /etc/bashrc |grep TMOUT |while read tmout_sys
        do
            if [ ! -n "$tmout_sys" ]
            then
                echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout not need to change"
                log_info "${LINENO}" "sys tmout not need to change"
            else
                echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout need to change" 
                log_info "${LINENO}" "sys tmout need to change"
                if [[ "$tmout_sys" =~ "export" ]]
                then
                    sed -i "s/$tmout_sys/export TMOUT=400/g" /etc/bashrc
                    source /etc/bashrc
                    echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout change success,is to set $TMOUT" 
                    log_info "${LINENO}" "sys tmout change success,is to set $TMOUT"
                else
                    sed -i "s/$tmout_sys/TMOUT=400/g" /etc/bashrc
                    source /etc/bashrc
                    echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout change success,is to set $TMOUT" 
                    log_info "${LINENO}" "sys tmout change success,is to set $TMOUT"
                fi
            fi
        done
    fi
    service sshd restart
    return 0

}

function Main()
{
    log_info "${LINENO}" "start to lock all FI nodes"
    log_info "${LINENO}" "start to output product info"
    CheckPwd
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] check input password failed"
        log_error "${LINENO}" "check input password failed"
        return 1
    fi
    
    product_all=`find $product_dir/ -name "node*.ini" -type f`
    for i in ${product_all}
    do
    {
        product_one=$(basename $i .ini|sed 's/nodes_//g')
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to do $product_one product"
        log_info "${LINENO}" "Start to do $product_one product"
        
        lockDao $product_one
        if [ $? -ne 0 ] 
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_one: script in stage lock all FI nodes failed"
            log_error "${LINENO}" " $product_one: script in stage lock all FI nodes failed"
            return 1
        fi



    }
    done
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] script in stage lock all FI nodes success"
    log_info "${LINENO}" "script in stage lock all FI nodes success"
    
    cd /opt
    if [ -f "/opt/SEK/cmd/RollBackEnv.sh" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] start to lock safe nodeself"
        log_info "${LINENO}" " start to lock safe nodeself"
        cd /opt/SEK/cmd
        sh RollBackEnv.sh
    fi
    set_timeout
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] script in stage lock all FI nodes success"
    log_info "${LINENO}" "script in stage lock all FI nodes success"
    return 0
}


get_cur_path
cd "${work_curPath}"

init_log || return $?

Main

main_result=$?

unset_parameter

exit $main_result
