#!/bin/bash
declare work_path="/opt/fiupdate"
TMOUT=0
User_ID=`/usr/bin/id -u`
if [ $User_ID -ne 0 ] 
then
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run user must be root"
    exit 1
fi

read -s -p "please input admin password:" admin_pwd
admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")

fiweb=$1

if [ -f /opt/engr/py_work/stop_cluster.pyc ]
then
    rm -rf ${work_path}/ODAESwiftDeployPlugin >/dev/null 2>&1
    ODAEpluginfile=`find ${work_path}/package/ -name "ODAESwiftDeployPlugin*.zip" -type f`
    unzip ${ODAEpluginfile} -d ${work_path}/ODAESwiftDeployPlugin >/dev/null 2>&1
    bash ${work_path}/ODAESwiftDeployPlugin/ODAEDeployTool/lbin/env_profile.sh ${work_path}/ODAESwiftDeployPlugin/ODAEDeployTool >/dev/null 2>&1
    chmod -R 500 ${work_path}/ODAESwiftDeployPlugin/ODAEDeployTool/rtsp/python/bin >/dev/null 2>&1
    chown -R ossadm:ossgroup ${work_path}/ODAESwiftDeployPlugin >/dev/null 2>&1
    stop_cluster_py=/opt/engr/py_work/stop_cluster.pyc
    python=${work_path}/ODAESwiftDeployPlugin/ODAEDeployTool/rtsp/python/bin/python
else
    if [ -f /opt/python_bda/bin/python ]
    then
        python=/opt/python_bda/bin/python
    else
        python=python
    fi
    stop_cluster_py=/opt/engr/py_work/StopCluster.pyc
fi


Main()
{
    sleep 10
    cd /opt/engr/py_work
    expect <<END
        set timeout 60
        spawn ${python} ${stop_cluster_py} $fiweb
        expect {
            "*Password*" {send "$admin_pwd\r"}
            timeout {send_user "No response!\n"
                    exit 1}
        }
        set timeout 1800
        expect eof
        catch wait ret
        set exit_status [lindex \$ret 3]
        exit \$exit_status
END
}

Main
