#!/bin/bash

declare -r fi_update_work="/opt/fiupdate"
declare fi_update_log=''
declare work_curPath=''
declare root_pwd=''
declare admin_pwd=''
declare fiweb=''
declare ODAAEplugin=''
declare odae_work='/opt/fiupgrade'
declare SysVer
declare cpu
declare fi_version=''

TMOUT=0
read -s -p "please input root password:" root_pwd
echo -e "\n"

read -s -p "please input admin password:" admin_pwd
echo -e "\n"

root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")

ODAAEpluginfile=`find ${fi_update_work}/package/ -name "ODAESwiftDeployPlugin*.zip" -type f`
ODAAEplugin=`basename ${ODAAEpluginfile}`
SysVerInfo=`cat /etc/os-release`
if [[ "$SysVerInfo" =~ "SLES" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE"
    SysVer="SUSE"
    exit 1
elif [[ "$SysVerInfo" =~ "EulerOS" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is EulerOS"
    SysVer="EulerOS"
else
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is not SUSE,is not EulerOS"
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] FI cannot update"
    exit 1
fi
cpu=`uname -a`
if [[ "$cpu" =~ "aarch64" ]]; then
    cpu="ARM"
else
    cpu="x86"
fi

function get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    work_curPath="${PWD}"
    fi_scriptName="$(basename "${BASH_SOURCE-$0}")"
    cd - >/dev/null
}

logDef()
{
    local funcName="$1"; shift
    local logLevel="$1"; shift
    local lineNO="$1"; shift

    local logTime="$(date -d today +'%Y-%m-%d %H:%M:%S')"
    printf "[${logTime}] ${logLevel} $* [${g_scriptName}(${funcName}):${lineNO}]($$)\n" \
        >> "${fi_update_log}" 2>&1
}

log_error()
{
    logDef "${FUNCNAME[1]}" "ERROR" "$@"
}

log_info()
{
    logDef "${FUNCNAME[1]}" "INFO" "$@"
}

function init_log()
{
    if [ ! -d "$fi_update_work/log/" ]
    then
        mkdir "$fi_update_work/log/"
    fi
    fi_update_log="$fi_update_work/log/syscheck_fi.log"
    [ ! -f "${fi_update_log}" ] && touch "${fi_update_log}"
    chmod 600 "${fi_update_log}"
    echo > ${fi_update_log}
       
}

function check_setuptool_package()
{
    pkg=$1
    sys=$2
    cpu=$3
    version="8.0.2.1"
    cpu_name=""
    if [ "x$cpu" == "xARM" ]
    then
        cpu_name="_AArch64"
    fi
    real_pkg="$pkg""_""$version""$cpu_name"".tar.gz"
    cms="$real_pkg"".cms"
    crl="$real_pkg"".crl"
    if [ ! -f "${fi_update_work}/package/$real_pkg" ] || [ ! -f "${fi_update_work}/package/$cms" ] || [ ! -f "${fi_update_work}/package/$crl" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: package or verify file not exists,please check : $real_pkg"
        log_error "${LINENO}" "$product_name: package or verify file not exists,please check : $real_pkg"
        return 1
    fi
    cp -f $fi_update_work/package/$real_pkg*   $odae_work/ODAEDeployTool/FIPatch/
    return 0
}

function check_package()
{
    pkg=$1
    sys=$2
    cpu=$3
    version="8.0.2.1"
    cpu_name=""
    if [ "x$cpu" == "xARM" ]
    then
        cpu_name="_AArch64"
    fi
    os_name=""
    if [ "x$sys" == "xEulerOS" ]
    then
        os_name="Euler"
    fi
    real_pkg="$pkg""_""$version""_""$os_name""$cpu_name"".tar.gz"
    cms="$real_pkg"".cms"
    crl="$real_pkg"".crl"
    if [ ! -f "${fi_update_work}/package/$real_pkg" ] || [ ! -f "${fi_update_work}/package/$cms" ] || [ ! -f "${fi_update_work}/package/$crl" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: package or verify file not exists,please check : $real_pkg"
        log_error "${LINENO}" "$product_name: package or verify file not exists,please check : $real_pkg"
        return 1
    fi
    cp -f $fi_update_work/package/$real_pkg*   $odae_work/ODAEDeployTool/FIPatch/
    return 0
}

function check_updateservice_package()
{
    pkg=$1
    sys=$2
    cpu=$3
    version="8.0.2.1"
    cpu_name=""
    if [ "x$cpu" == "xARM" ]
    then
        cpu_name="_AArch64"
    fi
    os_name=""
    if [ "x$sys" == "xEulerOS" ]
    then
        os_name="Euler"
    fi
    real_pkg="$pkg""_""$version""_""$os_name""$cpu_name"".tar.gz"
    cms="$real_pkg"".cms"
    crl="$real_pkg"".crl"
    if [ ! -f "${fi_update_work}/package/$real_pkg" ] || [ ! -f "${fi_update_work}/package/$cms" ] || [ ! -f "${fi_update_work}/package/$crl" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: package or verify file not exists,please check : $real_pkg"
        log_error "${LINENO}" "$product_name: package or verify file not exists,please check : $real_pkg"
        return 1
    fi
    cp -f $fi_update_work/package/$real_pkg*   $odae_work/ODAEDeployTool/FIPatch/
    
    return 0
}

function checkwork()
{
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] start to transport and unzip package"
    log_info "${LINENO}" "start to transport and unzip package "
    
    if [ ! -f "${fi_update_work}/package/${ODAAEplugin}" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] ODAAE plugin package not exists,please check"
        log_error "${LINENO}" " ODAAE plugin package not exists,please check"
        return 1
    fi
    
    
    if [ ! -f "${fi_update_work}/conf/FI_u2000.json" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI_u2000 config file not exists,please check"
        log_error "${LINENO}" " FI_u2000 config file not exists,please check"
        return 1
    fi
    
    if [ ! -f "${fi_update_work}/conf/nodes.ini" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] nodes.ini config file not exists,please check"
        log_error "${LINENO}" " nodes.ini config file not exists,please check"
        return 1
    fi
    
    if [ "${fi_version}" != "6512" ] && [ "${fi_version}" != "6516" ] && [ "${fi_version}" != "6517" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: FI version is not 6.5.1.2 or 6.5.1.6 or 6.5.1.7"
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[41;37m ${product_name} : FI version is not 6.5.1.2 or 6.5.1.6 or 6.5.1.7\033[0m"
        log_info "${LINENO}" "$product_name: FI version is not 6.5.1.2 or 6.5.1.6 or 6.5.1.7" 
        return 1
    fi
    
    if [ -f "/opt/fiupgrade/ODAEDeployTool/bin/uninstall.sh" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] need to uninstall odae plugin env "
        log_info "${LINENO}" "need to uninstall odae plugin env "
        cd /opt/fiupgrade/ODAEDeployTool/bin/ 
        bash uninstall.sh
        if [ $? -ne 0 ] 
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] uninstall odae plugin env failed"
            log_error "${LINENO}" "uninstall odae plugin env failed"
            return 1
        fi
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] uninstall odae plugin env success"
        log_info "${LINENO}" "uninstall odae plugin env fsuccess"       
    fi
    
    cd /opt
    if [ -d "$odae_work" ]
    then
        rm -fr $odae_work
    fi
    
    if [ -d "/opt/SysChecker" ]
    then
        rm -fr /opt/SysChecker
    fi
    
    mkdir $odae_work
    cp -f $fi_update_work/package/$ODAAEplugin $odae_work
    cd $odae_work
    unzip $ODAAEplugin  >/dev/null 2>&1
    rm $odae_work/$ODAAEplugin >/dev/null 2>&1
    
    check_setuptool_package "FusionInsight_SetupTool" $SysVer $cpu
    if [ $? -ne 0 ]
    then
        return 1
    fi
    check_package "FusionInsight_BASE" $SysVer $cpu
    if [ $? -ne 0 ]
    then
        return 1
    fi
    check_package "FusionInsight_HD" $SysVer $cpu
    if [ $? -ne 0 ]
    then
        return 1
    fi
    check_package "FusionInsight_Manager" $SysVer $cpu
    if [ $? -ne 0 ]
    then
        return 1
    fi
    check_package "FusionInsight_Spark2x" $SysVer $cpu
    if [ $? -ne 0 ]
    then
        return 1
    fi
    check_updateservice_package "FusionInsight_UpdateService" $SysVer $cpu
    if [ $? -ne 0 ]
    then
        return 1
    fi

    cp -f $fi_update_work/conf/FI_u2000.json  $odae_work/ODAEDeployTool/etc/datamodel/

    if [ ! -f "$odae_work/ODAEDeployTool/bin/patch_deploy.sh" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] ODAE patch script not exists, please check "
        log_error "${LINENO}" "ODAE patch script not exists, please check "
        return 1
    fi
    cd $odae_work/ODAEDeployTool/bin/
    bash patch_deploy.sh
    if [ $? -ne 0 ] 
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run odae patch script failed"
        log_error "${LINENO}" "run odae patch script failed"
        return 1
    fi
    if [ -n "$backupOms" ]
    then
        expect <<END
            spawn scp -p -r $fi_update_work/ODAESwiftDeployPlugin root@${backupOms}:/opt
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$root_pwd\r"}
            }
            set timeout 300
            expect eof
END

        expect <<END
            spawn ssh -t root@${backupOms} "cd /opt/ODAESwiftDeployPlugin/ODAEDeployTool/bin/ ; bash patch_deploy.sh > /dev/null 2>&1 ; rm -rf /opt/ODAESwiftDeployPlugin  > /dev/null 2>&1"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$root_pwd\r"}
            }
            set timeout 600
            expect eof
END
    fi
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run syscheck script success"
    log_info "${LINENO}" "run syscheck script success"
    return 0

}

function set_premeters()
{

    if [ ! -f "${fi_update_work}/conf/nodes.ini" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI nodes information config not exists"
        log_error "${LINENO}" "FI nodes information config not exists"
        return 1
    fi
    
    if [ ! -f "${fi_update_work}/conf/FI_u2000.json" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI_u2000 config file not exists,please check"
        log_error "${LINENO}" " FI_u2000 config file not exists,please check"
        return 1
    fi
    
    fiweb=`cat ${fi_update_work}/conf/nodes.ini|grep fiweb | sed  's/fiweb=//g'`
    backupOms=`cat ${fi_update_work}/conf/nodes.ini|grep backupOms | sed  's/backupOms=//g'`
    fi_version=`cat ${fi_update_work}/conf/nodes.ini |grep fi_version= |sed 's/fi_version=//g'`
    sed -i "s/BigDataAnalyzer_float01_ip/$fiweb/g"  ${fi_update_work}/conf/FI_u2000.json
    
    return 0
     
}

function set_timeout()
{
    if [ -f "/etc/bashrc" ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] start to check sys tmout"
        log_info "${LINENO}" "start to check sys tmout"
        tmresult=`cat /etc/bashrc|grep TMOUT`
        if [ ! -n "$tmresult" ]
        then
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout not need to change"
            log_info "${LINENO}" "sys tmout not need to change"
            return 0
        fi
        cat /etc/bashrc |grep TMOUT |while read tmout_sys
        do
            if [ ! -n "$tmout_sys" ]
            then
                echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout not need to change"
                log_info "${LINENO}" "sys tmout not need to change"
            else
                echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout need to change" 
                log_info "${LINENO}" "sys tmout need to change"
                if [[ "$tmout_sys" =~ "export" ]]
                then
                    sed -i "s/$tmout_sys/export TMOUT=0/g" /etc/bashrc
                    source /etc/bashrc
                    echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout change success,is to set $TMOUT" 
                    log_info "${LINENO}" "sys tmout change success,is to set $TMOUT"
                else
                    sed -i "s/$tmout_sys/TMOUT=0/g" /etc/bashrc
                    source /etc/bashrc
                    echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout change success,is to set $TMOUT" 
                    log_info "${LINENO}" "sys tmout change success,is to set $TMOUT"
                fi
            fi
        done
    fi
    service sshd restart
    
    return 0 

}

function unset_parameters()
{
    unset admin_pwd
    unset root_pwd
    unset fiweb
}


function Main()
{
    log_info "${LINENO}" "use ODAE syscheck to check fi status"
    set_timeout
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] syscheck set timeout failed"
        log_error "${LINENO}" "syscheck set timeout failed"
        return 1
    fi
    set_premeters
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] syscheck set parameters failed"
        log_error "${LINENO}" "syscheck set paramters failed"
        return 1
    fi

    checkwork
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] syscheck run odae precheck script failed"
        log_error "${LINENO}" "syscheck run odae precheck script failed"
        return 1
    fi
    log_info "${LINENO}" "syscheck Run Success " 
    return 0    
}


get_cur_path
cd "${work_curPath}"

init_log || return $?

Main
mainresult=$?
unset_parameters
exit $mainresult
