#!/bin/bash

SELF_FILE=$(basename $0)
#check current user
function checkUser()
{
    cur_user=`id -un`
    [ ${cur_user} == "ossadm" ] && return 0
    printScreen "The script $SELF_FILE must run with ossadm user."
    exit 1
}

function printScreen()
{
    DATA=`date +"%Y-%m-%d %H:%M:%S"`
    PID=`echo $$`
    echo "[$DATA] [$PID] $1"
}

function stopAggStrategyService()
{
    . /opt/oss/manager/bin/engr_profile.sh
    
    productname="NCE"
    nodeips=`bash /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -tenant ${productname} -app AggStrategyService -nodeip global | grep "AggStrategyService" | grep "RUNNING" | awk -F " " '{print $6}'`
    for nodeip in ${nodeips}
    do
        bash /opt/oss/manager/agent/bin/ipmc_adm -cmd stopapp -tenant ${productname} -app AggStrategyService -nodeip ${nodeip} > /dev/null 2>&1
    done

    return 0
}

stopAggStrategyService &
sleep 10
exit 0