#! /bin/bash
declare ossadm_pwd=''
declare root_pwd=''
declare admin_pwd=''
log_file="update_configntp.sh.log"

GetWorkPath()
{
    dir=`/usr/bin/dirname $0`
    ispoint=`/bin/echo $dir| /usr/bin/awk -F/ '{print $1}'`
    if [ "$ispoint" = "." ]
    then
        dir=`/bin/echo $dir|/usr/bin/sed 's/^.//'`
        curpath="`pwd`$dir"
    elif [ "$ispoint" = ".." ]
    then
        curpath="`pwd`/$dir"
    else
       curpath="$dir"
    fi
    
    mkdir -p $curpath/log
    touch $curpath/log/$log_file
    
    return 0
}

InputParas()
{   
    read -s -p "please input ossadm password:" ossadm_pwd
    echo -e "\n"
    
    read -s -p "please input root password:" root_pwd
    echo -e "\n"
    
    read -s -p "please input FusionInsight admin password:" admin_pwd
    echo -e "\n"
    
    ossadm_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${ossadm_pwd}")
    root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
    admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")
}

Unlock()
{
    cd /opt/fiupdate
    expect <<END
    spawn bash safeunlock.sh
    expect {
        "please input ossadm password:" {send "$ossadm_pwd\r"}
    }
    expect {
        "please input root password:" {send "$root_pwd\r"}
    }
    expect {
        "please input FI admin password:" {send "$admin_pwd\r"}
    }
    set timeout 1200
    expect "*#"
    exit
END
}

Main()
{
    GetWorkPath
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] begin fix ntp..." >> $curpath/log/$log_file
    InputParas
    Unlock
    unlockResult=`cat ${curpath}/log/unlock_safe.log | grep "script in stage unlock all FI nodes success"`
    if [ "x${unlockResult}" == "x" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[41;30m Safe unlock is failed. \033[0m"
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Safe unlock is failed." >> $curpath/log/$log_file
        return 1
    else
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[42;34m Safe unlock is success. \033[0m"
    fi
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] begin fix ntp to upgrade FusionInsight..." >> $curpath/log/$log_file
    product_dir='/opt/fiupdate/NCE_info'
    product_all=`find $product_dir/ -name "nodes_*.ini" -type f`
    for product_ini in ${product_all}
    do
    {
        product_one=$(basename $product_ini .ini|sed 's/nodes_//g')
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to do $product_one product"
        rm -rf iptmp.conf > /dev/null 2>&1
        cat $product_ini |grep finode= |sed 's/finode=//g' >>./iptmp.conf
        cat $product_ini |grep Analyzer_Calc_Storage | awk -F "=" {'print $2'} >>./iptmp.conf
        fi_nodes=`sort -u iptmp.conf`
        for fi_node in ${fi_nodes}
        do
        expect <<END
                    spawn scp -p /opt/fiupdate/pre_config.sh root@${fi_node}:/opt
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout 600
                    expect eof
END

        expect <<END
                    spawn ssh -t root@${fi_node} "cd /opt/ ; bash pre_config.sh ntp ; bash pre_config.sh register ; bash pre_config.sh checksudo ; rm -rf /opt/pre_config.sh > /dev/null 2>&1"
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout 600
                    expect eof
END

        done
        rm -rf iptmp.conf > /dev/null 2>&1
    }
    done


}

Main $*
ret=$?
if [ $ret -eq 0 ]
then
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] fix ntp successfully."
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] fix ntp successfully." >> $curpath/log/$log_file
else
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] fix ntp failed."
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] fix ntp failed." >> $curpath/log/$log_file
fi
exit $ret
