#! /bin/bash


echo -n "es_input: os_pwd_root"
read -s os_pwd_root

echo ""

echo -n "es_input: os_pwd_ossadm"
read -s os_pwd_ossadm

echo ""

echo -n "es_input: fi_pwd_admin"
read -s fi_pwd_admin

GetWorkPath()
{
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Precheck work is start."
    dir=`/usr/bin/dirname $0`
    ispoint=`/bin/echo $dir| /usr/bin/awk -F/ '{print $1}'`
    if [ "$ispoint" = "." ]
    then
        dir=`/bin/echo $dir|/usr/bin/sed 's/^.//'`
        curpath="`pwd`$dir"
    elif [ "$ispoint" = ".." ]
    then
        curpath="`pwd`/$dir"
    else
       curpath="$dir"
    fi
    return 0
}

InputParas()
{
    whouser=`whoami`
    if [ "$whouser" != "root" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] please run this script as user 'root' "
        exit 1
    fi
    
    root_pwd=${os_pwd_root}
    ossadm_pwd=${os_pwd_ossadm}
    admin_pwd=${fi_pwd_admin}
    
    ossadm_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${ossadm_pwd}")
    root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
    admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")
}

SetRight()
{
    chown -R ossadm:ossgroup /opt/fiupdate
    chmod -R 750 /opt/fiupdate
    rm -rf /opt/fiupdate/NCE_info* > /dev/null 2>&1
}

Unlock()
{
    cd /opt/fiupdate
    expect <<END
    spawn bash safeunlock.sh
    expect {
        "please input ossadm password:" {send "$ossadm_pwd\r"}
    }
    expect {
        "please input root password:" {send "$root_pwd\r"}
    }
    expect {
        "please input FI admin password:" {send "$admin_pwd\r"}
    }
    set timeout -1
    expect "*#"
    exit
END
}

cleardataCheck()
{
    cd /opt/fiupdate
    expect <<END
    spawn bash clear_data.sh
    expect {
        "please input root password:" {send "$root_pwd\r"}
    }
    expect {
        "please input admin password:" {send "$admin_pwd\r"}
    }
    set timeout -1
    expect "*#"
    exit
END
}

Main()
{
    InputParas
    SetRight
    Unlock
    unlockResult=`cat ${curpath}/log/unlock_safe.log | grep "script in stage unlock all FI nodes success"`
    if [ "x${unlockResult}" == "x" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[41;30m Safe unlock is failed. \033[0m"
        return 1
    else
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[42;34m Safe unlock is success. \033[0m"
    fi
    cleardataCheck
    cleardatacheckResult=`cat ${curpath}/log/syscheck_clear_data.log | grep "script in stage ClearData all FI system success"`
    if [ "x${cleardatacheckResult}" == "x" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[41;30m SysCheck ClearData is failed. \033[0m"
        return 1
    else
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[42;34m SysCheck ClearData is success. \033[0m"
    fi

    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[42;34m Precheck work in stage ClearData is successfully. \033[0m"
    return 0
}

SuperMain()
{
    Main $* > ${curpath}/log/update_fi_pre_clear_data.log
    ret=$?
    if [ $ret -eq 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Precheck work in stage ClearData is successfully."
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Precheck work in stage ClearData is successfully." >> ${curpath}/log/update_fi_pre_clear_data.log
    else
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Precheck work in stage ClearData is failed."
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Precheck work in stage ClearData is failed." >> ${curpath}/log/update_fi_pre_clear_data.log
    fi
    chown -R ossadm:ossgroup ${curpath}/log/
}

GetWorkPath
mkdir ${curpath}/log > /dev/null 2>&1
SuperMain $* &
superret=$?
exit $superret
