#!/bin/bash

if [[ ${USER} != "omm" ]]; then
    echo "only the omm user can run this script, current the user is ${USER}"
    exit 1
fi

###################################################
#
# 记录操作到系统日志
#
###################################################
function sys_log()
{
    declare source="$0"
    [ -e "$source" ] && source=`/usr/bin/readlink -e $source`
    if [ $# -gt 1 ]; then
        shift 1
        source="$source $@"
    fi

    OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
    logger -t $USER -p local0.info "[$source] return code=0, kill acs success from ${OPERIP:-127.0.0.1}"
}

function main()
{
    cd /var/log/Bigdata/controller/acs/
    src_file=acs.log
    dst_file=acs_outofmem.log
    if [[ -f $src_file ]]; then
        cat $src_file | grep OutOfMemoryError > /dev/null 2>&1
        if [ $? -eq 0 ]; then
            ps -ef | grep name=acs | grep -v grep | awk '{print $2}' | xargs kill -9
            rm -f $dst_file
            mv $src_file $dst_file
            chown omm: $dst_file
            sys_log $@
            return 0
        fi
    fi
}

main
exit $?
