#!/bin/bash
################################################################################
## Copyright:   HUAWEI Tech. Co., Ltd.
## Filename:    patch_deploy.sh
## Des: 上传扩容脚本到/opt/ODAEFITool，只上传到本机节点
################################################################################
SOURCE="${BASH_SOURCE[0]}"
SCRIPT_FILE_PATH=`/usr/bin/readlink -e ${SOURCE}`
SCRIPT_DIR=`/usr/bin/dirname ${SCRIPT_FILE_PATH}`
APP_PATH=`/usr/bin/dirname ${SCRIPT_DIR}`
PYTHON_PATH=${APP_PATH}/rtsp/python/bin

echo "begin execute script..."
. ${APP_PATH}/lbin/init_deploy.sh
. ${APP_PATH}/lbin/env_profile.sh "${APP_PATH}"

function fn_main()
{
    ${PYTHON_PATH}/python ${APP_PATH}/tools/pyscript/upload_tools.pyc --local
    result=$?
    if [[ ${result} -eq 0 ]]
    then
        echo "execute script success!"
        return 0
    else
        echo "execute script failed, please check log ${APP_PATH}/var/logs/patch_deploy.log"
        return ${result}
    fi
}

fn_main
result=$?
. ${APP_PATH}/lbin/syslog.sh $0 $result $@
exit $result
