#!/bin/bash
SOURCE="${BASH_SOURCE[0]}"
SCRIPT_FILE_PATH=`/usr/bin/readlink -e ${SOURCE}`
SCRIPT_DIR=`/usr/bin/dirname ${SCRIPT_FILE_PATH}`
APP_PATH=`/usr/bin/dirname ${SCRIPT_DIR}`
PYTHON_PATH=${APP_PATH}/rtsp/python/bin

function fn_main()
{
    ${PYTHON_PATH}/python ${APP_PATH}/tools/pyscript/install_fi_shield_alarm.pyc;
    result=$?
    if [[ ${result} -eq 0 ]]
    then
        echo "shield alarm success!"
        return 0
    else
        echo "shield alarm failed, return code = ${result}"
        return ${result}
    fi
}

. ${APP_PATH}/lbin/env_profile.sh "${APP_PATH}"
fn_main "$@"
result=$?
. ${APP_PATH}/lbin/syslog.sh $0 $result $@
exit $result
