#!/bin/bash
SOURCE="${BASH_SOURCE[0]}"
SCRIPT_FILE_PATH=`/usr/bin/readlink -e ${SOURCE}`
SCRIPT_DIR=`/usr/bin/dirname ${SCRIPT_FILE_PATH}`
APP_PATH=`/usr/bin/dirname ${SCRIPT_DIR}`
PYTHON_PATH=${APP_PATH}/rtsp/python/bin

. ${APP_PATH}/lbin/env_profile.sh "${APP_PATH}"

function fn_main()
{
    ${PYTHON_PATH}/python ${APP_PATH}/tools/upgrade/upgrade_install_updateservice/upgrade_install_updateservice.pyc $1 $2;
    updateservice_result=$?
    if [[ ${updateservice_result} -eq 0 ]]
    then
        echo "upgrade install updateservice success!"
        return 0
    else
        echo "upgrade install updateservice failed, return code = ${updateservice_result}"
        return ${updateservice_result}
    fi
}

fn_main "$@"
result=$?
. ${APP_PATH}/lbin/syslog.sh $0 $result $@
exit $result
