#!/bin/bash
################################################################################
## Copyright:   HUAWEI Tech. Co., Ltd.
## Filename:    upgrade_modify_fi_oms_conf.sh
## Des: 修改FI的OMS参数，升级和补丁场景调用
################################################################################

SOURCE="${BASH_SOURCE[0]}"
SCRIPT_FILE_PATH=`/usr/bin/readlink -e ${SOURCE}`
SCRIPT_DIR=`/usr/bin/dirname ${SCRIPT_FILE_PATH}`
APP_PATH=`/usr/bin/dirname ${SCRIPT_DIR}`
PYTHON_PATH=${APP_PATH}/rtsp/python/bin

. ${APP_PATH}/lbin/env_profile.sh "${APP_PATH}"
if [[ ! $1 ]]; then
    ${PYTHON_PATH}/python ${APP_PATH}/tools/util/fi_backend_modification/modify_fi_oms_conf.pyc "upgrade"
else
    ${PYTHON_PATH}/python ${APP_PATH}/tools/util/fi_backend_modification/modify_fi_oms_conf.pyc "upgrade" $1
fi

result=$?
if [ ${result} -ne 0 ]; then
    echo "Modify OMS configuration failed."
fi
. ${APP_PATH}/lbin/syslog.sh $0 $result $@
exit $result
