#!/bin/bash

OPERIP=`/usr/bin/who am i | /usr/bin/awk '{print $NF}' | /usr/bin/sed 's/[()]//g'`
USER=`/usr/bin/whoami`
# Importance: If the app_profile.sh sourced by other shell script and not specify arguments, the args is inherit from the parent script.
# arg1 is the APP_ROOT
if [[ ! -z "$1" ]] && [[ -f "$1"/pub/app_define.json ]]; then
    APP_ROOT=$1
    # arg2 is the PROCESS_NAME
    if [[ ! -z "$2" ]]; then
        PROCESS_NAME=$2
    fi
fi

if [ -z "${APP_ROOT}" -o ! -f "${APP_ROOT}"/pub/app_define.json ]; then
    echo "ERROR: APP_ROOT not exsit or invalid!"
    echo "Usage: . app_profile.sh APP_ROOT PROCESS_NAME"
    return
fi

RECORDE_FLAG="false"
#export env variable defined in the specified file
exportEnvsFromFile()
{
    filePath=$1
    fileName=`/usr/bin/basename filePath`
    if [ -z "${filePath}" -o ! -f "${filePath}" ]; then
        echo "ERROR: env file ./${fileName} not exsit!"
        return
    fi

    while read line
    do
        if [[ $line =~ ^#.* ]]; then
            continue
        fi

        key=`echo $line | awk -F '=' '{print $1}'`
        [[ -z "${key}" ]] && continue
        if [[ $key =~ .*\..* ]]; then
            #key contains the special char [.]
            continue
        fi

        value=`echo $line | sed s/^$key=//`
        export $key="$value"
    done < ${filePath}
}

#create directory if not exist
createDirectory()
{
    path=$1
    if [ ! -z "${path}" -a ! -d "${path}" ]; then
        mkdir -p ${path} 2>/dev/null
        RECORDE_FLAG="true"
    fi
}

insert_env_path()
{
    #Make sure $1 is a subset of a path of ENV(PATH), do not care repeat path here
    PATH=$1:$PATH; export PATH
}

insert_env_libpath()
{
    #Make sure $1 is a subset of a path of ENV(LD_LIBRARY_PATH), do not care repeat path here
    LD_LIBRARY_PATH=$1:$LD_LIBRARY_PATH; export LD_LIBRARY_PATH
}

insert_env_pythonpath()
{
    #Make sure $1 is a subset of a path of ENV(PYTHONPATH), do not care repeat path here
    PYTHONPATH=$1:$PYTHONPATH; export PYTHONPATH
}

function normpath() {
    # Filter all the /./ .
    local N_dir=${1//\/.\//\/}

    # Filter all the /./ .
    while [[ $N_dir =~ ([^/][^/]*/\.\./) ]]; do
        N_dir=${N_dir/${BASH_REMATCH[0]}/}
    done
    echo $N_dir
}

#set Python environments
PYTHONHOME=${APP_ROOT}/rtsp/python
export PYTHONHOME
PYTHONPATH=; export PYTHONPATH

if [ ! -z "$PATH" ];
then
    PATH=/usr/local/bin:/usr/bin:/bin:$PATH
else
    PATH=/usr/local/bin:/usr/bin:/bin
fi

insert_env_path ${PYTHONHOME}/bin

LD_LIBRARY_PATH=/usr/local/lib:/usr/lib:/lib
insert_env_libpath ${PYTHONHOME}/lib
insert_env_libpath ${APP_ROOT}/dbdriver_gauss/pyscript/gauss
insert_env_libpath ${APP_ROOT}/dbdriver_mysql/pyscript/mysql
insert_env_libpath ${APP_ROOT}/dbdriver_zenith/pyscript/zenith
[ "$CUSTOM_LD_LIBRARY_PATH" != "" ] && insert_env_libpath $CUSTOM_LD_LIBRARY_PATH

#set Java environments
JAVA_HOME=${APP_ROOT}/rtsp/jre
export JAVA_HOME

TENANT_PROPS_FILE=`normpath "${APP_ROOT}/../../etc/envs/tenant.properties"`
if [ -f "${TENANT_PROPS_FILE}" ];
then
    exportEnvsFromFile "${TENANT_PROPS_FILE}"
fi
if [ ! -z "${APP_NAME}" -a -f "${APP_ROOT}/envs/${APP_NAME}.properties" ];
then
    exportEnvsFromFile "${APP_ROOT}/envs/${APP_NAME}.properties"
fi
if [ -z "${PROCESS_NAME}" -a -f "${APP_ROOT}/envs/upgrade.properties" ];
then
    exportEnvsFromFile "${APP_ROOT}/envs/upgrade.properties"
fi
if [ ! -z "${PROCESS_NAME}" -a -f "${APP_ROOT}/envs/${PROCESS_NAME}.properties" ];
then
    exportEnvsFromFile "${APP_ROOT}/envs/${PROCESS_NAME}.properties"
fi

#create temp dirctory
createDirectory "${_APP_LOG_DIR}"
createDirectory "${_APP_SHARE_DIR}"
createDirectory "${_APP_TMP_DIR}"

insert_env_pythonpath ${PYTHONHOME}/lib/lib-dynload
insert_env_pythonpath ${PYTHONHOME}/lib
insert_env_pythonpath ${APP_ROOT}/rtsp/mccommon/tools/pyscript
insert_env_pythonpath ${APP_ROOT}/rtsp/mccommon/tools/pyscript/cbb
insert_env_pythonpath ${APP_ROOT}/tools/pyscript
insert_env_pythonpath ${APP_ROOT}/tools/pyscript/cbb
insert_env_pythonpath ${APP_ROOT}/dbdriver_gauss/pyscript
insert_env_pythonpath ${APP_ROOT}/dbdriver_gauss/pyscript/gauss
insert_env_pythonpath ${APP_ROOT}/dbdriver_zenith/pyscript
insert_env_pythonpath ${APP_ROOT}/dbdriver_zenith/pyscript/zenith
insert_env_pythonpath ${APP_ROOT}/dbdriver_mysql/pyscript

newitems=
remove_repeat_path()
{
    newitems=""
    IFS_t=$IFS
    IFS=:
    items=$1
    for item in $items
    do
        exist=0
        for ni in $newitems
        do
            if [ "$item" = "$ni" ];
            then
                exist=1
                RECORDE_FLAG="true"
                break
            fi
        done
        if [ $exist -eq 0 ]
        then
            if [ "$newitems" = "" ];
            then
                newitems=$item
            else
                newitems=$newitems:$item
            fi
        fi
    done
    IFS=$IFS_t
}

#remove repeat path in $PATH
remove_repeat_path $PATH
PATH=$newitems
export PATH
#remove repeat path in $LD_LIBRARY_PATH
remove_repeat_path $LD_LIBRARY_PATH
LD_LIBRARY_PATH=$newitems
export LD_LIBRARY_PATH
#remove repeat path in $PYTHONPATH
remove_repeat_path $PYTHONPATH
PYTHONPATH=$newitems
export PYTHONPATH
export PYTHONSTARTUP=""

ulimit -S -n 4096
umask 027

exitCode=$?
#logger
if [ "$RECORDE_FLAG" = "true" ]; then
    /bin/logger -t $USER -p local0.info "app_profile.sh;ErrorCode:$exitCode;${OPERIP:-127.0.0.1};Excute app_profile.sh"
fi
