#!/bin/bash
# Name        : fn_check_status
# Description : check the return result
# Parameters  : $1 return value
OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
function fn_check_status()
{
    local ERROR_CODE=$1

    echo -en "\\033[65G"
    if [ ${ERROR_CODE} = 0 ]
    then
        echo -en "\\033[1;32m[done]"
        echo -e "\\033[0;39m"
    else
        echo -en "\\033[1;31m[fail]"
        echo -e "\\033[0;39m"
        logger -t $USER -p local0.info "exeShell.sh;Failed;${OPERIP:-127.0.0.1};Excute(${ERROR_CODE}) exeShell.sh"
        exit ${ERROR_CODE}
    fi
}
#######################################3
#Two parameters:
#1st: the script path to be executed.
#2nd: the parameter properties file path, can be a list, split with ,. 
#########################################
#check user
if [ "root" = "`/usr/bin/id -u -n`" ];then
    echo "root has been forbidden to execute this script."
    logger -t $USER -p local0.info "exeShell.sh;Failed;${OPERIP:-127.0.0.1};Excute(1) exeShell.sh"
    exit 1
fi

if [ $# -lt 2 ] 
then
    echo "WARN" "Usage: $0 <script path> <properties file path>"
    echo "WARN" "e.g $0 INSTALL_ROOT/manager/bin/test.sh INSTALL_ROOT/manager/manager.properties"
    fn_check_status "${ERROR_PARAM}"
fi

shFile=$1
paramFileListStr=$2
OLD_IFS="$IFS" 
IFS=","
paramFileList=($paramFileListStr) 
IFS="$OLD_IFS" 
ERROR_PARAM=1

if [ ! -f "$shFile" ]
then
    echo "WARN" "Invalid shell file: ${shFile//${INSTALL_ROOT}/INSTALL_ROOT}"
    fn_check_status "${ERROR_PARAM}"
fi

for paramFile in ${paramFileList[@]} 
do 
    echo "${paramFile//${INSTALL_ROOT}/INSTALL_ROOT}"
    if [ ! -f $paramFile ]
    then 
        echo "WARN" "Invalid shell file: ${paramFile//${INSTALL_ROOT}/INSTALL_ROOT}"
        fn_check_status "${ERROR_PARAM}"
    fi
    
    while read line
    do
        if [[ $line =~ ^#.* ]]
        then
            continue
        fi
        key=`echo $line | awk -F '=' '{print $1}'`    
        value=`echo $line | awk -F '=' '{print $2}'`
        export $key=$value
    done < $paramFile
done

bash $shFile $3
exitCode=$?

if [[ "$exitCode" == "0" ]]
then
    logger -t $USER -p local0.info "exeShell.sh;Successful;${OPERIP:-127.0.0.1};Excute exeShell.sh"
else
    logger -t $USER -p local0.info "exeShell.sh;Failed;${OPERIP:-127.0.0.1};Excute($exitCode) exeShell.sh"
fi

exit $exitCode
