#!/bin/bash
OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
if [ -z "${APP_ROOT}" ];
then
    echo "APP_ROOT is empty."
    logger -t $USER -p local0.info "ossruncmd.sh;Failed;${OPERIP:-127.0.0.1};Execute(1) the ${PROCESS_NAME}'s script."
    exit 1
fi

SCRIPT_PATH=`dirname $0`
MCCOMMON_PATH=`cd ${SCRIPT_PATH};pwd`
. ${MCCOMMON_PATH}/app_profile.sh
[[ ! -z ${LD_PRELOAD} ]] && export LD_PRELOAD=''

#Switch work directory
cd ${APP_ROOT}

#Execute the command
exitCode=0
if [ "$1" == "-fg" ];then
    shift 1
    $*
    exitCode=$?
else
    $* &
    exitCode=$?
fi

#Logger
if [[ "$exitCode" == "0" ]]
then
    logger -t $USER -p local0.info "ossruncmd.sh;Successful;${OPERIP:-127.0.0.1};Execute the ${PROCESS_NAME}'s script."
else
    logger -t $USER -p local0.info "ossruncmd.sh;Failed;${OPERIP:-127.0.0.1};Execute($exitCode) the ${PROCESS_NAME}'s script."
fi
exit $exitCode
