#!/bin/bash

OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
USER=`whoami`

if [ $# -lt 2 -a "$1" != "-h" ]; then
    echo "Usage: $0 PluginName ActionName"
    logger -t $USER -p local0.err "ossrunpy.sh args error;Failed;${OPERIP:-127.0.0.1};Excute ossrunpy.sh"
    exit 2
fi

SCRIPT_PATH=`dirname $0`
if [ -f ${SCRIPT_PATH}/app_profile.sh ]; then
    . ${SCRIPT_PATH}/app_profile.sh
fi

if [ -z ${APP_ROOT} ]; then
    logger -t $USER -p local0.err "ossrunpy.sh APP_ROOT error;Failed;${OPERIP:-127.0.0.1};Excute ossrunpy.sh"
    exit 2
fi

python ${SCRIPT_PATH}/../pyscript/runaction.pyc $*

ret=$?
if [ $ret -eq 0 ]
then
    logger -t $USER -p local0.info "ossrunpy.sh python runaction.pyc;Successful;${OPERIP:-127.0.0.1};Excute ossrunpy.sh"
else
    logger -t $USER -p local0.err "ossrunpy.sh python runaction.pyc;Failed;${OPERIP:-127.0.0.1};Excute ossrunpy.sh"
fi
exit $ret
