#!/bin/bash

_DIRNAME=$(dirname $0)
_CUR_PATH=$(cd ${_DIRNAME};pwd)
_PARENT_DIR=$(cd `dirname $0`; dirname "$PWD")
LOG_FILE=/var/log/tools/FusionInsight/Check_FI_env.log

source ${_PARENT_DIR}/common/logger.sh
mkdir -p `dirname $LOG_FILE`
ntp_ip=$1

set_unix2()
{
	cat /etc/pam.d/common-session | grep "pam_unix2.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo session required        pam_unix2.so>>/etc/pam.d/common-session
	fi
	
	cat /etc/pam.d/common-password | grep "pam_unix2.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo password    sufficient  pam_unix2.so  use_authtok nullok>>/etc/pam.d/common-password
	fi
	
	cat /etc/pam.d/common-auth | grep "pam_unix2.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo auth    sufficient      pam_unix2.so>>/etc/pam.d/common-auth
	fi
	
	cat /etc/pam.d/common-account | grep "pam_unix2.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo account required        pam_unix2.so>>/etc/pam.d/common-account
	fi

	cat /etc/pam.d/common-session | grep "pam_unix.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo session required        pam_unix.so>>/etc/pam.d/common-session
	fi
	
	cat /etc/pam.d/common-password | grep "pam_unix.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo password    sufficient  pam_unix.so>>/etc/pam.d/common-password
	fi
	
	cat /etc/pam.d/common-auth | grep "pam_unix.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo auth    sufficient      pam_unix.so>>/etc/pam.d/common-auth
	fi
	
	cat /etc/pam.d/common-account | grep "pam_unix.so" | grep -v "#"
	if [[ $? -ne 0 ]];then
		echo account required        pam_unix.so>>/etc/pam.d/common-account
	fi
}

configuration_environment()
{
   mkdir -p /srv/BigData

   sed -i '/127.0.0.1/d' /etc/hosts
   sed -i '1 i\127.0.0.1 localhost' /etc/hosts
}

check_cron_mode()
{
    # This function is used to change cron mode to process
    cron_mode=`cat /usr/lib/systemd/system/cron.service | grep -i KillMode`
    if [ "${cron_mode}" = "" ];then
        # condition 1: parameter killMode process is not exist
        log WARNING "Current cron kill mode is: ${cron_mode}, start to change kill mode to process" ${LOG_FILE}
        line_number=`grep -n "Restart" /usr/lib/systemd/system/cron.service | awk -F: '{print $1}' | head -1`
        sed -i "$line_number s/^/KillMode=process\n/" /usr/lib/systemd/system/cron.service
        systemctl daemon-reload
        if [ $? -ne 0 ]; then
            log ERROR "Change crom mode failed, please check cron service config. cmd: systemctl daemon-reload, ret: $?" ${LOG_FILE}
            exit 1
        fi
    else
        # condition 2: parameter killMode is not process, need to change to process
        kill_mode=`cat /usr/lib/systemd/system/cron.service | grep -i KillMode=process`
        if [ "${kill_mode}" = "" ];then
            log WARNING "Cron kill mode is not set, start to set kill mode to process" ${LOG_FILE}
            sed -i "s#KillMode=.*#KillMode=process#g" /usr/lib/systemd/system/cron.service
            systemctl daemon-reload
            if [ $? -ne 0 ]; then
                log ERROR "Change crom mode failed, please check cron service config. cmd: systemctl daemon-reload, ret: $?" ${LOG_FILE}
                exit 1
            fi

        fi
        # condition 3: parameter killMode is process, need to do nothing
    fi
    # finally check wheher change success before exit
    kill_mode=`cat /usr/lib/systemd/system/cron.service | grep -i KillMode=process`
    if [ "${kill_mode}" = "" ]; then
        log ERROR "Change crom kill mode to process failed." ${LOG_FILE}
        exit 1
    fi
    log INFO "Check cron mode success." ${LOG_FILE}
}

config_specific_file()
{
    source_file=$1
    key_word=$2
    target_cmd=$3

    crack_mode=`cat ${source_file} | grep -i ${key_word} | grep -v '#' `
    if [ $? -eq 0 ]; then
        # if enhance pwd check mode, current pwd may not fit, this is not required in fi install
        log WARNING "Current mod is: ${crack_mode} , not need to change ${key_word} config" ${LOG_FILE}
    else
        # condition 2, add config if system not config this
        log WARNING "${key_word} not config in given path, start to add ${key_word}" ${LOG_FILE}
        echo "${target_cmd}" >> ${source_file}
    fi
}

config_common_pwd()
{
    # This function used to config pwd auth method of FI
    pwcheck_mod=`cat /etc/pam.d/common-password | grep -i pam_pwcheck.so`
    if [ "${pwcheck_mod}" != "" ]; then
        # if enhance pwd check mode, current pwd may not fit, this is not required in fi install
        log WARNING "pvalue check mode might cause error, mode is: ${pwcheck_mod}" ${LOG_FILE}
    fi

    crack_mod_cmd="password    required   pam_cracklib.so retry=3 minlen=8 difok=2 dcredit=-1 ucredit=-1 lcredit=-1 ocredit=-1 enforce_for_root"
    config_specific_file /etc/pam.d/common-password pam_cracklib.so "${crack_mod_cmd}"

    pam_pwhistory_cmd="password  required  pam_pwhistory.so  remember=12 use_authtok use_first_pass enforce_for_root crypt=sha256"
    config_specific_file /etc/pam.d/common-password pam_pwhistory.so "${pam_pwhistory_cmd}"

    pam_unix2_cmd="password   required   pam_unix2.so   nullok use_authtok"
    config_specific_file /etc/pam.d/common-password pam_unix2.so "${pam_unix2_cmd}"

    pam_unix_cmd="password    required     pam_unix.so    nullok use_authtok"
    config_specific_file /etc/pam.d/common-password pam_unix.so "${pam_unix_cmd}"

    pam_ldap_cmd="password    required     pam_ldap.so try_first_pass use_authtok"
    config_specific_file /etc/pam.d/common-password pam_ldap.so "${pam_ldap_cmd}"

    log INFO "config pam common pvalue auth success" ${LOG_FILE}
}

establish_link(){
    # 当前要在suse12.4下进行该步骤
    version=`cat /etc/os-release | grep ^VERSION_ID | sed 's/VERSION_ID="\(.*\)"/\1/g'`
    if [[ ${version} == "12.4" ]];then
        log WARNING "establish link /sbin/ethtool to /usr/sbin/ethtool" ${LOG_FILE}
        if [[ ! -L /sbin/ethtool ]];then
            ln -s /usr/sbin/ethtool  /sbin/ethtool
        fi
    fi
}

function main(){
    configuration_environment
    set_unix2
    # add this func to avoid fi c70 version error
    check_cron_mode
    # config common password
    config_common_pwd
    establish_link
}
main $@
