#!/bin/bash
_CURRENT_DIR=$(cd `dirname $0`; pwd)
_PARENT_DIR=$(cd `dirname $0`; dirname "$PWD")
LOG_FILE=/var/log/tools/FusionInsight/registerPatch.log
FI_BASE_PATCH=`ls $_CURRENT_DIR | grep ^FusionInsight_BASE_6.5.1\\\. | grep tar.gz$`
FI_HD_PATCH=`ls $_CURRENT_DIR | grep ^FusionInsight_HD_6.5.1\\\. | grep tar.gz$`
FI_SPARK_PATCH=`ls $_CURRENT_DIR | grep ^FusionInsight_Spark2x_6.5.1\\\. | grep tar.gz$`
PACK_HOME=/opt/huawei/Bigdata/om-server/om/sbin/pack/

source ${_PARENT_DIR}/common/logger.sh
mkdir -p `dirname $LOG_FILE`
#=================================register===================================
if [ -n "${FI_BASE_PATCH}" ] && [ -n "${FI_HD_PATCH}" ]  && [ -n "${FI_SPARK_PATCH}" ]; then
    log INFO "start to register FusionInsight_BASE,FusionInsight_HD,FusionInsight_Spark2x" ${LOG_FILE}
    chmod 700 $_CURRENT_DIR/${FI_BASE_PATCH} $_CURRENT_DIR/${FI_HD_PATCH} $_CURRENT_DIR/${FI_SPARK_PATCH}
    su - omm -c"bash ${PACK_HOME}/register_pack.sh $_CURRENT_DIR/${FI_BASE_PATCH} $_CURRENT_DIR/${FI_HD_PATCH} $_CURRENT_DIR/${FI_SPARK_PATCH}"
    if [ $? -ne 0 ]; then
        echo "register patch fail."
        log ERROR "register patch fail." ${LOG_FILE}
        exit 1
    fi
    log INFO "register patch success." ${LOG_FILE}
else
    echo "patch file not found."
    log ERROR "patch file not found." ${LOG_FILE}
fi