#!/bin/bash

# 日志记录
# 1、新建日志文件所在目录
# 2、source引入该脚本
# 3、调用：log [LOG_LEVEL] [LOG_INFO] [LOG_FILE] （LOG_FILE为完整路径）
function log()
{
    local LOG_LEVEL=$1
    local LOG_INFO=$2
    local LOG_FILE=$3

    case ${LOG_LEVEL} in
    "INFO")
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]    INFO: ${LOG_INFO}">>${LOG_FILE}
    ;;
    "ERROR")
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]   ERROR: ${LOG_INFO}">>${LOG_FILE}
    ;;
    "WARNING")
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] WARNING: ${LOG_INFO}">>${LOG_FILE}
    ;;
    *)
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] ${@}">>${LOG_FILE}
    ;;
    esac
    chmod 640 ${LOG_FILE}
    return 0
}
