#!/bin/bash

###########################################变量定义#############################################
declare TEMP_PATH=""                     # 临时目录
declare LOG_PATH=""                                                     # 日志目录
declare LOG_FILE="install_oms_patch.log"                                # 日志文件              
declare OMS_STATUS=""                                                   # OMS状态，只能是active/standby，否则报错
declare R_VERSION="V100R002"
declare HA_STANDBY_STATUS="standby"
declare HA_ACTIVE_STATUS="active"
declare MANAGER_PACK_DISPLAY_NAME="Manager"
declare PATCH_INSTALL_PATH="$BIGDATA_HOME/patch/install/"
declare PATCH_BACKUP_PATH="$BIGDATA_HOME/patch/backup"
declare DISTRI_PATCH_DIR="${BIGDATA_HOME}/packaged-distributables/patch/"
declare STANDBY_OMS_IP=""
declare HA_MODE=""

declare -r NORMAL_MODE="normal"
declare -r SILENT_MODE="silent"

declare g_oms_patch_package=""
declare g_install_mode="${NORMAL_MODE}"

declare g_oms_patches=""
declare MAX_TIME=24

###########################################函数定义#############################################
print_usage()
{
    echo "Script usage:"
    echo "$0 <patch package path>"
    echo "Example: $1 /srv/BigData/Manager/patch/FusionInsight_Manager_V100R002C70SPC201_redhat.tar.gz"
}

################################################################################
# Function: log
# Description: 日志打印
################################################################################
log()
{
    local curTime=""
    curTime=$(date +%Y-%m-%d\ %T)
    local level=$1
    local lineNo=$2
    local logInfo=$3
    
    echo "[$curTime] [$level]: $logInfo(line:$lineNo)" >> "${LOG_FILE}" 2>&1
}

################################################################################
# Function: log_and_show
# Description: 日志打印并在控制台显示
################################################################################
log_and_show()
{
    log "$@"
    echo "$3"
}

check_status()
{
    if [ "${g_install_mode}" == "${NORMAL_MODE}" ]; then
        #检查是否已经做了禁止主备倒换
        if ! [[ -f "$OMS_RUN_PATH/workspace/ha/local/haarb/conf/forbid.txt" ]];then
            log_and_show "WARN" "$LINENO" "HA active/standby switch enable, please forbid ha active/standby switch."
            return 1
        fi

        #检查是否已经做了禁止文件同步
        if ! [[ -f "$OMS_RUN_PATH/workspace/ha/local/hasync/conf/forbidden" ]]; then
            log_and_show "WARN" "$LINENO" "HA file synchronization enable, please disabled ha file synchronization."
            return 1
        fi

        OMS_STATUS=$(sh "$CONTROLLER_HOME"/sbin/status-oms.sh | grep "$(hostname)" | awk 'NR==1{ print $6 }')
        if [[ "$OMS_STATUS" != "${HA_ACTIVE_STATUS}" ]] && [[ "$OMS_STATUS" != "${HA_STANDBY_STATUS}" ]];then
             log_and_show "WARN" "$LINENO" "OMS status is $OMS_STATUS, maybe abnormal."
             return 1
        fi
    else
        OMS_STATUS=$(sh "$CONTROLLER_HOME"/sbin/status-oms.sh | grep "$(hostname)" | awk 'NR==1{ print $6 }')
        if [[ "$OMS_STATUS" != "${HA_ACTIVE_STATUS}" ]] && [[ "$OMS_STATUS" != "${HA_STANDBY_STATUS}" ]];then
            log "WARN" "$LINENO" "OMS status is $OMS_STATUS, maybe abnormal."
            return 1
        fi
    fi
    
    return 0
}

check_oms_status()
{
    for((i=1;i<=$MAX_TIME;i++));
    do
        check_status
        if [ $? -eq 0 ];then
            return 0
        fi
        sleep 5
    done
    
    log "ERROR" "$LINENO" "OMS status is abnormal."
    return 1
}

init_parameter()
{
    g_oms_patch_package="$1"
    g_install_mode="$2"
    
    LOG_PATH="$BIGDATA_LOG_HOME/patch"
    if ! [[ -d "$LOG_PATH" ]];then
        mkdir -p "$LOG_PATH"
    fi
    LOG_FILE="$LOG_PATH/$LOG_FILE"
    
    TEMP_PATH="$BIGDATA_DATA_HOME/tmp/patch/temp"
    if ! [[ -d "$TEMP_PATH" ]];then
        mkdir -p "$TEMP_PATH"
    fi
    
    check_oms_status || return 1

    local l_ipFile="${CONTROLLER_HOME}/inst/conf/oms-config.ini"
    HA_MODE="$(cat ${l_ipFile} | grep 'ha_mode' | awk -F '=' '{print $2}' | tr -d ' ')"
    
    if [ "${HA_MODE}" == "double" ]; then
        STANDBY_OMS_IP=$(bash "$CONTROLLER_HOME/sbin/getOMSIP.sh" standby "$CONTROLLER_HOME")
    fi

    if [ -z "${CPU_ARCH}" ];then
        log "ERROR" "$LINENO" "CPU_ARCH ${CPU_ARCH} does not exis."
        return 1
    fi

    DISTRI_PATCH_DIR="${DISTRI_PATCH_DIR}/${CPU_ARCH}"
    if ! [ -d "${DISTRI_PATCH_DIR}" ]; then
       if ! mkdir -p "${DISTRI_PATCH_DIR}"; then
          log "ERROR" "$LINENO" "mkdir ${DISTRI_PATCH_DIR} failed."
          return 1
       fi
    fi
    
    mkdir -p "${DISTRI_PATCH_DIR}"
    
    if [[ -d "$PATCH_INSTALL_PATH" ]];then
        log "WARN" "$LINENO" "$PATCH_INSTALL_PATH exist, remove it."
        rm -fr "${PATCH_INSTALL_PATH:-?}"
    fi
    mkdir -p "$PATCH_INSTALL_PATH"
    
    
    if ! [[ -d "$PATCH_BACKUP_PATH" ]];then
        mkdir -p "$PATCH_BACKUP_PATH"
    fi
    
    log "INFO" "$LINENO" "Leave to initialize parameter."
    return 0
}

#
# post after load patch, whether success of failed
#
post_after_install()
{
    if [[ -e "$TEMP_PATH" ]]; then 
        popd >/dev/null 2>&1
    fi
}

install_normal_patch()
{
    if [[ ${#g_oms_patches[@]} -gt 0 ]]; then
        #修改组件AOS插件所在目录
        if [ "${HA_MODE}" == "double" ]; then
            local cmd="source /home/$OMS_USER/.profile; \"${CONTROLLER_HOME}/sbin/installPatch.sh\" \"$HA_STANDBY_STATUS\" ${g_oms_patches[@]} "
            ssh "$STANDBY_OMS_IP" "$cmd" >>"$LOG_FILE" 2>&1
            if [[ $? -ne 0 ]]; then
                log "ERROR" "$LINENO" "Install standby oms patch failed."
                return 1
            fi
            log_and_show "INFO" "$LINENO" "Install standby oms patch successfully."
        else
            log_and_show "INFO" "$LINENO" "Standby oms not found, not need to install standby oms patch."
        fi
        
        "/bin/bash" "$CONTROLLER_HOME/sbin/installPatch.sh" "${HA_ACTIVE_STATUS}" "${g_oms_patches[@]}" >> "$LOG_FILE" 2>&1
        if [[ $? -ne 0 ]]; then
            log "ERROR" "$LINENO" "Install active oms patch failed."
            return 1
        fi
        log_and_show "INFO" "$LINENO" "Install oms patch successfully."
        return 0
    fi

    log_and_show "INFO" "$LINENO" "Not need to install oms patch."

    return 0
}

install_silent_patch()
{
    if [[ ${#g_oms_patches[@]} -gt 0 ]]; then
    
        "/bin/bash" "$CONTROLLER_HOME/sbin/installPatch.sh" "${OMS_STATUS}" "${g_oms_patches[@]}" >> "$LOG_FILE" 2>&1
        if [[ $? -ne 0 ]]; then
            log "ERROR" "$LINENO" "Install active oms patch failed."
            return 1
        fi
        log "INFO" "$LINENO" "Install oms patch successfully."
        return 0
    fi

    log "INFO" "$LINENO" "Not need to install oms patch."
    return 0
}

install_oms_patches()
{
    #解压完成后，获取CP列表
    g_oms_patches=($(find "$PATCH_INSTALL_PATH" -maxdepth 1 -mindepth 1 -type d | sort))
    g_oms_patches=(${g_oms_patches[@]##*/})


    #静默补丁只在一个节点上执行，另一个节点不用管
    if [ "${g_install_mode}" == "${SILENT_MODE}" ];then
        install_silent_patch
    else
        install_normal_patch
    fi

    return $?
}

untar_package()
{
    cd ${DISTRI_PATCH_DIR} >> "${LOG_FILE}" 2>&1 || return 1
    

    local l_package_file="${g_oms_patch_package}"
    if ! [[ -f "$l_package_file" ]];then
        log "ERROR" "$LINENO" "The package ${l_package_file} does not exist."
        return 1
    fi
    
    log "INFO" "$LINENO" "Start to decompress package $l_package_file".
    #解压SPC补丁包
    tar -zxf "$l_package_file" -C "$TEMP_PATH"
    if [[ $? -ne 0 ]]; then
        log "ERROR" "$LINENO" "Failed to decompress package $l_package_file."
        return 1
    fi
    
    local l_packageName="$(basename "$l_package_file")"
    local l_packName=${l_packageName%.tar.gz}
    
    local cp_packages=()
    cp_packages=($(find "$TEMP_PATH/$l_packName" -name '*.tar.gz'))
    cp_packages=(${cp_packages[@]##*/})
    for cp_name in "${cp_packages[@]}"; 
    do
        mv -f "${TEMP_PATH}/${l_packName}/${cp_name}" "${DISTRI_PATCH_DIR}" && sha256sum "${cp_name}" > "${cp_name}.sha256"
        if [[ $? -ne 0 ]]; then
            log "ERROR" "$LINENO" "Move ${pkg} to ${DISTRI_PATCH_DIR} failed."
            return 1
        fi
        log "INFO" "$LINENO" "Move ${pkg} to ${DISTRI_PATCH_DIR} successfully."
        
        if ! "/bin/bash" "${CONTROLLER_HOME}/sbin/decompressPatch.sh" "${cp_name}" >> "${LOG_FILE}" 2>&1; then
            log "ERROR" "$LINENO" "Decompress patch ${cp_name} failed."
            return 1
        fi
        log "INFO" "$LINENO" "Decompress patch ${cp_name} successfully".
    done


    #对于支持静默补丁，只在当前节点执行安装
    if [ "${g_install_mode}" == "${SILENT_MODE}" ];then
        log "INFO" "$LINENO" "Decompress package $l_package_file successfully".
        return 0
    fi


    #处理备节点
    if [ "${HA_MODE}" == "double" ]; then
        # sync packaged-distributables/patch from active oms
        rsync --delete -az --rsh=ssh "$DISTRI_PATCH_DIR"/* "$STANDBY_OMS_IP":"$DISTRI_PATCH_DIR" 
        if [[ $? -ne 0 ]]; then
            showLogError "Failed to synchronize dir:$DISTRI_PATCH_DIR to standby oms."
            return 1 
        fi
        #在备节点解压补丁包
        local cmd="source /home/$OMS_USER/.profile; \"${CONTROLLER_HOME}/sbin/decompressPatch.sh\" ${cp_packages[@]} "
        ssh "$STANDBY_OMS_IP" "$cmd" >>"$LOG_FILE" 2>&1
        if ! ssh "$STANDBY_OMS_IP" "$cmd" >>"$LOG_FILE" 2>&1; then
            log "ERROR" "$LINENO" "Decompress patch ${l_cp_name} failed."
            return 1
        fi
    fi
    
    log_and_show "INFO" "$LINENO" "Decompress package $l_package_file successfully".
    return 0
}

main()
{
    # parameter check
    if [[ $# -lt 1  ]]; then
        print_usage "$0"
        return 1
    fi
    
    if [[ "$USER" != "omm" ]];then
        echo "Failed: this script can only run by user omm. The current user is $USER"
        return 1
    fi
    
    #初始化参数
    init_parameter "$@"
    if [[ $? -ne 0 ]];then
        post_after_install
        log_and_show "ERROR" "$LINENO" "Failed to initialize parameter."
        return 1
    fi
    
    untar_package
    if [[ $? -ne 0 ]];then
        post_after_install
        log_and_show "ERROR" "$LINENO" "Failed to decompress packages."
        return 1
    fi
    
    #安装补丁列表
    install_oms_patches
    if [[ $? -ne 0 ]];then
        post_after_install
        log_and_show "ERROR" "$LINENO" "Failed to install oms patch."
        return 1
    fi
    
    post_after_install 
    
    return 0
}
#导入环境变量
source /home/omm/.profile

main "$@"
ret="$?"
exit $ret
