#!/bin/bash
declare -i retVal=0                         # 返回值

logAndEcho()
{
 echo "[$(date +'%Y-%m-%d %H:%M:%S')] $* " | tee -a "${LOG_FILE}"
}

################################################################################
#
################################################################################
# Function: get_cur_path
# Description: 获取脚本所在的目录及脚本名
# Parameter:
#   input:
#   N/A
#   output:
#   N/A
# Return: 0 -- success; not 0 -- failure
# Others: N/A
################################################################################
get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    local curPath="${PWD}"
    local scriptName="$(basename "${BASH_SOURCE-$0}")"
    echo "$curPath"
    cd - > /dev/null
}

if [ "$(whoami)" != "omm" -a "$(whoami)" != "root" ] ; then
    echo "must root or omm can be execute this cmd"
    logAndEcho "[ERROR] Only the root or omm user can execute this command."
    exit 1
fi

# ---------------------------------------------------------------------------- #
#                                 获取当前路径                                 #
# ---------------------------------------------------------------------------- #
curPath=$(get_cur_path)
. $curPath/oss/interface/interface.sh
. $curPath/../inst/func/log.sh

if [ "$(whoami)" = "root" ] ; then
    oms_path=$(su - omm -c 'echo ${OMS_RUN_PATH}')
    bigdata_log_home="$(su - omm -c 'echo ${BIGDATA_LOG_HOME}')"
    om_server_path="$(su - omm -c 'echo ${BIGDATA_OM_SERVER_HOME}')"
    LOG_FILE="$bigdata_log_home/controller/scriptlog/oms_ctl.log"
    mkdir -p "$(dirname ${LOG_FILE})"
    touch ${LOG_FILE}
    chown omm: ${LOG_FILE}
    chmod 600 "${LOG_FILE}"
    logAndEcho "[INFO] Enter into start-oms.sh with user $(whoami) "

    su - omm -c "sh ${om_server_path}/om/sbin/manager_supports_compression_card.sh"
    if [ $? -ne 0 ]; then
        logAndEcho "[ERROR] Failed to replace the file because the Manager supports the compression card."
        exit 1
    fi
    su - omm -c 'sh ${OMS_RUN_PATH}/workspace/ha/module/hacom/script/start_ha.sh'
    retVal=$?
    if [ $? -ne 0 ]; then
        logAndEcho "[ERROR] start HA failed by user $(whoami) ."
    fi

fi

if [ "$(whoami)" = "omm" ] ; then
    source ~/.profile
    LOG_FILE="$BIGDATA_LOG_HOME/controller/scriptlog/oms_ctl.log"
    mkdir -p "$(dirname ${LOG_FILE})"
    touch ${LOG_FILE}
    logAndEcho "[INFO] Enter into start-oms.sh with user $(whoami) "

    sh ${CONTROLLER_HOME}/sbin/manager_supports_compression_card.sh
    if [ $? -ne 0 ]; then
        logAndEcho "[ERROR] Failed to replace the file because the Manager supports the compression card."
        exit 1
    fi
    ${OMS_RUN_PATH}/workspace/ha/module/hacom/script/start_ha.sh
    retVal=$?
    if [ $? -ne 0 ]; then
        logAndEcho "[ERROR] start HA failed by user $(whoami) ."
    fi
fi

if [ "$(whoami)" = "root" ] ; then
    grep 'start_ha_monitor' ${CRONTAB_FILE} > /dev/null 2>&1
    if [ 0 -ne $? ];then
        echo "* * * * * source /home/omm/.profile;sh ${oms_path}/workspace/ha/module/hamon/script/start_ha_monitor.sh > /dev/null 2>&1 &" >> $CRONTAB_FILE
        if [ 0 -ne $? ];then
            logAndEcho "[ERROR] Failed to update cron file.1"
            exit 1
        fi

        echo "0 3 * * * sh ${om_server_path}/om/bin/tools/bkauditlogs.sh -p ${bigdata_log_home}/audit/bk > /dev/null 2>&1 &" >> $CRONTAB_FILE
        if [ 0 -ne $? ];then
            logAndEcho "[ERROR] Failed to update cron file."
            exit 1
        fi

        /sbin/service ${CRON_SERVICE_NAME} restart >> $LOG_FILE 2>&1
        if [ $? -ne 0 ]; then
            logAndEcho "[ERROR] Failed to restart cron."
            exit 1
        fi
    fi
# 进入脚本已经填加了校验，只有root和omm用户可执行，此处不再判断是否为omm用户
else
    sudo ${SUDO_PATH_OMS} is_exist_in_crontab 'start_ha_monitor' ${CRONTAB_FILE} >> "${LOG_FILE}" 2>&1
    if [ 0 -ne $? ];then

        sudo ${SUDO_PATH_OMS} m_update_crontab "\$a* * * * * source /home/omm/.profile;sh ${OMS_RUN_PATH}/workspace/ha/module/hamon/script/start_ha_monitor.sh > /dev/null 2>&1 &" >> $LOG_FILE 2>&1
        if [ $? -ne 0 ]; then
            logAndEcho "[ERROR] Failed to update cron file."
            exit 1
        fi

        sudo ${SUDO_PATH_OMS} m_update_crontab "\$a0 3 * * * sh ${BIGDATA_OM_SERVER_HOME}/om/bin/tools/bkauditlogs.sh -p $BIGDATA_LOG_HOME/audit/bk > /dev/null 2>&1 &" >> $LOG_FILE 2>&1
        if [ $? -ne 0 ]; then
            logAndEcho "[ERROR] Failed to update cron file."
            exit 1
        fi

        sudo ${SUDO_PATH_OMS} m_restart_cron >> $LOG_FILE 2>&1
        if [ $? -ne 0 ]; then
            logAndEcho "[ERROR] Failed to restart cron."
            exit 1
        fi
    fi
fi

logAndEcho "[INFO] End start-oms.sh with user $(whoami) "
#在操作系统日志中记录审计日志
syslog "manager" "start-oms.sh" "${retVal}" "Start oms."
exit ${retVal}
