#!/bin/bash
# 此脚本用于生成FI的ca证书
if [ ! $1 ]; then
    echo "missing temp path"
    exit 1
fi

read -p "please input password: " -s -t 60 CERT_LOGIN_INFO
CA_TMP_PATH=$1

# 清除残留信息
cd /home/omm
rm -rf ca.tar > /dev/null 2>/dev/null
rm ca.key  > /dev/null 2>/dev/null
rm ca.crt  > /dev/null 2>/dev/null
rm password.property > /dev/null 2>/dev/null

# 生成ca.key
function run_create_ca_key()
{
   command='openssl genrsa -out ca.key -aes256 2048'
   grep -E 'EulerOS 2.0 \(SP8|EulerOS 2.0 \(SP9' /etc/os-release
   if [ $? -ne 0 ]; then
       command="${command} -sha256"
   fi
   expect <<END
      spawn -noecho ${command}
      expect {
          "*phrase*" {send "${CERT_LOGIN_INFO}\n"; sleep 1; exp_continue}
          "*phrase*" {send "${CERT_LOGIN_INFO}\n"; sleep 1;}
      }
      set timeout 20
END
}

# 生成 ca.crt
function run_create_ca_crt()
{
    cat > config.cnf << EOF
[CA_DN]
countryName = "CN"
organizationName = "huawei"
commonName = "huawei"

[req]
distinguished_name = CA_DN
req_extensions = ca_ext

[ca_ext]
subjectKeyIdentifier = hash
authorityKeyIdentifier = keyid:always,issuer
basicConstraints = critical,CA:true
keyUsage = "Certificate Sign, keyCertSign, cRLSign"
EOF
    command='openssl req -new -x509 -days 7300 -key ca.key -out ca.crt -subj "/C=CN/ST=GuangDong/L=ShenZhen/O=huawei/OU=huawei/CN=huawei" -extensions ca_ext -config config.cnf'
    cat /etc/os-release | grep 'EulerOS 2.0 (SP8)'
    if [ $? -ne 0 ]; then
       command="${command} -sha256"
    fi
    expect <<END
      spawn -noecho ${command}
      expect {
          "*phrase*" {send "${CERT_LOGIN_INFO}\n"; sleep 1;}
      }
      set timeout 20
END
rm -f config.cnf
}

cd /home/omm
for cycle in {1..5}; do
run_create_ca_key >/dev/null 2>/dev/null
run_create_ca_crt >/dev/null 2>/dev/null
if [ 1 == `openssl x509 -noout -text -in ca.crt | grep "CA:" | wc -l` ]; then
    break
  else
    rm -f ca.key
    rm -f ca.crt
  fi
done

# 生成password.property文件
function run_create_password_property()
{
    cd /home/omm;
    expect <<END
      spawn -noecho bash /opt/huawei/Bigdata/om-server/om/sbin/genPwFile.sh
      expect {
          "*password*" {send "${CERT_LOGIN_INFO}\n"; sleep 1; exp_continue}
          "*password*" {send "${CERT_LOGIN_INFO}\n"; sleep 1}
      }
      set timeout 20
END
}
run_create_password_property >/dev/null 2>/dev/null

# 打包ca证书
cd /home/omm;tar -cvf ca.tar ca.crt ca.key password.property >/dev/null 2>/dev/null
# 将ca证书拷贝到临时目录
cp /home/omm/ca.tar ${CA_TMP_PATH}/
chmod 600 ${CA_TMP_PATH}/ca.tar
# 删除临时的ca文件
rm ca.tar ca.crt ca.key password.property >/dev/null 2>/dev/null

exit 0
