#!/bin/bash

declare -r fi_update_work="/opt/fiupdate"
declare fi_update_log=''
declare work_curPath=''
declare product_dir='/opt/fiupdate/NCE_info'
declare root_pwd=''
declare admin_pwd=''
declare mainoms=''
declare ODAAEplugin=''
declare SysVer
declare cpu
declare fi_version=''

TMOUT=0
User_ID=`/usr/bin/id -u`
if [ $User_ID -ne 0 ] 
then
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run user must be root"
    exit 1
fi

read -s -p "please input root password:" root_pwd
echo -e "\n"

read -s -p "please input admin password:" admin_pwd
echo -e "\n"

root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")

ODAAEpluginfile=`find ${fi_update_work}/package/ -name "ODAESwiftDeployPlugin*.zip" -type f`
ODAAEplugin=`basename ${ODAAEpluginfile}`
SysVerInfo=`cat /etc/os-release`
if [[ "$SysVerInfo" =~ "SLES" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE"
    SysVer="SUSE"
elif [[ "$SysVerInfo" =~ "EulerOS" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is EulerOS"
    SysVer="EulerOS"
else
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is not SUSE,is not EulerOS"
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] FI cannot update"
    exit 1
fi
cpu=`uname -a`
if [[ "$cpu" =~ "aarch64" ]]; then
    cpu="ARM"
else
    cpu="x86"
fi

function get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    work_curPath="${PWD}"
    fi_scriptName="$(basename "${BASH_SOURCE-$0}")"
    cd - >/dev/null
}

logDef()
{
    local funcName="$1"; shift
    local logLevel="$1"; shift
    local lineNO="$1"; shift

    local logTime="$(date -d today +'%Y-%m-%d %H:%M:%S')"
    printf "[${logTime}] ${logLevel} $* [${g_scriptName}(${funcName}):${lineNO}]($$)\n" \
        >> "${fi_update_log}" 2>&1
}

log_error()
{
    logDef "${FUNCNAME[1]}" "ERROR" "$@"
}

log_info()
{
    logDef "${FUNCNAME[1]}" "INFO" "$@"
}

function init_log()
{
    if [ ! -d "$fi_update_work/log/" ]
    then
        mkdir "$fi_update_work/log/"
    fi
    
    fi_update_log="$fi_update_work/log/syscheck_clear_data.log"
    [ ! -f "${fi_update_log}" ] && touch "${fi_update_log}"
    chmod 600 "${fi_update_log}"
    echo > ${fi_update_log}
    
}

trap 'onCtrlC' INT
function onCtrlC () {
    echo 'exit program'
    exit 1
}

function runcheck()
{
    product_name=$1
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name:  start to check FI."
    log_info "${LINENO}" "$product_name: start to check FI."
    rm -rf iptmp.conf > /dev/null 2>&1
    cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep finode= |sed 's/finode=//g' >>./iptmp.conf
    cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep Analyzer_Calc_Storage | awk -F "=" {'print $2'} >>./iptmp.conf
    fi_nodes=`sort -u iptmp.conf`
    for fi_node in ${fi_nodes} 
    do        
    expect <<END
            spawn scp -p /opt/fiupdate/pre_config.sh root@${fi_node}:/opt
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$root_pwd\r"}
            }
            set timeout -1
            expect eof
END

    expect <<END
            spawn ssh -t root@${fi_node} "cd /opt/ ; bash pre_config.sh clearflag ; rm -rf /opt/pre_config.sh > /dev/null 2>&1"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$root_pwd\r"}
            }
            set timeout -1
            expect eof
END
    
    done
    rm -rf iptmp.conf > /dev/null 2>&1

    MaxStartups=`cat /etc/ssh/sshd_config | grep -v "#MaxStartups 1000" | grep "MaxStartups 1000"`
    if [ $? -ne 0 ]
    then
        sed -i "s/MaxStartups *.*$/MaxStartups 1000/g" /etc/ssh/sshd_config
        service sshd restart > /dev/null 2>&1
        rm -rf iptmp.conf > /dev/null 2>&1
        cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep finode= |sed 's/finode=//g' >>./iptmp.conf
        cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep Analyzer_Calc_Storage | awk -F "=" {'print $2'} >>./iptmp.conf
        fi_nodes=`sort -u iptmp.conf`
        for fi_node in ${fi_nodes} 
        do
            expect <<END
                    spawn scp -p /opt/fiupdate/pre_config.sh root@${fi_node}:/opt
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout -1
                    expect eof
END
        
            expect <<END
                    spawn ssh -t root@${fi_node} "cd /opt/ ; bash pre_config.sh ssh ; rm -rf /opt/pre_config.sh > /dev/null 2>&1"
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout -1
                    expect eof
END

        done
        rm -rf iptmp.conf > /dev/null 2>&1
    fi

    
    if [ "$SysVer" == "EulerOS" ]
    then    
        perl -i -lpe "s~OPTIONS=.*~OPTIONS=\"-x -l /var/log/ntp.log -f /var/lib/ntp/drift/ntp.drift\"~g" /etc/sysconfig/ntpd > /dev/null 2>&1
        cat /usr/lib/systemd/system/ntpd.service | grep "ExecStart" | grep "\-u ntp:ntp" > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
            sed -i "s/ExecStart=\/usr\/sbin\/ntpd/ExecStart=\/usr\/sbin\/ntpd\ -u\ ntp:ntp/g" /usr/lib/systemd/system/ntpd.service > /dev/null 2>&1
            rm -rf iptmp.conf > /dev/null 2>&1
            cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep finode= |sed 's/finode=//g' >>./iptmp.conf
            cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep Analyzer_Calc_Storage | awk -F "=" {'print $2'} >>./iptmp.conf
            fi_nodes=`sort -u iptmp.conf`
            for fi_node in ${fi_nodes} 
            do        
            expect <<END
                    spawn scp -p /opt/fiupdate/pre_config.sh root@${fi_node}:/opt
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout -1
                    expect eof
END

            expect <<END
                    spawn ssh -t root@${fi_node} "cd /opt/ ; bash pre_config.sh ntp ; rm -rf /opt/pre_config.sh > /dev/null 2>&1"
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout -1
                    expect eof
END
            
            done
            rm -rf iptmp.conf > /dev/null 2>&1
        fi
        systemctl daemon-reload > /dev/null 2>&1
        service ntpd restart > /dev/null 2>&1    
    fi
    
    if [ "$SysVer" == "SUSE" ]
    then    
        perl -i -lpe "s~NTPD_OPTIONS=.*~NTPD_OPTIONS=\"-x -l /var/log/ntp.log -u ntp:ntp -f /var/lib/ntp/drift/ntp.drift\"~g" /etc/sysconfig/ntp > /dev/null 2>&1
        rm -rf iptmp.conf > /dev/null 2>&1
        cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep finode= |sed 's/finode=//g' >>./iptmp.conf
        cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep Analyzer_Calc_Storage | awk -F "=" {'print $2'} >>./iptmp.conf
        fi_nodes=`sort -u iptmp.conf`
        for fi_node in ${fi_nodes} 
        do        
        expect <<END
                    spawn scp -p /opt/fiupdate/pre_config.sh root@${fi_node}:/opt
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout -1
                    expect eof
END
        
        expect <<END
                    spawn ssh -t root@${fi_node} "cd /opt/ ; bash pre_config.sh ntp ; rm -rf /opt/pre_config.sh > /dev/null 2>&1"
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout -1
                    expect eof
END
        
        done
        rm -rf iptmp.conf > /dev/null 2>&1
        systemctl daemon-reload > /dev/null 2>&1
        service ntpd restart > /dev/null 2>&1
    fi

    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`]start install boost."
    rm -rf iptmp.conf > /dev/null 2>&1
    cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep finode= |sed 's/finode=//g' >>./iptmp.conf
    cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep Analyzer_Calc_Storage | awk -F "=" {'print $2'} >>./iptmp.conf
    fi_nodes=`sort -u iptmp.conf`
    for fi_node in ${fi_nodes} 
    do
        boost_install ${fi_node} >> $fi_update_log  
    done
    rm -rf iptmp.conf > /dev/null 2>&1
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name:  start to config python3 "
    log_info "${LINENO}" "$product_name: start to config python3 "
    if [ "${cpu}" == "x86" ]
    then
        rm -rf iptmp.conf > /dev/null 2>&1
        cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep finode= |sed 's/finode=//g' >>./iptmp.conf
        cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep Analyzer_Calc_Storage | awk -F "=" {'print $2'} >>./iptmp.conf
        fi_nodes=`sort -u iptmp.conf`
        for fi_node in ${fi_nodes} 
        do        
        expect <<END
                    spawn scp -p /opt/fiupdate/pre_config.sh root@${fi_node}:/opt
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout 180
                    expect eof
END
        
        expect <<END
                    spawn ssh -t root@${fi_node} "cd /opt/ ; bash pre_config.sh python ; rm -rf /opt/pre_config.sh > /dev/null 2>&1"
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout 600
                    expect eof
END

        done
        rm -rf iptmp.conf > /dev/null 2>&1
    fi

    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: start to do FI clear data check work."
    log_info "${LINENO}" "$product_name: start to do FI clear data check work."
    expect <<END
                spawn scp -p /opt/fiupdate/pre_config.sh root@${mainOms}:/opt
                expect {
                "*yes/no*" {send "yes\r";exp_continue}
                "assword:" {send "$root_pwd\r"}
                }
                set timeout 180
                expect eof
END
        
    expect <<END
                spawn ssh -t root@${mainOms} "cd /opt/ ; bash pre_config.sh iscleardata ; rm -rf /opt/pre_config.sh > /dev/null 2>&1"
                expect {
                "*yes/no*" {send "yes\r";exp_continue}
                "assword:" {send "$root_pwd\r"}
                }
                expect {
                    "*has not been cleared*" {exit 3}
                    "*has been cleared*" {exit 5}
                }
                exit 2
END

    ret=$?
    if [ $ret -eq 3 ]
    then
        log_error "${LINENO}" "$product_name: FI Residual data has not been cleared,please do clear Residual Data after FusionInsight upgrade."
        return 1
    fi
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: FI Check Cleardata Success "
    log_info "${LINENO}" "$product_name: FI Check Cleardata Success "

    chown -R ossadm:ossgroup ${fi_update_work}/log/
    return 0
    
    
}

function boost_install()
{
    fi_node=$1
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`]start install boost-system in node: ip=$fi_node"
    expect <<END
        set timeout 15
        spawn scp -r ${fi_update_work}/python2  root@${fi_node}:/tmp/
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
        "*assword:" {send "$root_pwd\r"}
        }
        set timeout 600
        expect eof
END

    expect <<END
        set timeout 15
        spawn ssh -t root@${fi_node} "systemctl stop lock > /dev/null 2>&1 ; sleep 2 ; rpm -ivh --nodeps /tmp/python2/boost-system* ; sleep 2"
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
        "assword:" {send "$root_pwd\r"}
        }
        set timeout 180
        expect eof
END

    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`]start install boost-atomic in node: ip=$fi_node"
    expect <<END
        set timeout 15
        spawn ssh -t root@${fi_node} "rpm -ivh --nodeps /tmp/python2/boost-atomic* ; sleep 2 ; rm -rf /tmp/python2 > /dev/null 2>&1 ; systemctl start lock > /dev/null 2>&1"
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
        "assword:" {send "$root_pwd\r"}
        }
        set timeout 180
        expect eof
END

}

function precheck_fan()
{
    product_name=$1
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name:  start to config for fan. "
    log_info "${LINENO}" "$product_name: start to config for fan. "
    mkdir -p ${fi_update_work}/json_conf
    chown -R ossadm:ossgroup ${fi_update_work}
    su ossadm -c ". /opt/oss/manager/bin/engr_profile.sh; /opt/oss/manager/tools/resmgr/queryproduct.sh -pn all -output ${fi_update_work}/json_conf"
    PRODUCT_NCE_CONTENT=`find ${fi_update_work}/json_conf/ -name "product_NCE.json" -type f`
    if [ ! -f "${PRODUCT_NCE_CONTENT}" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] output product_json information failed"
        log_error "${LINENO}" "output product_json information failed"
        return 1
    fi
    cur_scene=`cat ${PRODUCT_NCE_CONTENT} | tr ',' '\n' | grep productdesc |awk -F: '{print $2}'|tr -d '"' | grep "NCE-FAN(6K Home Network)"`
    if [ $? -eq 0 ]
    then
        rm -rf iptmp.conf > /dev/null 2>&1
        cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep finode= |sed 's/finode=//g' >>./iptmp.conf
        cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep Analyzer_Calc_Storage | awk -F "=" {'print $2'} >>./iptmp.conf
        fi_nodes=`sort -u iptmp.conf`
        for fi_node in ${fi_nodes} 
        do
            expect <<END
                    spawn scp -p /opt/fiupdate/pre_config.sh root@${fi_node}:/opt
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout 180
                    expect eof
END
        
            expect <<END
                    spawn ssh -t root@${fi_node} "cd /opt/ ; bash pre_config.sh fan ; rm -rf /opt/pre_config.sh > /dev/null 2>&1"
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout 600
                    expect eof
END

        done
        rm -rf iptmp.conf > /dev/null 2>&1
    fi

}

function precheck_ip_single()
{
    product_name=$1
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name:  start to config for ip_single. "
    log_info "${LINENO}" "$product_name: start to config for ip_single. "

    cur_scene=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini | grep 'IP_SINGLE'`
    if [ $? -eq 0 ]
    then
        rm -rf iptmp.conf > /dev/null 2>&1
        cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep finode= |sed 's/finode=//g' >>./iptmp.conf
        cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep Analyzer_Calc_Storage | awk -F "=" {'print $2'} >>./iptmp.conf
        fi_nodes=`sort -u iptmp.conf`
        for fi_node in ${fi_nodes} 
        do
            expect <<END
                    spawn scp -p /opt/fiupdate/pre_config.sh root@${fi_node}:/opt
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout 180
                    expect eof
END
        
            expect <<END
                    spawn ssh -t root@${fi_node} "cd /opt/ ; bash pre_config.sh ipsingle ; rm -rf /opt/pre_config.sh > /dev/null 2>&1"
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout 600
                    expect eof
END

        done
        rm -rf iptmp.conf > /dev/null 2>&1
    fi

}

function unset_parameters()
{
    unset root_pwd
    unset admin_pwd
}


function Main()
{
    log_info "${LINENO}" "start to update fi to 8.0.2.1"
    log_info "${LINENO}" "start to output product info"
    if [ ! -d "$product_dir" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] product conf dir not exists ,please run safeunlock.sh"
        log_error "${LINENO}" "product conf dir not exists ,please run safeunlock.sh"
        return 1
    fi
    product_all=`find $product_dir/ -name "node*.ini" -type f`
    for i in ${product_all}
    do
    {
        product_one=$(basename $i .ini|sed 's/nodes_//g')
        mainOms=`cat /opt/fiupdate/NCE_info/nodes_${product_one}.ini |grep mainOms= |sed 's/mainOms=//g'`
        fi_access_ip=`cat /opt/fiupdate/NCE_info/nodes_${product_one}.ini |grep fiweb|sed 's/fiweb=//g'`
        fi_version=`cat /opt/fiupdate/NCE_info/nodes_${product_one}.ini |grep fi_version= |sed 's/fi_version=//g'`
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to do $product_one product"
        log_info "${LINENO}" "Start to do $product_one product"
        break_out=`cat $i|grep 'syscheck=0'`
        if [ -n "${break_out}" ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] config show $product_one product break syscheck stage"
            log_info "${LINENO}" " config show $product_one product break syscheck stage"
            continue
        else
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] config show $product_one product not break syscheck stage"
            log_info "${LINENO}" " config show $product_one product not break syscheck stage"
        fi

        precheck_fan $product_one
        if [ $? -ne 0 ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`]  $product_one: precheck for fan run failed"
            log_error "${LINENO}" " $product_one: precheck for fan run failed"
            return 1
        fi
        precheck_ip_single $product_one
        if [ $? -ne 0 ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`]  $product_one: precheck for ip_single run failed"
            log_error "${LINENO}" " $product_one: precheck for ip_single run failed"
            return 1
        fi
        runcheck $product_one
        if [ $? -ne 0 ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`]  $product_one: FI check cleardata failed"
            log_error "${LINENO}" " $product_one: FI check cleardata failed"
            return 1
        fi
    
    }
    done
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] script in stage ClearData all FI system success"
    log_info "${LINENO}" "script in stage ClearData all FI system success"
    
    return 0
}



get_cur_path
cd "${work_curPath}"

init_log || return $?

Main
mainresult=$?
unset_parameters
exit $mainresult



