#! /bin/bash

log_file="post_check.sh.log"
task_file="task.log"

echo -n "es_input: os_pwd_root"
read -s os_pwd_root

echo ""

echo -n "es_input: os_pwd_ossadm"
read -s os_pwd_ossadm

echo ""

echo -n "es_input: fi_pwd_admin"
read -s fi_pwd_admin

GetWorkPath()
{
    dir=`/usr/bin/dirname $0`
    ispoint=`/bin/echo $dir| /usr/bin/awk -F/ '{print $1}'`
    if [ "$ispoint" = "." ]
    then
        dir=`/bin/echo $dir|/usr/bin/sed 's/^.//'`
        curpath="`pwd`$dir"
    elif [ "$ispoint" = ".." ]
    then
        curpath="`pwd`/$dir"
    else
       curpath="$dir"
    fi
    
    mkdir -p $curpath/log
    touch $curpath/log/$log_file
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Begin check FusionInsight..."
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Begin check FusionInsight..." >> $curpath/log/$log_file
    
    return 0
}

InitLogDir()
{
    TASKID=${1}
    TASK_ID_PATH="/opt/upgrade/easysuite_upgrade/taskmgr/${TASKID}"
    TASK_LOG_FILE="${TASK_ID_PATH}/task.log"
    TASK_PROGRESS_FILE="${TASK_ID_PATH}/task.progress"
    TASK_STATUS_FILE="${TASK_ID_PATH}/task.status"
    su - ossadm -c "mkdir -p ${TASK_ID_PATH};touch ${TASK_LOG_FILE};touch ${TASK_PROGRESS_FILE};touch ${TASK_STATUS_FILE}"
    
    echo "Progress=0" >${TASK_PROGRESS_FILE}
    echo "Status=start" >${TASK_STATUS_FILE}
    su - ossadm -c "id sopuser 2>/dev/null | grep -qw sopgroup && chgrp -R sopgroup ${TASK_ID_PATH}"
}

# fresh progress
fresh_result()
{
    echo "Progress=$1" >${TASK_PROGRESS_FILE}
    echo "Status=$2" >${TASK_STATUS_FILE}
}

# refresh fail tag
refresh_fail()
{
    fresh_result "100" "fail"
}

# refresh finish tag
fresh_finish()
{
    fresh_result "100" "finish"
}

check_finish()
{
    if [ "${NEW_TASK}"="FALSE" ]
    then
        grep -q "Upgrade FusionInsight Post Check Successfully" ${curpath}/log/${log_file}
        if [ $? -eq 0 ]
        then
            fresh_finish
            return 0
        fi
    fi
    return 1
}

InputParas()
{
    whouser=`whoami`
    if [ "$whouser" != "root" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] please run this script as user 'root' "
        exit 1
    fi
    
    root_pwd=${os_pwd_root}
    ossadm_pwd=${os_pwd_ossadm}
    admin_pwd=${fi_pwd_admin}
    
    ossadm_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${ossadm_pwd}")
    root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
    admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")
}

CheckProcess()
{
    cd /opt/fiupdate/py_work
    script="check_service_status.pyc"
    if [ -f check_service_status.py ]
    then
        script="check_service_status.py"
    fi
    webip=`cat /opt/fiupdate/NCE_info/nodes_*.ini |grep fiweb | sed  's/fiweb=//g'`
    
    expect <<END
        spawn /opt/fiupdate/ODAESwiftDeployPlugin/ODAEDeployTool/rtsp/python/bin/python $script $webip
        set timeout 60
        exec sleep 10
        expect {
            "*assword*" {send "$admin_pwd\r"}
            timeout {send_user "No response!\n"
                    exit 1}
        }
        set timeout 1800
        expect eof
        catch wait ret
        set exit_status [lindex \$ret 3]
        exit \$exit_status
END
    return 0
}

ClearAlarm()
{
    cd /opt/fiupdate/py_work
    script="clear_alarm.pyc"
    if [ -f clear_alarm.py ]
    then
        script="clear_alarm.py"
    fi
    webip=`cat /opt/fiupdate/NCE_info/nodes_*.ini |grep fiweb | sed  's/fiweb=//g'`
    
    expect <<END
        spawn /opt/fiupdate/ODAESwiftDeployPlugin/ODAEDeployTool/rtsp/python/bin/python $script $webip 12010,12012,12034,12062,12006
        set timeout 60
        exec sleep 10
        expect {
            "*assword*" {send "$admin_pwd\r"}
            timeout {send_user "No response!\n"
                    exit 1}
        }
        set timeout 1800
        expect eof
        catch wait ret
        set exit_status [lindex \$ret 3]
        exit \$exit_status
END
    return 0
}

CheckAlarm()
{
    cd /opt/fiupdate/py_work
    script="check_alarm.pyc"
    if [ -f check_alarm.py ]
    then
        script="check_alarm.py"
    fi
    webip=`cat /opt/fiupdate/NCE_info/nodes_*.ini |grep fiweb | sed  's/fiweb=//g'`

    expect <<END
        spawn /opt/fiupdate/ODAESwiftDeployPlugin/ODAEDeployTool/rtsp/python/bin/python $script $webip
        set timeout 60
        exec sleep 10
        expect {
            "*assword*" {send "$admin_pwd\r"}
            timeout {send_user "No response!\n"
                    exit 1}
        }
        set timeout 1800
        expect eof
        catch wait ret
        set exit_status [lindex \$ret 3]
        exit \$exit_status
END
    if [ $? -ne 0 ]
    then
        echo "FusionInsight may be starting, Log in to the FusionInsight web page(https://<Analyzer_Calc_Storage eth0:web IP>:28443/web). Checking the FusionInsight Status, it takes about 20 minutes to start.Perform the check again. Analyzer functions are unavailable before the FusionInsight check is normal."
        echo "FusionInsight may be starting, Log in to the FusionInsight web page(https://<Analyzer_Calc_Storage eth0:web IP>:28443/web). Checking the FusionInsight Status, it takes about 20 minutes to start.Perform the check again. Analyzer functions are unavailable before the FusionInsight check is normal." >> $curpath/log/$task_file
        return 1
    else
        echo "FI is normal."
        echo "FI is normal." >> $curpath/log/$task_file
    fi
    return 0
}


Main()
{
    # Create the easysuite upgrade log dir.
    TASKID=$1
    if [ "x${TASKID}" == "x" ]
    then
        TASKID="upgrade_child_fi"
    fi
    InitLogDir ${TASKID}
    
    NEW_TASK="TRUE"
    [ -d ${TASK_ID_PATH} ] && NEW_TASK="FALSE"
    
    # ǷѾȫִ
    check_finish && return 0
    
    InputParas
    
    # Check whether the FusionInsight process is starting. If yes, wait.
    echo "FusionInsight may be starting, Please Wait."
    echo "FusionInsight may be starting, Please Wait." >> ${TASK_LOG_FILE}
    sleep 200
    CheckProcess >> ${TASK_LOG_FILE}
    
    ClearAlarm
    sleep 30
    CheckAlarm >> ${TASK_LOG_FILE}
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI is abnormal, please check web."
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI is abnormal, please check web." >> $curpath/log/$task_file
        return 1
    else
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI is normal."
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI is normal." >> $curpath/log/$task_file
    fi
    return 0
}

SuperMain()
{
    Main $*
    ret=$?
    if [ $ret -eq 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Upgrade FusionInsight Post Check Successfully."
        fresh_finish
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Upgrade FusionInsight Post Check Successfully." >> $curpath/log/$log_file
    else
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Upgrade FusionInsight Post Check failed."
        fresh_result "100" "check_exception"
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Upgrade FusionInsight Post Check failed." >> $curpath/log/$log_file
    fi
    return $ret
}

GetWorkPath
SuperMain $* &
superret=$?
exit $superret
