#! /bin/bash

log_file="post_rollback_update_fi.sh.log"
declare odae_work='/opt/fiupgrade'

GetWorkPath()
{
    dir=`/usr/bin/dirname $0`
    ispoint=`/bin/echo $dir| /usr/bin/awk -F/ '{print $1}'`
    if [ "$ispoint" = "." ]
    then
        dir=`/bin/echo $dir|/usr/bin/sed 's/^.//'`
        curpath="`pwd`$dir"
    elif [ "$ispoint" = ".." ]
    then
        curpath="`pwd`/$dir"
    else
       curpath="$dir"
    fi
    
    mkdir -p $curpath/log
    touch $curpath/log/$log_file
    
    return 0
}


InputParas()
{
    whouser=`whoami`
    if [ "$whouser" != "root" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] please run this script as user 'root' "
        exit 1
    fi

    read -s -p "please input root password:" root_pwd
    echo -e "\n"
    
    read -s -p "please input FusionInsight admin password:" admin_pwd
    echo -e "\n"

    root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
    admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")
}

function set_premeters()
{
    product_name=$1
    if [ ! -f "/opt/fiupdate/NCE_info/nodes_${product_name}.ini" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: FI nodes config file not exists,please check"
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name: FI nodes config file not exists,please check" >> $curpath/log/$log_file
        return 1
    fi
    mainOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep mainOms= |sed 's/mainOms=//g'`
    fiweb=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini|grep fiweb | sed  's/fiweb=//g'`
    
    return 0
     
}

function ClearAlarm()
{
    product_name=$1
    mainOms=$2
    fiweb=$3
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name : clear alarm."
    expect <<END
        spawn ssh -t root@${mainOms} " cd /opt/fiupdate;bash clear_alarm.sh rollback $fiweb >> $curpath/log/$log_file"
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
        "assword:" {send "$root_pwd\r"}
        }
        expect "*assword:"
        send "$admin_pwd\r"
        set timeout -1
        expect eof
END

}

function doPost()
{

    cd $odae_work/ODAEDeployTool/bin/
    
    expect <<END
    spawn bash upgrade_fi.sh rollback
    set timeout -1
    expect "*assword:"
    send "true,$root_pwd\r"
    set timeout -1
    expect "*assword:"
    send "true,$admin_pwd\r"
    set timeout -1
    expect eof

    catch wait ret
    set exit_status [lindex \$ret 3]
    exit \$exit_status
END
   
    if [ $? -ne 0 ] 
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run odae rollback script failed,please check $odae_work/ODAEDeployTool/var/logs"
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run odae rollback script failed,please check $odae_work/ODAEDeployTool/var/logs" >> $curpath/log/$log_file
        return 1
    fi

    return 0

}

Main()
{
    GetWorkPath
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] begin update FusionInsight..." >> $curpath/log/$log_file
    
    InputParas
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] begin do post rollback FusionInsight..." >> $curpath/log/$log_file
    product_dir='/opt/fiupdate/NCE_info'
    product_all=`find $product_dir/ -name "nodes_*.ini" -type f`
    for product_ini in ${product_all}
    do
    {
        product_one=$(basename $product_ini .ini|sed 's/nodes_//g')
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to do $product_one product"
        rm -rf iptmp.conf > /dev/null 2>&1
        cat $product_ini |grep finode= |sed 's/finode=//g' >>./iptmp.conf
        cat $product_ini |grep Analyzer_Calc_Storage | awk -F "=" {'print $2'} >>./iptmp.conf
        fi_nodes=`sort -u iptmp.conf`
        for fi_node in ${fi_nodes}
        do        
        expect <<END
                    spawn scp -p /opt/fiupdate/pre_config.sh root@${fi_node}:/opt
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout -1
                    expect eof
END
        
        expect <<END
                    spawn ssh -t root@${fi_node} "cd /opt/ ; bash pre_config.sh ntp ; bash pre_config.sh rollbackengr ; rm -rf /opt/pre_config.sh > /dev/null 2>&1"
                    expect {
                    "*yes/no*" {send "yes\r";exp_continue}
                    "assword:" {send "$root_pwd\r"}
                    }
                    set timeout -1
                    expect eof
END
        
        done
        rm -rf iptmp.conf > /dev/null 2>&1

        set_premeters $product_one
        ClearAlarm $product_one $mainOms $fiweb
        doPost
        if [ $? -ne 0 ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_one: run odae rollback script failed."
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_one: run odae rollback script failed." >> $curpath/log/$log_file
            return 1
        fi
        httpd=`ps -ef | grep httpd | grep -v grep | grep '8.0'`
        if [ -n "$httpd" ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] the apache version is not right, restart it. " >> $curpath/log/$log_file
            ps -ef | grep httpd | grep -v grep | awk {'print $2'} | xargs kill -9 > /dev/null 2>&1
        fi
    
    }
    done


}

Main $*
ret=$?
if [ $ret -eq 0 ]
then
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Doing post rollback FusionInsight Successfully."
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Doing post rollback FusionInsight Successfully." >> $curpath/log/$log_file
else
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Doing post rollback FusionInsight failed."
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Doing post rollback FusionInsight failed." >> $curpath/log/$log_file
fi
exit $ret
