#!/bin/bash

declare -r fi_update_work="/opt/fiupdate"
declare fi_update_log=''
declare work_curPath=''
declare pro_info="NCE_info"
declare fiweb=''
declare analyzer_scene=''
declare analyzer_scale=''
declare update_config=''
declare real_config=''
declare real_dir=''
declare odae_work='/opt/fiupgrade'
declare SysVer
declare SysVerDetail
declare root_pwd=''
declare admin_pwd=''

TMOUT=0
User_ID=`/usr/bin/id -u`
if [ $User_ID -ne 0 ] 
then
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run user must be root"
    exit 1
fi
read -s -p "please input root password:" root_pwd
echo -e "\n"

read -s -p "please input admin password:" admin_pwd
echo -e "\n"

root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")

SysVerInfo=`cat /etc/os-release`
if [[ "$SysVerInfo" =~ "SLES" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE"
    SysVer="SUSE"
    if [[ "$SysVerInfo" =~ "12.2" ]];then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE12SP2" 
        SysVerDetail="SUSE12SP2"
    elif [[ "$SysVerInfo" =~ "12.4" ]];then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE12SP4" 
        SysVerDetail="SUSE12SP4"
    else
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is Suse, but not SUSE12SP2 and SUSE12SP4"
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] FI cannot update"
        exit 1
    fi
elif [[ "$SysVerInfo" =~ "EulerOS" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is EulerOS"
    SysVer="EulerOS"
    SysVerDetail="EULER2SP5"
else
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is not SUSE,is not EulerOS"
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] FI cannot update"
    exit 1
fi

function get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    work_curPath="${PWD}"
    fi_scriptName="$(basename "${BASH_SOURCE-$0}")"
    cd - >/dev/null
}

logDef()
{
    local funcName="$1"; shift
    local logLevel="$1"; shift
    local lineNO="$1"; shift

    local logTime="$(date -d today +'%Y-%m-%d %H:%M:%S')"
    printf "[${logTime}] ${logLevel} $* [${g_scriptName}(${funcName}):${lineNO}]($$)\n" \
        >> "${fi_update_log}" 2>&1
}

log_error()
{
    logDef "${FUNCNAME[1]}" "ERROR" "$@"
}

log_info()
{
    logDef "${FUNCNAME[1]}" "INFO" "$@"
}

function init_log()
{
    if [ ! -d "$fi_update_work/log" ]
    then
        mkdir "$fi_update_work/log"
    fi
    fi_update_log="$fi_update_work/log/post_fiupdate_8021.log"
    [ ! -f "${fi_update_log}" ] && touch "${fi_update_log}"
    chmod 600 "${fi_update_log}"
    echo > ${fi_update_log}
    
}

function output_info()
{
    cd ${fi_update_work}
    if [ -d ${pro_info} ]
    then
        rm -fr ${pro_info}
    fi
    mkdir ${pro_info}
    if [ ! -f "/opt/oss/manager/tools/resmgr/queryproduct.sh" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] platform queryproduct script not exists,please check"
        log_error "${LINENO}" "platform queryproduct script not exists,please check"
        return 1
    fi

    if [ ! -f "/opt/oss/manager/tools/resmgr/modifynodesinfo.sh" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] platform modifynode script not exists,please check"
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] platform modifynode script not exists,please check" >> $Modify_LOG
        return 1
    fi

    if [ ! -f "/opt/oss/manager/tools/resmgr/modifyproductinfo.sh" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] platform modifyproduct script not exists,please check"
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] platform modifyproduct script not exists,please check" >> $Modify_LOG
        return 1
    fi
    
    if [ ! -f "/opt/oss/manager/var/tenants/NCE/nodelist.json" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] platform nodelist json not exists,please check"
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] platform nodelist json not exists,please check" >> $Modify_LOG
        return 1
    fi

    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to output node and product information"
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to output node and product information" > $Modify_LOG
    cd /opt/oss/manager/tools/resmgr/
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to modify node and product information"
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to modify node and product information" >> $Modify_LOG
    sh queryproduct.sh -pn NCE -output $ModifyWork
    if [ $? -ne 0 ] 
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] output node and product information failed"
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] output node and product information failed" >> $Modify_LOG
        return 1
    fi
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] output node and product information success"
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] output node and product information success" >> $Modify_LOG
    return 0
}

function set_timeout()
{
    if [ -f "/etc/bashrc" ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] start to check sys tmout"
        log_info "${LINENO}" "start to check sys tmout"
        tmresult=`cat /etc/bashrc|grep TMOUT`
        if [ ! -n "$tmresult" ]
        then
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout not need to change"
            log_info "${LINENO}" "sys tmout not need to change"
            return 0
        fi
        cat /etc/bashrc |grep TMOUT |while read tmout_sys
        do
            if [ ! -n "$tmout_sys" ]
            then
                echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout not need to change"
                log_info "${LINENO}" "sys tmout not need to change"
            else
                echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout need to change" 
                log_info "${LINENO}" "sys tmout need to change"
                if [[ "$tmout_sys" =~ "export" ]]
                then
                    sed -i "s/$tmout_sys/export TMOUT=300/g" /etc/bashrc
                    source /etc/bashrc
                    echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout change success,is to set $TMOUT" 
                    log_info "${LINENO}" "sys tmout change success,is to set $TMOUT"
                else
                    sed -i "s/$tmout_sys/TMOUT=300/g" /etc/bashrc
                    source /etc/bashrc
                    echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout change success,is to set $TMOUT" 
                    log_info "${LINENO}" "sys tmout change success,is to set $TMOUT"
                fi
            fi
        done
    fi
    service sshd restart
    return 0

}

function runpost()
{
    cd /opt
    if [ -f "/opt/FusionInsight_SetupTool/upgrade/etc/preinstall.ini" ]
    then
        rm -f /opt/FusionInsight_SetupTool/upgrade/etc/preinstall.ini
    fi
    
    if [ "$SysVerDetail" == "SUSE12SP2" ]
    then
        cp -f $fi_update_work/conf/preinstall/SUSE12SP2_preinstall.ini /opt/FusionInsight_SetupTool/upgrade/etc/preinstall.ini > /dev/null 2>&1
    fi
    
    if [ "$SysVerDetail" == "SUSE12SP4" ]
    then
        cp -f $fi_update_work/conf/preinstall/SUSE12SP4_preinstall.ini /opt/FusionInsight_SetupTool/upgrade/etc/preinstall.ini > /dev/null 2>&1
    fi
    
    if [ "$SysVerDetail" == "EULER2SP5" ]
    then
        cp -f $fi_update_work/conf/preinstall/EULER2SP5_preinstall.ini /opt/FusionInsight_SetupTool/upgrade/etc/preinstall.ini > /dev/null 2>&1
    fi
    
    if [ -f "/opt/FusionInsight_SetupTool/upgrade/upgrade_setup.sh" ]
    then
        sed -i 's/g_add_pkg=1/g_add_pkg=0/g' /opt/FusionInsight_SetupTool/upgrade/upgrade_setup.sh
    fi
        
    
    if [ ! -f "$odae_work/ODAEDeployTool/bin/upgrade_fi.sh" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] odae update script not exists"
        log_error "${LINENO}" "odae update script not exists"
        return 1
    fi

    cd $odae_work/ODAEDeployTool/bin/

    expect <<END
    spawn bash upgrade_fi.sh confirm
    set timeout -1
    expect "*assword:"
    send "true,$root_pwd\r"
    set timeout -1
    expect "*assword:"
    send "true,$admin_pwd\r"
    set timeout -1
    expect eof

    catch wait ret
    set exit_status [lindex \$ret 3]
    exit \$exit_status
END
   
    if [ $? -ne 0 ] 
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run odae confirm script failed,please check $odae_work/ODAEDeployTool/var/logs/patch_confirm.log"
        log_error "${LINENO}" "run odae confirm script failed,please check $odae_work/ODAEDeployTool/var/logs/patch_confirm.log"
        return 1
    fi
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] run odae confirm script success"
    log_info "${LINENO}" "run odae confirm script success"
    
    return 0

}

function post_clean()
{
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] start to uninstall update service and odaeplugin service"
    log_info "${LINENO}" "start to uninstall update service and odaeplugin service"
    if [ -f /opt/huawei/Bigdata/update-service/update-manager.sh ]
    then
        bash /opt/huawei/Bigdata/update-service/update-manager.sh stop
        if [ $? -ne 0 ] 
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] stop fi update service manager failed"
            log_error "${LINENO}" "stop fi update service manager failed"
            return 1
        fi
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] stop fi update service manager success"
        log_info "${LINENO}" "stop fi update service manager success"
    fi

    if [ -f /opt/huawei/Bigdata/update-service/uninstall.sh ]
    then
        bash /opt/huawei/Bigdata/update-service/uninstall.sh
        if [ $? -ne 0 ] 
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] uninstall fi update service failed"
            log_error "${LINENO}" "uninstall fi update service failed"
            return 1
        fi
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] uninstall fi update service success"
        log_info "${LINENO}" "uninstall fi update service success"
    fi

    if [ -d /opt/huawei/Bigdata/update-service ]
    then
        rm -fr /opt/huawei/Bigdata/update-service
    fi

    if [ -d /opt/huawei/Bigdata/upload ]
    then
        rm -fr /opt/huawei/Bigdata/upload
    fi
    
    if [ -f "$odae_work/ODAEDeployTool/bin/uninstall.sh" ]
    then
        cd $odae_work/ODAEDeployTool/bin/
        bash uninstall.sh
    fi
    
    cd /opt
    if [ -d "$odae_work" ]
    then
        rm -fr $odae_work
    fi
    
    if [ -d "$fi_update_work" ]
    then
        rm -f $fi_update_work/*.sh  
        rm -fr $fi_update_work/NCE_info
        rm -fr $fi_update_work/NCE_info_tmp
        rm -fr $fi_update_work/python2
        rm -fr $fi_update_work/py_work
        rm -fr $fi_update_work/package
        rm -fr $fi_update_work/rpm_package
        rm -fr ${fi_update_work}/ODAESwiftDeployPlugin
        rm -fr $fi_update_work/tools
        chmod 600 -R $fi_update_work/conf
        chmod 600 -R $fi_update_work/log
    fi
    
    return 0
}


function Main()
{
    log_info "${LINENO}" "post work for update fi to 8.0.2.1"    
    runpost
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] postwork run odae confirm script failed"
        log_error "${LINENO}" "postwork run odae confirm script failed"
        return 1
    fi
    
    post_clean
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] postwork post clean failed"
        log_error "${LINENO}" "postwork post clean failed"
        return 1
    fi
    set_timeout
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] postwork set timeout failed"
        log_error "${LINENO}" "postwork set timeout failed"
        return 1
    fi  
    
    return 0    
}


get_cur_path
cd "${work_curPath}"

init_log || return $?

Main
mainresult=$?
exit $mainresult
