#!/bin/bash
SysVerInfo=`cat /etc/os-release`
if [[ "$SysVerInfo" =~ "SLES" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE"
    SysVer="SUSE"
    if [[ "$SysVerInfo" =~ "12.2" ]];then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE12SP2" 
        SysVerDetail="SUSE12SP2"
    elif [[ "$SysVerInfo" =~ "12.4" ]];then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE12SP4" 
        SysVerDetail="SUSE12SP4"
    else
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is Suse, but not SUSE12SP2 and SUSE12SP4"
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] FI cannot update"
        exit 1
    fi
elif [[ "$SysVerInfo" =~ "EulerOS" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is EulerOS"
    SysVer="EulerOS"
    SysVerDetail="EULER2SP5"
else
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is not SUSE,is not EulerOS"
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] FI cannot update"
    exit 1
fi

function preconfig_omm()
{
    echo "AllowUsers omm" >> /etc/ssh/sshd_config
    echo "AllowUsers ftpuser" >> /etc/ssh/sshd_config
    echo "AllowUsers ossadm" >> /etc/ssh/sshd_config
    echo "AllowUsers ossuser" >> /etc/ssh/sshd_config
    echo "AllowUsers dbuser" >> /etc/ssh/sshd_config
    echo "AllowUsers root" >> /etc/ssh/sshd_config
    service sshd restart > /dev/null 2>&1
}

function preconfig_python3()
{
    #x86 config python3
    cloudsop_py=`/opt/oss/manager/agent/rtsp/python/bin/python -V`
    if [ ! -f /usr/bin/python3 ];then
        systemctl stop lock > /dev/null 2>&1
        mkdir -p /opt/python3/ > /dev/null 2>&1
        cp -rf /opt/oss/manager/agent/rtsp/python/* /opt/python3/ > /dev/null 2>&1
        chmod -R 755 /opt/python3/  > /dev/null 2>&1
        chown -R root:root /opt/python3/ > /dev/null 2>&1
        ln -sf /opt/python3/bin/python /usr/bin/python3 > /dev/null 2>&1
        /usr/bin/python3 -V | grep "${cloudsop_py}" > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
            echo "\n[`date '+%Y-%m-%d %H:%M:%S'`]Install failed , can not found /usr/bin/python3."
            return 1
        fi  
        if [ ! -f /usr/bin/python -a ! -f /bin/python ]
        then
            ln -sf /opt/python3/bin/python /usr/bin/python > /dev/null 2>&1
        fi
        systemctl start lock > /dev/null 2>&1
    fi
	
}

function fixweb()
{
    chmod 666 /tmp/*.plock
    chown root:root /tmp/*.plock
    chmod 666 /tmp/D55E11D4CE9921E3AF1110943F8AF3CCE7431BC9FBEF5B2B5D8354DDF193823C
    chown root:root /tmp/D55E11D4CE9921E3AF1110943F8AF3CCE7431BC9FBEF5B2B5D8354DDF193823C
    chmod 666 /tmp/_wcc_file_locker_
    chown root:root /tmp/_wcc_file_locker_
}

function checkupgradeos()
{
    if [ -f /tmp/auto_start_fi.sh.R20C10.log ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]The OS has been upgraded or rollback, need to start cluster."
        return 0
    else
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]The OS is not upgraded or rollback, do nothing."
    fi
}

function checkcleardata()
{
    if [ -d /opt/huawei/Bigdata/update-service ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]Data has not been cleared. Please check."
        return 0
    else
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]Data has been cleared, do nothing."
    fi
}

function checkupgradepreset()
{
    if [ -f /var/lib/sudo/Bigdata/setuptool/installSudoExecute.sh ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]The preset has been executed OK, do nothing."
        return 0
    else
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]The preset needs to be executed again."
    fi
}

function check_cluster_status()
{
    out=`bash /opt/engr/py_work/check_cluster.sh`
    echo "$out" | grep "check FI all services is started status." > /dev/null
    if [ $? -eq 0 ]
    then
        return 0
    fi
    return 1
}

function checkclusterflag()
{
    if [ -f /tmp/Start_Cluster_OK_Flag ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]check cluster status,start cluster success."
        return 0
    fi
    
    check_cluster_status
    if [ $? -eq 0 ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]flag not exist but cluster started."
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]check cluster status,start cluster success."
        return 0
    fi
    
    if [ -f /tmp/Start_Cluster_Failed_Flag ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]check cluster status,start cluster failed."
        return 0
    fi
}

function fixsudo()
{
    sudotemp=`cat /var/lib/sudo/Bigdata/sudo/runtime/sudoExecute.sh | grep 'echo \"path \${temppath}'`
    if [ "x${sudotemp}" == "x" ];then
        sed -i '/temppath=\"\$CDM/a\    if [ -L \"\${temppath}\" ];then\n       echo \"path \${temppath} is link\"\n       return 1\n    fi' /var/lib/sudo/Bigdata/sudo/runtime/sudoExecute.sh
    fi
    sudopath=`cat /var/lib/sudo/Bigdata/sudo/runtime/sudoExecute.sh | grep 'echo \"path \${1}'`
    if [ "x${sudopath}" == "x" ];then
        sed -i  '/echo \"\${1}\" | grep \"\${corr/a\    if [ -L \"\${1}\" ];then\n       echo \"path \${1} is link\"\n       return 1\n    fi' /var/lib/sudo/Bigdata/sudo/runtime/sudoExecute.sh
    fi
    perl -i -lpe 's~chown omm:ficommon "\$DATA_DIR" && chmod 750 "\$DATA_DIR"~single_chown omm:ficommon "\$DATA_DIR" && single_chmod 750 "\$DATA_DIR"~g' /var/lib/sudo/Bigdata/sudo/runtime/sudoExecute.sh
    perl -i -lpe 's~chown omm:wheel "\$DATA_DIR" && chmod 700 "\$DATA_DIR"~single_chown omm:wheel "\$DATA_DIR" && single_chmod 700 "\$DATA_DIR"~g' /var/lib/sudo/Bigdata/sudo/runtime/sudoExecute.sh
    
    cp /var/lib/sudo/Bigdata/sudo/runtime/sudoExecute.sh /opt/huawei/Bigdata/om-agent_8.0.2.1/nodeagent/bin/sudo/runtime/sudoExecute.sh
    cp /var/lib/sudo/Bigdata/sudo/runtime/sudoExecute.sh /opt/huawei/Bigdata/om-server_8.0.2.1/om/sbin/sudo/runtime/sudoExecute.sh
}

function fixlog()
{
    su - omm -c "/opt/huawei/Bigdata/om-server/om/sbin/modifyLogConfig.sh -m 20" > /dev/null 2>&1
}

function fixemail()
{
    shell_file="/opt/huawei/Bigdata/om-server_8.0.2.1/om/sbin/replacehaSSLCert.sh" 
    if [ -f "$shell_file" ];then 
        sed -i "/IT@huawei.com/d" ${shell_file} 
    fi 
}

function fixcpuusage()
{
    host_file="/opt/huawei/Bigdata/om-agent_8.0.2.1/nodeagent/bin/pluginScript/host_metric_collect.sh"
    is_time=`cat ${host_file} | grep "time1"`
    is_t=`cat ${host_file} | grep "t3"`
    insert_content="time1=\$(date \"+%Y%m%d%H%M%S\")\necho \$time1\ntime2=\${time1:11:1}\necho \$time2\nt3=5\nt4=0\nif [ \$time2 -ne \$t3 ] && [ \$time2 -ne \$t4 ]\nthen\n    exit 0\nfi"
    if [ -f "${host_file}" ]
    then
        if [ "x${is_time}" == "x" -a "x${is_t}" == "x" ]
        then
            sed -i "2a\ ${insert_content}" ${host_file}
            su - omm -c "/opt/huawei/Bigdata/om-agent/nodeagent/bin/stop-agent.sh"
            su - omm -c "/opt/huawei/Bigdata/om-agent/nodeagent/bin/start-agent.sh"
        fi
    fi
}

function fixodaelink()
{
    if [ -L /home/omm/srv/BigData/hadoop ]
    then
        return
    fi
    mkdir -p /home/omm/srv/BigData
    chown -R omm:wheel /home/omm/srv
    ln -s /srv/BigData/hadoop /home/omm/srv/BigData/hadoop
}

function preconfig_ssh()
{
    sed -i "s/MaxStartups *.*$/MaxStartups 1000/g" /etc/ssh/sshd_config
    service sshd restart > /dev/null 2>&1
}
function clear_flag()
{
    rm -rf /tmp/Start_Cluster_Failed_Flag > /dev/null 2>&1
    rm -rf /tmp/Start_Cluster_OK_Flag > /dev/null 2>&1
    rm -rf /tmp/auto_start_fi.sh.R20C10.log > /dev/null 2>&1
    rm -rf /tmp/AnalyzerFusionInsightClient > /dev/null 2>&1
    #check the /etc/hosts
    line_num=0
    cat /etc/hosts | while read line
    do
        line_num=$[line_num+1]
        result=$(cat /etc/hosts | grep "${line}" | wc -l)
        if [ "x${result}" != "x1" ]
        then
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] Duplicate configuration exists in line ${line_num}." >> /tmp/pre_checkhosts
            sed -i "${line_num}s/${line}//g" /etc/hosts > /dev/null 2>&1
        fi
    done
    #modifying kernel parameters
    echo "8192" > /proc/sys/kernel/pty/max
}

function check_optsize()
{
    optsize=`df -h | grep -w /opt | awk {'print $4'}`
    optnum=`df -h | grep -w /opt | awk {'print $4'} | awk -F "G" {'print $1'}`
    if [[ "$optsize" =~ "G" || "$optsize" =~ "T" ]]; then
        if [[ "$optsize" =~ "T" ]]; then
            echo "check opt is enough."
        fi
        if [[ "$optsize" =~ "G" ]]; then
            result=`echo "$optnum > 40" | bc`
            if [ $result -ne 1 ]; then
                echo "check opt is not enough."
            else
                echo "check opt is enough."
            fi
        fi
    else
        echo "check opt is not enough."
    fi
    if [ -d /opt/engr ]
    then
        rm -rf /opt/engr_bak > /dev/null 2>&1
        cp -r /opt/engr /opt/engr_bak > /dev/null 2>&1
    fi
}

function check_postclear()
{
    if [ -d /opt/engr_bak ]
    then
        rm -rf /opt/engr_bak > /dev/null 2>&1
    fi
}

function rollback_engr()
{
    if [ -d /opt/engr_bak ]
    then
        rm -rf /opt/engr > /dev/null 2>&1
        cp -r /opt/engr_bak /opt/engr > /dev/null 2>&1
    fi
}

function check_tmpsize()
{
    tmpsize=`df -h | grep -w /tmp | awk {'print $4'}`
    tmpnum=`df -h | grep -w /tmp | awk {'print $4'} | awk -F "G" {'print $1'}`
    if [[ "$tmpsize" =~ "G" || "$tmpsize" =~ "T" ]]; then
        if [[ "$tmpsize" =~ "T" ]]; then
            echo "check tmp is enough."
        fi
        if [[ "$tmpsize" =~ "G" ]]; then
            result=`echo "$tmpnum > 8.5" | bc`
            if [ $result -ne 1 ]; then
                echo "check tmp is not enough."
            else
                echo "check tmp is enough."
            fi
        fi
    else
        echo "check tmp is not enough."
    fi
}

function clear_packge()
{
    rm -rf /opt/fiupdate/package > /dev/null 2>&1
}

function preconfig_acs()
{
    # FI ACS
    if [ -d /opt/huawei/Bigdata/om-server/om/sbin -a -d /opt/engr ]
    then
        cp -r /opt/engr/monitor_acs_out_mem.sh /opt/huawei/Bigdata/om-server/om/sbin/monitor_acs_out_mem.sh > /dev/null 2>&1
        chmod 700 /opt/huawei/Bigdata/om-server/om/sbin/monitor_acs_out_mem.sh > /dev/null 2>&1
        chown omm:wheel /opt/huawei/Bigdata/om-server/om/sbin/monitor_acs_out_mem.sh > /dev/null 2>&1
    fi
}

function post_coredump()
{
    # FI coredump
    rm -rf /opt/coredump/core.java.2000* > /dev/null 2>&1
    rm -rf /opt/osbackup/var/lib/systemd/coredump/core.java.2000* > /dev/null 2>&1
    rm -rf /var/lib/systemd/coredump/core.java.2000* > /dev/null 2>&1
    touch $mainOms > /dev/null 2>&1
    chmod 550 $mainOms > /dev/null 2>&1
    chown ossadm:ossgroup $mainOms > /dev/null 2>&1
    cat /etc/sysctl.conf | grep "fs.file-max" > /dev/null
    if [ $? -ne 0 ]
    then
        echo "fs.file-max = 6522520" >> /etc/sysctl.conf
    else
        perl -i -lpe "s~fs.file-max.*~fs.file-max = 6522520~g" /etc/sysctl.conf
    fi
    sysctl -p /etc/sysctl.conf > /dev/null
    #modifying kernel parameters
    echo "4096" > /proc/sys/kernel/pty/max
}

function preconfig_ntp()
{
    if [ "$SysVer" == "EulerOS" ]
    then
        perl -i -lpe "s~OPTIONS=.*~OPTIONS=\"-x -l /var/log/ntp.log -f /var/lib/ntp/drift/ntp.drift\"~g" /etc/sysconfig/ntpd > /dev/null 2>&1
        cat /usr/lib/systemd/system/ntpd.service | grep "ExecStart" | grep "\-u ntp:ntp" > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
            sed -i "s/ExecStart=\/usr\/sbin\/ntpd/ExecStart=\/usr\/sbin\/ntpd\ -u\ ntp:ntp/g" /usr/lib/systemd/system/ntpd.service > /dev/null 2>&1
        fi
        systemctl daemon-reload > /dev/null 2>&1
        service ntpd restart > /dev/null 2>&1
    fi
    
    if [ "$SysVer" == "SUSE" ]
    then
        perl -i -lpe "s~NTPD_OPTIONS=.*~NTPD_OPTIONS=\"-x -l /var/log/ntp.log -u ntp:ntp -f /var/lib/ntp/drift/ntp.drift\"~g" /etc/sysconfig/ntp > /dev/null 2>&1
        systemctl daemon-reload > /dev/null 2>&1
        service ntpd restart > /dev/null 2>&1
    fi
}

function preconfig_ntp_rollback()
{
    if [ "$SysVer" == "EulerOS" ]
    then
        perl -i -lpe "s~OPTIONS=.*~OPTIONS=\"-x -l /var/log/ntp.log -u ntp:ntp -f /var/lib/ntp/drift/ntp.drift\"~g" /etc/sysconfig/ntpd > /dev/null 2>&1
        cat /usr/lib/systemd/system/ntpd.service | grep "ExecStart" | grep "\-u ntp:ntp" > /dev/null 2>&1
        if [ $? -eq 0 ]
        then
            sed -i "s/ExecStart=\/usr\/sbin\/ntpd\ -u\ ntp:ntp/ExecStart=\/usr\/sbin\/ntpd/g" /usr/lib/systemd/system/ntpd.service > /dev/null 2>&1
        fi
        systemctl daemon-reload > /dev/null 2>&1
        service ntpd restart > /dev/null 2>&1
    fi

    if [ "$SysVer" == "SUSE" ]
    then
        perl -i -lpe "s~NTPD_OPTIONS=.*~NTPD_OPTIONS=\"-x -l /var/log/ntp.log -u ntp:ntp -f /var/lib/ntp/drift/ntp.drift\"~g" /etc/sysconfig/ntp > /dev/null 2>&1
        systemctl daemon-reload > /dev/null 2>&1
        service ntpd restart > /dev/null 2>&1
    fi

}

function preconfig_register()
{
    if [ -f /opt/huawei/Bigdata/om-server_8.0.2.1/om/sbin/register_pack.sh ]
    then
        sed -i "s/exec_standby_cmd 600/exec_standby_cmd 2000/g" /opt/huawei/Bigdata/om-server_8.0.2.1/om/sbin/register_pack.sh > /dev/null 2>&1
    fi
}

function preconfig_fan()
{
    if [ ! -f /opt/huawei/Bigdata/om-agent/nodeagent/bin/nodeagent_ctl.sh ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]nodeagent_ctl.sh not exists,do not config."
        return 0
    fi
    sed -i 's/-Xmx512m/-Xmx1024m/g' /opt/huawei/Bigdata/om-agent/nodeagent/bin/nodeagent_ctl.sh > /dev/null 2>&1
    su - omm -c "bash /opt/huawei/Bigdata/om-agent/nodeagent/bin/stop-agent.sh" > /dev/null 2>&1
    su - omm -c "bash /opt/huawei/Bigdata/om-agent/nodeagent/bin/start-agent.sh" > /dev/null 2>&1
    
}

function pre_sudoexecute()
{
    if [ -f /var/lib/sudo/Bigdata/sudo/runtime/sudoExecute.sh ]
    then
        perl -i -lpe "s~/usr/sbin/sssd -D -f~ldap_stopSssd\n    /bin/rm -f /var/lib/sss/db/cache_*.ldb\n    /usr/sbin/sssd -D -f~g" /var/lib/sudo/Bigdata/sudo/runtime/sudoExecute.sh
    fi
}

function checkagent_pid_num()
{
    #check ssh-agent pid num
    agent_pid_num=$(ps -ef ww | grep 'ssh-agent -a /home/omm/.ssh/agent.pid' | grep -v grep | wc -l)
    if [ "x${agent_pid_num}" == "x1" ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] The ssh-agent pid is normal, do nothing." >> /tmp/checkagent_pidnum
    else
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] The ssh-agent pid value is not 1, Manually restart the ssh-agent." >> /tmp/checkagent_pidnum
        ps -ef ww | grep 'ssh-agent -a /home/omm/.ssh/agent.pid' | grep -v grep | awk '{print $2}' | xargs kill -9 > /dev/null 2>&1
    fi
    
}

function check_sudo()
{
    string="NOPASSWD:"
    line_num=0
    cat /etc/sudoers | while read line
    do
        line_num=$[line_num+1]
        result=$(echo $line | grep "${string}")
        if [[ "$result" != "" ]]
        then
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] ${line}." >> /tmp/checksudo
            check_config_line=`echo ${line} | awk -F "NOPASSWD:" {'print $2'}`
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] ${check_config_line}." >> /tmp/checksudo
            if [ ! -n "${check_config_line}" ]
            then
                echo "[`date '+%Y-%m-%d %H:%M:%S'`] The configuration in row ${line_num} is incorrect and needs to be reconfigured." >> /tmp/checksudo
                sed -i "${line_num}s/${line} *.*$/#${line}/g" /etc/sudoers
            fi
        fi 
    
    done
}
#check runtime
function check_runtime()
{
    if [ -h "/opt/huawei/Bigdata/common/runtime" ]
    then
        echo "check runtime is success."
    else
        echo "check runtime is failed."
    fi
}

function decompress_package()
{
    work_path=/opt/huawei/Bigdata/packages/upgrade
    package_all=`find $work_path/ -name "FusionInsight_*.tar.gz" -type f`
    for package_name in ${package_all}
    do
        directory_name=`echo ${package_name} | awk -F '.tar.gz' {'print $1'}`
        if [ ! -d ${directory_name} ]
        then
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] begin decompress the package ${package_name}" > /tmp/decompress_package
            cd ${work_path}
            tar -xzvf ${package_name} > /dev/null 2>&1
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] end decompress the package ${package_name}" >> /tmp/decompress_package
        fi
    done

}

function preconfig_ip_single()
{
    if [ ! -f /opt/huawei/Bigdata/om-server/om/etc/om/controller.properties ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]controller.properties not exists,do not config."
        return 0
    fi
    sed -i 's/controller.Xmx=.*m/controller.Xmx=1024m/g' /opt/huawei/Bigdata/om-server/om/etc/om/controller.properties > /dev/null 2>&1
    su - omm -c "bash /opt/huawei/Bigdata/om-server/om/sbin/restart-controller.sh" > /dev/null 2>&1

}

function preconfig_switchover()
{
    echo "[`date '+%Y-%m-%d %H:%M:%S'`]the node FI01 is not master, begin switchover."
    switchover=0
    # Perform an active/standby switchover.
    for ((i=1;i<=3;i++))
    do
        su - omm -c "ssh $mainOms /opt/huawei/Bigdata/om-server/OMS/workspace/ha/module/hacom/tools/ha_client_tool --ip=127.0.0.1 --port=20013 --cancelforbidswitch --name=product" > /dev/null 2>&1
        su - omm -c "ssh $mainOms /opt/huawei/Bigdata/om-server/OMS/workspace/ha/module/hacom/tools/ha_client_tool --ip=127.0.0.1 --port=20013 --switchover --name=product" | grep "execute command switchover successfully." > /dev/null 2>&1
        if [ $? -eq 0 ]
        then
            switchover=1
            break
        fi
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]Failed : switchover failed, sleep 60s then try again. now count is $i."
        sleep 60
    done
    if [ $switchover -eq 0 ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]Failed : switchover failed."
        return 1
    fi
    # Wait for 180s and check whether the OMS status is normal.
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] run switchover successful, waiting 180s to check OmsStatus."
    for ((i=1;i<=12;i++))
    do
        sleep 15
        echo -n "."
    done
}
function preconfig_disablemain()
{
    echo "[`date '+%Y-%m-%d %H:%M:%S'`]Disable fi switch..."
    ha_tool=/opt/huawei/Bigdata/om-server/OMS/workspace0/ha/module/hacom/tools/ha_client_tool
    su - omm -c "ssh $mainOms /opt/huawei/Bigdata/om-server/OMS/workspace0/ha/module/hacom/script/query_fsw.sh" | grep "swap forbid cancel" > /dev/null
    if [ $? -ne 0 ]
    then
        # cancel first
        su - omm -c "ssh $mainOms $ha_tool --ip=127.0.0.1 --port=20013 --cancelforbidswitch --name=product" > /dev/null 2>&1
    fi
    # disable fi switch
    su - omm -c "ssh $mainOms $ha_tool --ip=127.0.0.1 --port=20013 --forbidswitch --name=product --time=150" > /dev/null 2>&1
    if [[ $? -ne 0 ]]; then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]Error: disable fi switch fail..."
        exit 1
    fi
}
function preconfig_disablebackup()
{
    echo "[`date '+%Y-%m-%d %H:%M:%S'`]Disable fi switch..."
    ha_tool=/opt/huawei/Bigdata/om-server/OMS/workspace0/ha/module/hacom/tools/ha_client_tool
    su - omm -c "ssh $backupOms /opt/huawei/Bigdata/om-server/OMS/workspace0/ha/module/hacom/script/query_fsw.sh" | grep "swap forbid cancel" > /dev/null
    if [ $? -ne 0 ]
    then
        # cancel first
        su - omm -c "ssh $backupOms $ha_tool --ip=127.0.0.1 --port=20013 --cancelforbidswitch --name=product" > /dev/null 2>&1
    fi
    # disable fi switch
    su - omm -c "ssh $backupOms $ha_tool --ip=127.0.0.1 --port=20013 --forbidswitch --name=product --time=150" > /dev/null 2>&1
    if [[ $? -ne 0 ]]; then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`]Error: disable fi switch fail..."
        exit 1
    fi
}


Main()
{

    config_name=$1
    mainOms=$2
    backupOms=$3
    if [ "x-$config_name" = "x-ssh" ]
        then
            preconfig_ssh
        elif [ "x-$config_name" = "x-ntp" ]
        then
            preconfig_ntp
        elif [ "x-$config_name" = "x-omm" ]
        then
            preconfig_omm
        elif [ "x-$config_name" = "x-python" ]
        then
            preconfig_python3
        elif [ "x-$config_name" = "x-switchover" ]
        then
            preconfig_switchover
        elif [ "x-$config_name" = "x-ntp_rollback" ]
        then
            preconfig_ntp_rollback
        elif [ "x-$config_name" = "x-acs" ]
        then
            preconfig_acs
            fixemail > /dev/null 2>&1
            fixweb > /dev/null 2>&1
            fixsudo > /dev/null 2>&1
            fixlog > /dev/null 2>&1
            fixcpuusage > /dev/null 2>&1
            fixodaelink > /dev/null 2>&1
            clear_packge
        elif [ "x-$config_name" = "x-fan" ]
        then
            preconfig_fan
        elif [ "x-$config_name" = "x-ipsingle" ]
        then
            preconfig_ip_single
        elif [ "x-$config_name" = "x-isupgradeos" ]
        then
            checkupgradeos
        elif [ "x-$config_name" = "x-iscleardata" ]
        then
            checkcleardata
        elif [ "x-$config_name" = "x-checkcluster" ]
        then
            checkclusterflag
        elif [ "x-$config_name" = "x-register" ]
        then
            preconfig_register
        elif [ "x-$config_name" = "x-preset" ]
        then
            checkupgradepreset
        elif [ "x-$config_name" = "x-checkoptsize" ]
        then
            check_optsize
        elif [ "x-$config_name" = "x-checktmpsize" ]
        then
            check_tmpsize
        elif [ "x-$config_name" = "x-clearflag" ]
        then
            clear_flag
        elif [ "x-$config_name" = "x-disablemain" ]
        then
            preconfig_disablemain
        elif [ "x-$config_name" = "x-disablebackup" ]
        then
            preconfig_disablebackup
        elif [ "x-$config_name" = "x-rollbackengr" ]
        then
            rollback_engr
        elif [ "x-$config_name" = "x-postclear" ]
        then
            check_postclear
        elif [ "x-$config_name" = "x-coredump" ]
        then
            post_coredump
        elif [ "x-$config_name" = "x-sudoexecute" ]
        then
            pre_sudoexecute
        elif [ "x-$config_name" = "x-decompress" ]
        then
            decompress_package
        elif [ "x-$config_name" = "x-checkagentpid" ]
        then
            checkagent_pid_num
        elif [ "x-$config_name" = "x-checksudo" ]
        then
            check_sudo
        elif [ "x-$config_name" = "x-checkruntime" ]
        then
            check_runtime
    fi

}

Main $*
