#!/bin/bash

declare -r work_path="/opt/fiupdate"
declare unlock_log=''
declare work_curPath=''
declare info_path="/opt/fiupdate/NCE_info"
declare ossadm_pwd=''
declare root_pwd=''
declare admin_pwd=''
declare whouser=''
declare mode=''

TMOUT=0
whouser=`whoami`
if [ "$whouser" != "root" ]
then
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] please run this script as user 'root' "
    exit 1
fi

read -s -p "please input ossadm password:" ossadm_pwd
echo -e "\n"

read -s -p "please input root password:" root_pwd
echo -e "\n"

read -s -p "please input FI admin password:" admin_pwd
echo -e "\n"

ossadm_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${ossadm_pwd}")
root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")

function get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    work_curPath="${PWD}"
    fi_scriptName="$(basename "${BASH_SOURCE-$0}")"
    cd - >/dev/null
}

logDef()
{
    local funcName="$1"; shift
    local logLevel="$1"; shift
    local lineNO="$1"; shift

    local logTime="$(date -d today +'%Y-%m-%d %H:%M:%S')"
    printf "[${logTime}] ${logLevel} $* [${g_scriptName}(${funcName}):${lineNO}]($$)\n" \
        >> "${unlock_log}" 2>&1
}

log_error()
{
    logDef "${FUNCNAME[1]}" "ERROR" "$@"
}

log_info()
{
    logDef "${FUNCNAME[1]}" "INFO" "$@"
}

function init_log()
{
    if [ ! -d "$work_path/log/" ]
    then
        mkdir "$work_path/log/"
    fi
    unlock_log="$work_path/log/unlock_safe.log"
    [ ! -f "${unlock_log}" ] && touch "${unlock_log}"
    chmod 600 "${unlock_log}"
    echo > ${unlock_log}
    
}

trap 'onCtrlC' INT
function onCtrlC () {
    echo 'exit program'
    exit 1
}

function output_info()
{
    cd /opt
    if [ -d ${info_path} ]
    then
        rm -fr ${info_path}
    fi
    mkdir ${info_path}
    if [ -d ${work_path}/NCE_info_tmp ]
    then
        cp -r ${work_path}/NCE_info_tmp/* ${info_path}
    fi
    chown -R ossadm:ossgroup ${work_path}
    if [ ! -f "/opt/oss/manager/tools/resmgr/queryproduct.sh" ]
    then
        if [ ! -f "/opt/fiupdate/NCE_info/nodes_NCE.ini" ] && [ ! -f "/opt/fiupdate/NCE_info/nodes_NCETENANT.ini" ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] platform queryproduct script not exists,please check"
            log_error "${LINENO}" "platform queryproduct script not exists,please check"
            return 1
        fi
    fi

    if [ ! -f "/opt/oss/manager/tools/resmgr/modifynodesinfo.sh" ]
    then
        if [ ! -f "/opt/fiupdate/NCE_info/nodes_NCE.ini" ] && [ ! -f "/opt/fiupdate/NCE_info/nodes_NCETENANT.ini" ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] platform modifynode script not exists,please check"
            log_error "${LINENO}" "platform modifynode script not exists,please check"
            return 1
        fi
    fi

    if [ ! -f "/opt/oss/manager/tools/resmgr/modifyproductinfo.sh" ]
    then
        if [ ! -f "/opt/fiupdate/NCE_info/nodes_NCE.ini" ] && [ ! -f "/opt/fiupdate/NCE_info/nodes_NCETENANT.ini" ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] platform modifyproduct script not exists,please check"
            log_error "${LINENO}" "platform modifyproduct script not exists,please check"
            return 1
        fi
    fi
    
    
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to output node and product information"
    log_info "${LINENO}" "Start to output node and product information"
    cd /opt/oss/manager/tools/resmgr/
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to modify node and product information"
    log_info "${LINENO}" "Start to modify node and product information"
    if [ ! -f "/opt/fiupdate/NCE_info/nodes_NCE.ini" ] && [ ! -f "/opt/fiupdate/NCE_info/nodes_NCETENANT.ini" ]
    then
        su - ossadm -c "cd /opt/oss/manager/tools/resmgr/ ; sh queryproduct.sh -pn all -output $info_path"
        if [ $? -ne 0 ] 
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] output node and product information failed"
            log_error "${LINENO}" "output node and product information failed"
            return 1
        fi
    fi
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] output node and product information success"
    log_info "${LINENO}" "output node and product information success"

    
    product_all=`find $info_path/ -name "node*.json" -type f`
    for i in ${product_all}
    do
    {
        product_one=$(basename $i .json|sed 's/nodes_//g')
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Start to check $product_one product"
        log_info "${LINENO}" "Start to check $product_one product"
        check=`cat $i|grep Analyzer_Calc`
        if [ -n "$check" ]
        then
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_one have Analyzer_Calc agent,need to update fi"
            log_info "${LINENO}" "$product_one have Analyzer_Calc agent,need to update fi"
            if [ -f /opt/fiupdate/NCE_info/nodes_${product_one}.ini ]
            then
                fi_access_ip=`cat /opt/fiupdate/NCE_info/nodes_${product_one}.ini |grep fiweb|sed 's/fiweb=//g'`
            else
                get_info $product_one
                if [ $? -ne 0 ]
                then
                    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[41;37m ${product_one} get FI node infomation failed \033[0m"
                    log_error "${LINENO}" "${product_one} get FI node infomation  "
                    return 1
                fi
                mainOms=`cat /opt/fiupdate/NCE_info/nodes_${product_one}.ini |grep mainOms= |sed 's/mainOms=//g'`
                backupOms=`cat /opt/fiupdate/NCE_info/nodes_${product_one}.ini |grep backupOms= |sed 's/backupOms=//g'`
                fi_01=`cat /opt/fiupdate/NCE_info/nodes_${product_one}.ini |grep Analyzer_Calc_Storage_01= |sed 's/Analyzer_Calc_Storage_01=//g'`
	            if [[ "$mainOms" = "$fi_01" ]]; then
                    if [ -n "$backupOms" ]; then
                        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] the main oms is FI01."
                        log_info "${LINENO}" "\n[`date '+%Y-%m-%d %H:%M:%S'`] the main oms is FI01."
                        disable_main $mainOms $fi_01 $backupOms
                    fi
	            else
                    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] the node FI01 is not master, begin switchover."
                    log_info "${LINENO}" "\n[`date '+%Y-%m-%d %H:%M:%S'`] the node FI01 is not master, begin switchover."
                    disable_backup $mainOms $fi_01 $backupOms
                    get_info $product_one
                    if [ $? -ne 0 ]
                    then
                        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] ${product_one} get FI node infomation failed, sleep 180 and try again..."
                        log_error "${LINENO}" "${product_one} get FI node infomation failed, sleep 180 and try again..."
                        for ((i=1;i<=12;i++))
                        do
                            sleep 15
                            echo -n "."
                        done
                        get_info $product_one
                        if [ $? -ne 0 ]
                        then
                            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[41;37m ${product_one} get FI node infomation failed \033[0m"
                            log_error "${LINENO}" "${product_one} get FI node infomation  "
                            return 1
                        fi
                    fi
	            fi
            fi
            unlockDao $product_one
        else
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_one not have Analyzer_Calc_Storage agent, not need to update fi"
            log_info "${LINENO}" "$product_one not have Analyzer_Calc_Storage agent, not need to update fi"
        fi
    }
    done
}

function disable_backup()
{
    mainOms=$1
    fi_01=$2
    backupOms=$3
    expect <<END
                spawn scp -p /opt/fiupdate/pre_config.sh ossadm@${fi_01}:/tmp
                expect {
                "*yes/no*" {send "yes\r";exp_continue}
                "assword:" {send "$ossadm_pwd\r"}
                }
                set timeout 600
                expect eof
END

    expect <<END
            spawn ssh -t ossadm@${fi_01} "su - root -c 'cd /tmp/ ; bash pre_config.sh switchover ${mainOms} ${backupOms}'"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$ossadm_pwd\r"}
            }
            expect "*assword:"
            send "$root_pwd\r"

            set timeout 1200
            expect eof
END

    expect <<END
            spawn ssh -t ossadm@${fi_01} "su - root -c 'cd /tmp/ ; bash pre_config.sh disablebackup ${mainOms} ${backupOms} ; rm -rf /tmp/pre_config.sh'"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$ossadm_pwd\r"}
            }
            expect "*assword:"
            send "$root_pwd\r"

            set timeout 1200
            expect eof
END

}
function disable_main()
{
    mainOms=$1
    fi_01=$2
    backupOms=$3
    expect <<END
                spawn scp -p /opt/fiupdate/pre_config.sh ossadm@${fi_01}:/tmp
                expect {
                "*yes/no*" {send "yes\r";exp_continue}
                "assword:" {send "$ossadm_pwd\r"}
                }
                set timeout 600
                expect eof
END

    expect <<END
            spawn ssh -t ossadm@${fi_01} "su - root -c 'cd /tmp/ ; bash pre_config.sh disablemain ${mainOms} ${backupOms} ; rm -rf /tmp/pre_config.sh'"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$ossadm_pwd\r"}
            }
            expect "*assword:"
            send "$root_pwd\r"

            set timeout 1200
            expect eof
END

}

function get_info()
{
    product_name=$1
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] start to analyzer $product_name : node and product information "
    log_info "${LINENO}" "start to analyzer $product_name : node and product information"
    cd ${work_path}/py_work
    if [ -f ${work_path}/py_work/get_node.py ]
    then
        run_script=${work_path}/py_work/get_node.py
    else
        run_script=${work_path}/py_work/get_node.pyc
    fi
    su - ossadm -c "${pyCmd} $run_script $product_name"
    if [ $? -ne 0 ] 
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] get $product_name : node and product information failed"
        log_error "${LINENO}" "output node and product information failed"
        return 1
    fi
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] output $product_name : node and product information success"
    log_info "${LINENO}" "output $product_name : node and product information success"
    
    if [ ! -f "/opt/fiupdate/NCE_info/nodes_${product_name}.ini" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name : FI nodes config file not exists,please check"
        log_error "${LINENO}" "$product_name : platform nodelist json not exists,please check"
        return 1
    fi
    
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name : start to get all FI nodes information"
    log_info "${LINENO}" "$product_name : start to get all FI nodes information"
    if [ -f "/opt/fiupdate/log/get_${product_name}_FInodes.log" ]
    then
        rm -f /opt/fiupdate/log/get_${product_name}_FInodes.log
    fi
    fi_access_ip=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep fiweb|sed 's/fiweb=//g'`

    
    cd ${work_path}/py_work
    expect <<END
                spawn su - ossadm -c "${pyCmd} ${work_path}/py_work/GetHost.pyc $fi_access_ip $product_name"
                expect {
                "*assword:" {send "$admin_pwd\r"}
    }
                set timeout 1200
                expect eof
END

    

    if [ ! -f "/opt/fiupdate/log/get_${product_name}_FInodes.log" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name : get all FI nodes information failed"
        log_error "${LINENO}" "get $product_name : all FI nodes information failed"
        return 1
    fi

    runresult=`cat /opt/fiupdate/log/get_${product_name}_FInodes.log | grep 'GETHOST RUN SUCCESS'`
    if [ ! -n "$runresult" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] get $product_name : all FI nodes information failed"
        log_error "${LINENO}" "get $product_name : all FI nodes information failed"
        return 1
    fi
    
    echo "syscheck=" >> "/opt/fiupdate/NCE_info/nodes_${product_name}.ini"
    echo "prework="  >> "/opt/fiupdate/NCE_info/nodes_${product_name}.ini"
    echo "updcluster="   >> "/opt/fiupdate/NCE_info/nodes_${product_name}.ini"
    echo "confirm="  >> "/opt/fiupdate/NCE_info/nodes_${product_name}.ini"
    echo "postwork=" >> "/opt/fiupdate/NCE_info/nodes_${product_name}.ini"
    echo "rollback=" >> "/opt/fiupdate/NCE_info/nodes_${product_name}.ini"
    
    mkdir -p /opt/fiupdate/NCE_info_tmp
    cp -f /opt/fiupdate/NCE_info/* /opt/fiupdate/NCE_info_tmp

    chown -R ossadm:ossgroup /opt/fiupdate/NCE_info_tmp

    return 0
        
}

function copy_ca()
{
    mainomsip=$1
	singleip=$2
	mkdir -p /tmp/NCE/ODAEConfigMgrService/fi/ca/conf
    expect <<END
            set timeout 15
            spawn scp root@${mainomsip}:/opt/huawei/Bigdata/om-server/om/security/cert/root/ca.crt  /tmp/NCE/ODAEConfigMgrService/fi/ca/conf
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "*assword:" {send "$root_pwd\r"}
}
            set timeout 15
            expect eof
END
    expect <<END
            set timeout 15
            spawn ssh root@${singleip} "mkdir -p /opt/oss/tmp/NCE/ODAEConfigMgrService/fi/ca/conf"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "*assword:" {send "$root_pwd\r"}
}
            set timeout 15
            expect eof
END
    expect <<END
            set timeout 15
            spawn scp /tmp/NCE/ODAEConfigMgrService/fi/ca/conf/ca.crt  root@${singleip}:/opt/oss/tmp/NCE/ODAEConfigMgrService/fi/ca/conf
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "*assword:" {send "$root_pwd\r"}
}
            set timeout 15
            expect eof
END
    expect <<END
            set timeout 15
            spawn ssh root@${singleip} "chown -R ossuser:ossgroup /opt/oss/tmp/NCE/ODAEConfigMgrService"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "*assword:" {send "$root_pwd\r"}
}
            set timeout 15
            expect eof
END

    rm -rf /tmp/NCE/ODAEConfigMgrService/fi/ca/conf > /dev/null 2>&1
}

function unlockDao()
{
    product_name=$1
    if [ ! -f "/opt/fiupdate/NCE_info/nodes_${product_name}.ini" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name : FI nodes config file not exists,please check"
        log_error "${LINENO}" "$product_name : platform nodelist json not exists,please check"
        return 1
    fi
    
    mode=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep mode= |sed 's/mode=//g'`
    
    if [ "$mode" == "single" ]
    then
        mainOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep mainOms= |sed 's/mainOms=//g'`
        configSudoers ${mainOms}
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name : start to unlock safe in FI mainOms node:${mainOms}"
        log_info "${LINENO}" "$product_name : start to unlock safe in FI mainOms node:${mainOms}"
        nodeDao ${mainOms}
        backupOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep SINGLE_ODAE_NODE | awk -F'=' '{print $2}'`
        configSudoers ${backupOms}
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] start to unlock safe in FI SINGLE_ODAE_NODE:${backupOms}"
        log_info "${LINENO}" "start to unlock safe in FI SINGLE_ODAE_NODE:${backupOms}"
        nodeDao ${backupOms}
		sleep 5
        checkODAEConfigMgrService > $work_path/log/ODAEConfigMgrService
        singlenode=`cat $work_path/log/ODAEConfigMgrService | grep -i ODAEConfigMgrService | grep -v ssh | awk '{print $6}'`
        copy_ca ${mainOms} ${singlenode}
    fi
    
    if [ "$mode" == "double" ]
    then
    
        nodes_info=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep finode= |sed 's/finode=//g'`
        mainOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep mainOms= |sed 's/mainOms=//g'`
        backupOms=`cat /opt/fiupdate/NCE_info/nodes_${product_name}.ini |grep backupOms= |sed 's/backupOms=//g'`
        
        configSudoers ${mainOms}
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name : start to unlock safe in FI mainOms node:${mainOms}"
        log_info "${LINENO}" "$product_name : start to unlock safe in FI mainOms node:${mainOms}"
        nodeDao ${mainOms}
        
        configSudoers ${backupOms}
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name : start to unlock safe in FI backupOms node:${backupOms}"
        log_info "${LINENO}" "$product_name : start to unlock safe in FI backupOms node:${backupOms}"
        nodeDao ${backupOms}
        
        for nodeip in ${nodes_info}
        do
        {
            configSudoers ${nodeip}
            echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] $product_name : start to unlock safe in node:${nodeip}"
            log_info "${LINENO}" "$product_name : start to unlock safe in node:${nodeip}"
            nodeDao ${nodeip}
        }
        done
    fi

}

function checkODAEConfigMgrService()
{
    expect <<END
                spawn ssh -t ossadm@${mainOms} "bash /opt/oss/manager/agent/bin/engr_profile.sh;bash /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -app ODAEConfigMgrService -nodeip global |grep -i ODAEConfigMgrService"
                expect {
                "*yes/no*" {send "yes\r";exp_continue}
                "assword:" {send "$ossadm_pwd\r"}
                }
                set timeout 300
                expect eof
END

}

function nodeDao()
{
    nodeip=$1
    expect <<END
            spawn ssh -t ossadm@${nodeip} "su - root -c 'cd /opt/SEK/cmd;sh SetEnv.sh'"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$ossadm_pwd\r"}
            }
            expect "*assword:"
            send "$root_pwd\r"
            set timeout 600
            expect eof
END
}

function configOmm()
{
    fi_node=$1
    expect <<END
            spawn ssh -t ossadm@${fi_node} "su - root -c 'grep \"^AllowUsers omm\" /etc/ssh/sshd_config'"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$ossadm_pwd\r"}
            }
            expect "*assword:"
            send "$root_pwd\r"
            expect {
                "AllowUsers omm" {send_user "do not need config omm in FI node:${fi_node}.\n"
                    exit 2}
            }
            set timeout 600
            expect eof
END

    if [ $? -eq 2 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] do not need config omm in FI node:${fi_node}."
    else
        expect <<END
                spawn scp -p /opt/fiupdate/pre_config.sh ossadm@${fi_node}:/tmp
                expect {
                "*yes/no*" {send "yes\r";exp_continue}
                "assword:" {send "$ossadm_pwd\r"}
                }
                set timeout 600
                expect eof
END

        expect <<END
                spawn ssh -t ossadm@${fi_node} "su - root -c 'cd /tmp/ ; bash pre_config.sh omm ; rm -rf /tmp/pre_config.sh'"
                expect {
                "*yes/no*" {send "yes\r";exp_continue}
                "assword:" {send "$ossadm_pwd\r"}
                }
                expect "*assword:"
                send "$root_pwd\r"
                set timeout 600
                expect eof
END

    fi
}

function configSudoers()
{
    fi_node=$1
    expect <<END
            spawn ssh -t ossadm@${fi_node} "su - root -c 'grep \"^ossadm ALL=(root) /bin/bash\" /etc/sudoers'"
            expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "assword:" {send "$ossadm_pwd\r"}
            }
            expect "*assword:"
            send "$root_pwd\r"
            expect {
                "ossadm ALL*" {send_user "do not need config bash in sudoers FI node:${fi_node}.\n"
                    exit 2}
            }
            set timeout 600
            expect eof
END

    if [ $? -eq 2 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] do not need config bash in sudoers FI node:${fi_node}."
    else
        expect <<END
                spawn ssh -t ossadm@${fi_node} "su - root -c 'echo \"ossadm ALL=(root) /bin/bash\" >> /etc/sudoers'"
                expect {
                "*yes/no*" {send "yes\r";exp_continue}
                "assword:" {send "$ossadm_pwd\r"}
                }
                expect "*assword:"
                send "$root_pwd\r"
                set timeout 600
                expect eof
END
    fi
}

function unset_parameter()
{
    unset admin_pwd
    unset ossadm_pwd
    unset root_pwd

}

function set_timeout()
{
    if [ -f "/etc/bashrc" ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] start to check sys tmout"
        log_info "${LINENO}" "start to check sys tmout"
        tmresult=`cat /etc/bashrc|grep TMOUT`
        if [ ! -n "$tmresult" ]
        then
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout not need to change"
            log_info "${LINENO}" "sys tmout not need to change"
            return 0
        fi
        cat /etc/bashrc |grep TMOUT |while read tmout_sys
        do
            if [ ! -n "$tmout_sys" ]
            then
                echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout not need to change"
                log_info "${LINENO}" "sys tmout not need to change"
            else
                echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout need to change" 
                log_info "${LINENO}" "sys tmout need to change"
                if [[ "$tmout_sys" =~ "export" ]]
                then
                    sed -i "s/$tmout_sys/export TMOUT=0/g" /etc/bashrc
                    source /etc/bashrc
                    echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout change success,is to set $TMOUT" 
                    log_info "${LINENO}" "sys tmout change success,is to set $TMOUT"
                else
                    sed -i "s/$tmout_sys/TMOUT=0/g" /etc/bashrc
                    source /etc/bashrc
                    echo "[`date '+%Y-%m-%d %H:%M:%S'`] sys tmout change success,is to set $TMOUT" 
                    log_info "${LINENO}" "sys tmout change success,is to set $TMOUT"
                fi
            fi
        done
    fi
    service sshd restart
    
    return 0 

}

function Main()
{
    log_info "${LINENO}" "start to unlock all FI nodes"
    log_info "${LINENO}" "start to output product info"
    set_timeout
    rm -rf ${work_path}/ODAESwiftDeployPlugin >/dev/null 2>&1
    ODAEpluginfile=`find ${work_path}/package/ -name "ODAESwiftDeployPlugin*.zip" -type f`
    unzip ${ODAEpluginfile} -d ${work_path}/ODAESwiftDeployPlugin >/dev/null 2>&1
    bash ${work_path}/ODAESwiftDeployPlugin/ODAEDeployTool/lbin/env_profile.sh ${work_path}/ODAESwiftDeployPlugin/ODAEDeployTool >/dev/null 2>&1
    chmod -R 500 ${work_path}/ODAESwiftDeployPlugin/ODAEDeployTool/rtsp/python/bin >/dev/null 2>&1
    chown -R ossadm:ossgroup ${work_path}/ODAESwiftDeployPlugin >/dev/null 2>&1
    pyCmd=${work_path}/ODAESwiftDeployPlugin/ODAEDeployTool/rtsp/python/bin/python
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] start to safeunlock self"
    log_info "${LINENO}" "start to safeunlock self"
    if [ ! -f "/opt/SEK/cmd/SetEnv.sh" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[41;37m safeunlock script (SetEnv.sh) is not exists \033[0m"
        log_error "${LINENO}" "safeunlock script (SetEnv.sh) is not exists"
        return 1
    fi
    cd /opt/SEK/cmd;sh SetEnv.sh
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[41;37m safeunlock self node failed \033[0m"
        log_error "${LINENO}" "safeunlock self node failed"
        return 1
    fi
    
    output_info
    if [ $? -ne 0 ] 
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] script in stage output information failed"
        log_error "${LINENO}" "script in stage output information failed"
        return 1
    fi
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] script in stage output information success"
    log_info "${LINENO}" "script in stage output information success"
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] script in stage unlock all FI nodes success"
    log_info "${LINENO}" "script in stage unlock all FI nodes success"
    return 0
}


get_cur_path
cd "${work_curPath}"

init_log || return $?

Main

main_result=$?

unset_parameter

exit $main_result
