#! /bin/bash

retryupdatetask=$1

read -s -p "please input update password:" admin_pwd
echo -e "\n"
admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")

fiUPLog=/tmp/fiupdate/fi_retry_update.log
mkdir -p /tmp/fiupdate
touch $fiUPLog
chown -R ossadm:ossgroup /tmp/fiupdate

function get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    work_curPath="${PWD}"
    fi_scriptName="$(basename "${BASH_SOURCE-$0}")"
    cd - >/dev/null
}

get_cur_path
cd "${work_curPath}"

RetryUpdate()
{
    if [ "x-$retryupdatetask" = "x-precheck" ];then
        py=${work_curPath}/../py_work/retryfiupdate_precheck.pyc
        if [ -f ${work_curPath}/../py_work/retryfiupdate_precheck.py ]
        then
            py=${work_curPath}/../py_work/retryfiupdate_precheck.py
        fi
        run_task=Precheck
        fiUPLog=/tmp/fiupdate/retryfiupdate_precheck.log
        touch $fiUPLog
    elif [ "x-$retryupdatetask" = "x-distribute" ];then
        py=${work_curPath}/../py_work/retryfiupdate_distribute.pyc
        if [ -f ${work_curPath}/../py_work/retryfiupdate_distribute.py ]
        then
            py=${work_curPath}/../py_work/retryfiupdate_distribute.py
        fi
        run_task=Distribute
        fiUPLog=/tmp/fiupdate/retryfiupdate_distribute.log
        touch $fiUPLog
    elif [ "x-$retryupdatetask" = "x-updatemanager" ];then
        py=${work_curPath}/../py_work/retryfiupdate_updatemanager.pyc
        if [ -f ${work_curPath}/../py_work/retryfiupdate_updatemanager.py ]
        then
            py=${work_curPath}/../py_work/retryfiupdate_updatemanager.py
        fi
        run_task=UpdateManager
        fiUPLog=/tmp/fiupdate/retryfiupdate_updatemanager.log
        touch $fiUPLog
    elif [ "x-$retryupdatetask" = "x-updateprepare" ];then
        py=${work_curPath}/../py_work/retryfiupdate_updateprepare.pyc
        if [ -f ${work_curPath}/../py_work/retryfiupdate_updateprepare.py ]
        then
            py=${work_curPath}/../py_work/retryfiupdate_updateprepare.py
        fi
        run_task=UpdatePrepare
        fiUPLog=/tmp/fiupdate/retryfiupdate_updateprepare.log
        touch $fiUPLog
    elif [ "x-$retryupdatetask" = "x-updateservice" ];then
        py=${work_curPath}/../py_work/retryfiupdate_updateservice.pyc
        if [ -f ${work_curPath}/../py_work/retryfiupdate_updateservice.py ]
        then
            py=${work_curPath}/../py_work/retryfiupdate_updateservice.py
        fi
        run_task=UpdateService
        fiUPLog=/tmp/fiupdate/retryfiupdate_updateservice.log
        touch $fiUPLog
    elif [ "x-$retryupdatetask" = "x-restartaffected" ];then
        py=${work_curPath}/../py_work/retryfiupdate_restartaffected.pyc
        if [ -f ${work_curPath}/../py_work/retryfiupdate_restartaffected.py ]
        then
            py=${work_curPath}/../py_work/retryfiupdate_restartaffected.py
        fi
        run_task=RestartAffected
        fiUPLog=/tmp/fiupdate/retryfiupdate_restartaffected.log
        touch $fiUPLog
    fi
    chown -R ossadm:ossgroup /tmp/fiupdate
    pyCmd=/opt/fiupdate/ODAESwiftDeployPlugin/ODAEDeployTool/rtsp/python/bin/python
    expect <<END
        set timeout -1
        spawn ${pyCmd} ${py}
        expect {
            "*assword*" {send "$admin_pwd\r"}
        }
        expect eof
END
    
    firesult=`tail $fiUPLog`
    if [[ $firesult =~ "FI ${run_task} success" ]]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] ${UpdateIp} FI ${run_task} success" >> $fiUPLog
        return 0
    else
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] ${UpdateIp} FI ${run_task} failed" >> $fiUPLog
        return 1
    fi
}

Main()
{
    RetryUpdate >> $fiUPLog
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI ${run_task} failed" >> $fiUPLog
        return 1
    fi
    return 0
}

Main $*
exit $?

