#! /bin/bash

updatetask=$1
UpdateIp=$2

read -s -p "please input update password:" ossadm_pwd root_pwd admin_pwd
echo -e "\n"
ossadm_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${ossadm_pwd}")
root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")

if [ -f /tmp/fiupdate/fiupdate.log ]
then
    mv /tmp/fiupdate/fiupdate.log /tmp/fiupdate/fiupdate_old.log > /dev/null 2>&1
fi
fiUPLog=/tmp/fiupdate/fiupdate.log
mkdir -p /tmp/fiupdate
touch $fiUPLog
chown -R ossadm:ossgroup /tmp/fiupdate
SysVerInfo=`cat /etc/os-release`
if [[ "$SysVerInfo" =~ "SLES" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is SUSE" >> $fiUPLog
    SysVer="SUSE"
elif [[ "$SysVerInfo" =~ "EulerOS" ]]; then
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is EulerOS" >> $fiUPLog
    SysVer="EulerOS"
else
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] system is not SUSE,is not EulerOS" >> $fiUPLog
    echo "[`date '+%Y-%m-%d %H:%M:%S'`] FI cannot install" >> $fiUPLog
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI update failed" >> $fiUPLog
    exit 1
fi

cpu=`uname -a`
if [[ "$cpu" =~ "aarch64" ]]; then
    cpu="ARM"
else
    cpu="x86"
fi

function get_cur_path()
{
    cd "$(dirname "${BASH_SOURCE-$0}")"
    work_curPath="${PWD}"
    fi_scriptName="$(basename "${BASH_SOURCE-$0}")"
    cd - >/dev/null
}

get_cur_path
cd "${work_curPath}"

update()
{

    if [ "x-$updatetask" = "x-prepare" ];then
        py=${work_curPath}/../py_work/fiupdate_prepare.pyc
        if [ -f ${work_curPath}/../py_work/fiupdate_prepare.py ]
        then
            py=${work_curPath}/../py_work/fiupdate_prepare.py
        fi
        run_task=CreateProject
        fiUPLog=/tmp/fiupdate/fiupdate_prepare.log
        touch $fiUPLog
    elif [ "x-$updatetask" = "x-precheck" ];then
        py=${work_curPath}/../py_work/fiupdate_precheck.pyc
        if [ -f ${work_curPath}/../py_work/fiupdate_precheck.py ]
        then
            py=${work_curPath}/../py_work/fiupdate_precheck.py
        fi
        run_task=Precheck
        fiUPLog=/tmp/fiupdate/fiupdate_precheck.log
        touch $fiUPLog
    elif [ "x-$updatetask" = "x-distribute" ];then
        py=${work_curPath}/../py_work/fiupdate_distribute.pyc
        if [ -f ${work_curPath}/../py_work/fiupdate_distribute.py ]
        then
            py=${work_curPath}/../py_work/fiupdate_distribute.py
        fi
        run_task=Distribute
        fiUPLog=/tmp/fiupdate/fiupdate_distribute.log
        touch $fiUPLog
    elif [ "x-$updatetask" = "x-updatemanager" ];then
        py=${work_curPath}/../py_work/fiupdate_updatemanager.pyc
        if [ -f ${work_curPath}/../py_work/fiupdate_updatemanager.py ]
        then
            py=${work_curPath}/../py_work/fiupdate_updatemanager.py
        fi
        run_task=UpdateManager
        fiUPLog=/tmp/fiupdate/fiupdate_updatemanager.log
        touch $fiUPLog
    elif [ "x-$updatetask" = "x-updateprepare" ];then
        py=${work_curPath}/../py_work/fiupdate_updateprepare.pyc
        if [ -f ${work_curPath}/../py_work/fiupdate_updateprepare.py ]
        then
            py=${work_curPath}/../py_work/fiupdate_updateprepare.py
        fi
        run_task=UpdatePrepare
        fiUPLog=/tmp/fiupdate/fiupdate_updateprepare.log
        touch $fiUPLog
    elif [ "x-$updatetask" = "x-updateservice" ];then
        py=${work_curPath}/../py_work/fiupdate_updateservice.pyc
        if [ -f ${work_curPath}/../py_work/fiupdate_updateservice.py ]
        then
            py=${work_curPath}/../py_work/fiupdate_updateservice.py
        fi
        run_task=UpdateService
        fiUPLog=/tmp/fiupdate/fiupdate_updateservice.log
        touch $fiUPLog
    elif [ "x-$updatetask" = "x-restartaffected" ];then
        py=${work_curPath}/../py_work/fiupdate_restartaffected.pyc
        if [ -f ${work_curPath}/../py_work/fiupdate_restartaffected.py ]
        then
            py=${work_curPath}/../py_work/fiupdate_restartaffected.py
        fi
        run_task=RestartAffected
        fiUPLog=/tmp/fiupdate/fiupdate_restartaffected.log
        touch $fiUPLog
    fi
    chown -R ossadm:ossgroup /tmp/fiupdate
    pyCmd=/opt/fiupdate/ODAESwiftDeployPlugin/ODAEDeployTool/rtsp/python/bin/python
    if [ "x${admin_pwd}" == "x" ]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] The password obtained is empty in shell, please check." >> $fiUPLog
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] ${UpdateIp} FI ${run_task} failed, maybe password is empty." >> $fiUPLog
        return 1
    fi

    expect <<END
        set timeout -1
        spawn ${pyCmd} ${py} $UpdateIp "${SysVer}" "$cpu"
        expect {
            "*assword:" {send "$ossadm_pwd\r"}
        }
        expect {
            "*assword:" {send "$root_pwd\r"}
        }
        expect {
            "*assword:" {send "$admin_pwd\r"}
        }
        expect eof
END
    
    firesult=`tail $fiUPLog`
    if [[ $firesult =~ "FI ${run_task} success" ]]
    then
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] ${UpdateIp} FI ${run_task} success " >> $fiUPLog
        return 0
    elif [[ $firesult =~ "stage start:UpdateManager" ]]
    then
        retryupdate ${UpdateIp}
        if [ $? -eq 0 ]
        then
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] ${UpdateIp} FI ${run_task} success " >> $fiUPLog
            return 0
        else
            echo "[`date '+%Y-%m-%d %H:%M:%S'`] ${UpdateIp} FI ${run_task} failed " >> $fiUPLog
            return 1
        fi
    else
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] ${UpdateIp} FI ${run_task} failed " >> $fiUPLog
        return 1
    fi
}
retryupdate()
{
    UpdateIp=$1
    UpdateManager=/opt/huawei/Bigdata/update-service/data/*/result/UpdateManager
    isINIT=`grep "NODE_STATE_INIT" $UpdateManager/*`
    isFAIL=`grep "NODE_STATE_FAIL" $UpdateManager/*`
    SUCCnum=`grep "NODE_STATE_SUCC" $UpdateManager/* | awk {'print $1'} | sort -u | wc -l`
    if [ ! -n "$isFAIL" ]
    then
        for ((j=1;j<=720;j++))
        do
            if [ $SUCCnum -ne 18 ]
            then
                echo "[`date '+%Y-%m-%d %H:%M:%S'`]---INFO: FI update start check project stage start:UpdateManager" >> $fiUPLog
                sleep 5
                SUCCnum=`grep "NODE_STATE_SUCC" $UpdateManager/* | awk {'print $1'} | sort -u | wc -l`
            else
                echo "[`date '+%Y-%m-%d %H:%M:%S'`] doretryupdate FI ${run_task} success " >> $fiUPLog
                return 0
            fi
        done
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] doretryupdate FI ${run_task} timeout " >> $fiUPLog
        return 1
    else
        echo "[`date '+%Y-%m-%d %H:%M:%S'`] retryupdate FI ${run_task} failed " >> $fiUPLog
        return 1
    fi
}

Main()
{
    update
    if [ $? -ne 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] FI ${run_task} failed" >> $fiUPLog
        return 1
    fi
    return 0
}

Main $*
exit $?

