#! /bin/bash

GetWorkPath()
{
    dir=`/usr/bin/dirname $0`
    ispoint=`/bin/echo $dir| /usr/bin/awk -F/ '{print $1}'`
    if [ "$ispoint" = "." ]
    then
        dir=`/bin/echo $dir|/usr/bin/sed 's/^.//'`
        curpath="`pwd`$dir"
    elif [ "$ispoint" = ".." ]
    then
        curpath="`pwd`/$dir"
    else
       curpath="$dir"
    fi
    return 0
}

######################################################################
#   FUNCTION   : is_ip_address
#   DESCRIPTION:ַǷһϷipַ
#   INPUT      : $1: ipַ
#   OUTPUT     : 
#   LOCAL VAR  : 
#   USE GLOBVAR: 
#   RETURN     : 
######################################################################
is_ip_address()
{
    local TmpValue="$1"
    local nCount=""
    local i=0
    
    nCount=`echo "$TmpValue" | grep -c '^[1-9][0-9]\{0,2\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}$'`
    if [ 1 -eq $nCount ]
    then
        TmpValue="`echo $TmpValue | sed 's/\./ /g'`"
        for i in $TmpValue
        do
        if [ "$i" -gt 255 ]
        then
              return 1
        fi
        done
        return 0
    else
        return 1
    fi
}


Setconfini()
{   
    read -p "please input Analyzer_Calc_Storage eth0 web:" webip
    #check ip
    ret=`is_ip_address $webip`
    if [ $? -ne 0 ]
    then
        echo "The input node  IP format error: "$webip
        return 1
    fi
    
    read -p "please input eth0 web netmask:" webnetmask
    #check netmask
    ifconfig -a | grep -w $webnetmask | grep -v grep > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
        echo "Incorrect netmask. Enter the Netmask of the local computer."
        return 1
    fi
    
    read -p "please input common service eth0:" cseth0
    #check ip
    ifconfig -a | grep -w $cseth0 | grep -v grep > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
        echo "Incorrect IP address. Enter the eth0 IP address of the local computer."
        return 1
    fi
    ret=`is_ip_address $cseth0`
    if [ $? -ne 0 ]
    then
        echo "The input node  IP format error: "$cseth0
        return 1
    fi
    
    
    read -p "please input common service eth3:" cseth3
    #check ip
    ifconfig -a | grep -w $cseth3 | grep -v grep > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
        echo "Incorrect IP address. Enter the eth3 IP address of the local computer."
        return 1
    fi
    ret=`is_ip_address $cseth3`
    if [ $? -ne 0 ]
    then
        echo "The input node  IP format error: "$cseth3
        return 1
    fi
    
    perl -i -lpe "s~Analyzer_Calc_Storage_01_eth0_WEB_FLOAT_IP=.*~Analyzer_Calc_Storage_01_eth0_WEB_FLOAT_IP=${webip}~g" ${curpath}/config.ini
    perl -i -lpe "s~Common_Service_01_eth0_IP=.*~Common_Service_01_eth0_IP=${cseth0}~g" ${curpath}/config.ini
    perl -i -lpe "s~Common_Service_01_eth3_IP=.*~Common_Service_01_eth3_IP=${cseth3}~g" ${curpath}/config.ini
    perl -i -lpe "s~Analyzer_Calc_Storage_01_eth0_WEB_NetMask=.*~Analyzer_Calc_Storage_01_eth0_WEB_NetMask=${webnetmask}~g" ${curpath}/config.ini
    
}

Doiptables()
{
    echo 1 >/proc/sys/net/ipv4/ip_forward
    perl -i -lpe "s~net.ipv4.ip_forward=.*~net.ipv4.ip_forward=1~g" /etc/sysctl.conf
    sysctl -p /etc/sysctl.conf > /dev/null 2>&1
    
    file=${curpath}/config.ini
    eth0_web_ip=`cat ${file} | grep Analyzer_Calc_Storage_01_eth0_WEB_FLOAT_IP | awk -F= '{print $2}'`
    cs01_eth0_ip=`cat ${file} | grep Common_Service_01_eth0_IP | awk -F= '{print $2}'`
    cs01_eth3_ip=`cat ${file} | grep Common_Service_01_eth3_IP | awk -F= '{print $2}'`
    
    if [ "x${eth0_web_ip}" = "x" -o "x${cs01_eth0_ip}" = "x" -o "x${cs01_eth3_ip}" = "x" ];then
        echo "Error some ip is null:eth0_web_ip=${eth0_web_ip},cs01_eth0_ip=${cs01_eth0_ip},cs01_eth3_ip=${cs01_eth3_ip}."
        return 1
    else
        iptables -t nat -L -n > /tmp/recording
        chmod 400 /tmp/recording
        
        #
        iptables -t nat -F
        
        iptables -t nat -A PREROUTING -d ${cs01_eth3_ip} -p tcp --dport 28443 -jDNAT --to-dest ${eth0_web_ip}:28443
        iptables -t nat -A POSTROUTING -d ${eth0_web_ip} -p tcp --dport 28443 -jSNAT --to-source ${cs01_eth0_ip}
        
        iptables -t nat -A PREROUTING -d ${cs01_eth3_ip} -p tcp --dport 20009 -jDNAT --to-dest ${eth0_web_ip}:20009
        iptables -t nat -A POSTROUTING -d ${eth0_web_ip} -p tcp --dport 20009 -jSNAT --to-source ${cs01_eth0_ip}
        
        iptables -t nat -A PREROUTING -d ${cs01_eth3_ip} -p tcp --dport 20026 -jDNAT --to-dest ${eth0_web_ip}:20026
        iptables -t nat -A POSTROUTING -d ${eth0_web_ip} -p tcp --dport 20026 -jSNAT --to-source ${cs01_eth0_ip}
        
        iptables -t nat -A PREROUTING -d ${cs01_eth3_ip} -p tcp --dport 20044 -jDNAT --to-dest ${eth0_web_ip}:20044
        iptables -t nat -A POSTROUTING -d ${eth0_web_ip} -p tcp --dport 20044 -jSNAT --to-source ${cs01_eth0_ip}
        
        # save in /etc/sysconfig/iptables
        service iptables save
        return 0
    fi
}



Main(){
    GetWorkPath
    
    Setconfini
    
    Doiptables
    if [ $? -ne 0 ];then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] iptables set nat failed."
        return 1
    fi
    
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] iptables set nat success."
    return 0
}

Main $*
exit $?
