#! /bin/bash


echo -n "es_input: os_pwd_root"
read -s os_pwd_root

echo ""

echo -n "es_input: os_pwd_ossadm"
read -s os_pwd_ossadm

echo ""

echo -n "es_input: fi_pwd_admin"
read -s fi_pwd_admin

GetWorkPath()
{
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Precheck work is start."
    dir=`/usr/bin/dirname $0`
    ispoint=`/bin/echo $dir| /usr/bin/awk -F/ '{print $1}'`
    if [ "$ispoint" = "." ]
    then
        dir=`/bin/echo $dir|/usr/bin/sed 's/^.//'`
        curpath="`pwd`$dir"
    elif [ "$ispoint" = ".." ]
    then
        curpath="`pwd`/$dir"
    else
       curpath="$dir"
    fi
    return 0
}

InputParas()
{
    whouser=`whoami`
    if [ "$whouser" != "root" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] please run this script as user 'root' "
        exit 1
    fi
    
    root_pwd=${os_pwd_root}
    ossadm_pwd=${os_pwd_ossadm}
    admin_pwd=${fi_pwd_admin}
    
    ossadm_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${ossadm_pwd}")
    root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${root_pwd}")
    admin_pwd=$(perl -e 'print quotemeta shift(@ARGV)' "${admin_pwd}")
}

SizeCheck()
{
    cd /opt/fiupdate
    expect <<END
    spawn bash sizelicense_check.sh
    expect {
        "please input root password:" {send "$root_pwd\r"}
    }
    expect {
        "please input admin password:" {send "$admin_pwd\r"}
    }
    set timeout -1
    expect "*#"
    exit
END
}

Main()
{
    InputParas
    SizeCheck
    sizecheckResult=`cat ${curpath}/log/precheck_sizelicense_work.log | grep "script in stage Checkdisklicense all FI system success"`
    if [ "x${sizecheckResult}" == "x" ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[41;30m SysCheck disk size and license is failed. \033[0m"
        return 1
    else
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[42;34m SysCheck disk size and license is success. \033[0m"
    fi

    # show fi license status, log file create by sys_check.sh check_fi_license()
    product_ini=`find /opt/fiupdate/NCE_info/ -name "node*.ini" -type f`
    cat $product_ini | grep "mode=single" > /dev/null
    issingle=$?
    is_license_ok=0
    lic_deadline=`cat ${curpath}/log/check_fi_license.log | grep -i "License Deadline"`
    lic_deadline=`echo $lic_deadline`
    cat ${curpath}/log/check_fi_license.log | grep -i "License status is normal"  > /dev/null 2>&1
    if [ $? -eq 0 ];then
        rm -f ${curpath}/log/check_fi_license.log > /dev/null 2>&1
        echo "The license of FusionInsight HD is normal."
        if [ -n "$lic_deadline" ];then
            echo "${lic_deadline}"
        fi
    else
        cat ${curpath}/log/check_fi_license.log | grep -i "No license file is available"  > /dev/null 2>&1
        licenseava=$?
        if [ $licenseava -eq 0 ] && [ $issingle -ne 0 ];then
            is_license_ok=1
            echo "Warning! No license file is available for FusionInsight!"
        elif [ $licenseava -eq 0 ] && [ $issingle -eq 0 ];then
            is_license_ok=1
            echo "No license is required in single scale scenarios."
        fi
        cat ${curpath}/log/check_fi_license.log | grep -i "License status is expired"  > /dev/null 2>&1
        if [ $? -eq 0 ];then
            is_license_ok=1
            echo "Error! The license of FusionInsight is expired!"
        fi
        cat ${curpath}/log/check_fi_license.log | grep -i "The license is temporary"  > /dev/null 2>&1
        if [ $? -eq 0 ];then
            is_license_ok=1
            echo "Warning! The license of FusionInsight is temporary!"
        fi
        cat ${curpath}/log/check_fi_license.log | grep -i "check license failed"  > /dev/null 2>&1
        if [ $? -eq 0 -o $is_license_ok -eq 0 ];then
            echo "Error, Check the license failed. Please log in to the FusionInsight HD management plane at https://Analyzer_Calc_Storage eth0:web IP address:28443/web, then check whether the license is normal."
        fi
    fi

    # show fi nodes Disk size status
    cat ${curpath}/log/precheck_sizelicense_work.log | grep -i "precheck the disk size is normal"  > /dev/null 2>&1
    if [ $? -eq 0 ];then
        echo "The FI nodes disk size is normal."
    else
        echo "The FI nodes disk size is abnormal, please check in /opt/fiupdate/log/checksize.log."
    fi
    echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] \033[42;34m Precheck work in stage Checksizelicense is successfully. \033[0m"
    return 0
}

SuperMain()
{
    Main $* > ${curpath}/log/update_fi_pre_size_license.log
    ret=$?
    if [ $ret -eq 0 ]
    then
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Precheck work in stage Checksizelicense is successfully."
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Precheck work in stage Checksizelicense is successfully." >> ${curpath}/log/update_fi_pre_size_license.log
    else
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Precheck work in stage Checksizelicense is failed."
        echo -e "\n[`date '+%Y-%m-%d %H:%M:%S'`] Precheck work in stage Checksizelicense is failed." >> ${curpath}/log/update_fi_pre_size_license.log
    fi
    chown -R ossadm:ossgroup ${curpath}/log/
}

GetWorkPath
SuperMain $* &
superret=$?
exit $superret
