#!/bin/bash

#downloadPath=$WORKSPACE/BUILD_SERVICE_PACKAGE
#packagePath=$WORKSPACE/PACKAGE_RESULT
#CUR_PATH=$WORKSPACE/code/CI
downloadPath=$1
package_path=$2
CUR_PATH=$(dirname $(readlink -f $0))
CODE_PATH=$CUR_PATH/..
echo downloadPath=$downloadPath
echo package_path=$package_path
echo CODE_PATH=$CODE_PATH

[ -f "$CUR_PATH/"../../release_version.properties ] && cat $CUR_PATH/../../release_version.properties
[ -f "$CUR_PATH/"../../release_version.properties ] && source $CUR_PATH/../../release_version.properties
[ -f "$CUR_PATH/"../release_version.properties ] && cat $CUR_PATH/../release_version.properties
[ -f "$CUR_PATH/"../release_version.properties ] && source $CUR_PATH/../release_version.properties

ls $downloadPath
if [ ${ARCH_TYPE} == "ARM" ];then
    dual_version="arm64"
    rm -rf $downloadPath/EtcdService*amd64*.zip
elif [ ${ARCH_TYPE} == "Euler" ];then
    dual_version="amd64"
    rm -rf $downloadPath/EtcdService*arm64*.zip
else
    echo "The parameter Error"
    dual_version=""
fi
echo "STEP_2.1: cp dual:${ARCH_TYPE} micro-service package to Service..."

#cp $downloadPath/*.zip $CODE_PATH/Services/Common/
#mkdir $CODE_PATH/Services/Common/WangmiaoService;cp -rf $downloadPath/WangmiaoService*.zip $CODE_PATH/Services/Common/WangmiaoService/
mkdir $CODE_PATH/Services/Common/EtcdService/;cp -rf $downloadPath/EtcdService*.zip $CODE_PATH/Services/Common/EtcdService/


echo  "STEP_2.2: zip Service packages"
echo "${SERVICE_VERSION}"
cd $CODE_PATH
find ./ -name .gitkeep | xargs rm -rf
zip -r ${SERVICE_NAME}-${SERVICE_VERSION}-${dual_version}.zip Services package

#add for Release_Services_ToFTP.sh  :lcd ${WORKSPACE}/$SERVICE_NAME/$PACKAGE_PATH
mkdir $CODE_PATH/PACKAGE_RESULT
cp ${SERVICE_NAME}-${SERVICE_VERSION}-${dual_version}.zip $CODE_PATH/PACKAGE_RESULT/
[ ! -d $package_path ] && mkdir $package_path
cp $CODE_PATH/${SERVICE_NAME}-${SERVICE_VERSION}-${dual_version}.zip $package_path
echo "PACKAGE_PATH=PACKAGE_RESULT" >> $WORKSPACE/release_version.properties
