#!/bin/bash
#start build
# Copyright © Huawei Technologies Co., Ltd. 2010-2018. All rights reserved.
set -e
CUR_PATH=$(dirname $(readlink -f $0))
ROOT_PATH=${CUR_PATH}/../..

function getshellres(){
    if [ $? != 0 ] ; then
        echo '[ERROR] Command Execute Fail!'
        exit 1;
    fi
}
#get service name
function get_service_name()
{
        parent_path=$(dirname ${CUR_PATH})
        export SERVICE=${parent_path##*/}
}
# download CI
function download_ci()
{
        cd ${ROOT_PATH}
        artifact_path='http://szxy1.artifactory.cd-cloud-artifact.tools.huawei.com/artifactory/Product-AC-BP-release/com/huawei/ncecommon/3rd/CommonCI'
        wget $artifact_path/maven-metadata.xml
        newest_version=$(cat maven-metadata.xml |grep -oP '(?<=<release>).*(?=</release>)' )
        wget $artifact_path/$newest_version/CommonCI-$newest_version.zip
        if [ -d "${ROOT_PATH}/CI" ];then
                rm -rf ${ROOT_PATH}/CI
        fi
        unzip CommonCI*.zip -d CI >${ROOT_PATH}/CommonCI.log 2>&1
        rm -f CommonCI.log CommonCI*.zip maven-metadata.xml
}
#build
function build_service()
{
        cd ${ROOT_PATH}/${SERVICE}/script
        cp -f ${ROOT_PATH}/CI/script/oneKeyCompile/buildService.sh ./
        sh buildService.sh
        getshellres
}

function main()
{
        get_service_name
        if [[ "$OFFLINECOMPILE" == true ]];then
            [ ! -d "${ROOT_PATH}/CI" ] && cp -r ${ROOT_PATH}/../CI ${ROOT_PATH}/CI
        else
            download_ci
        fi
        if [ ! -d "${ROOT_PATH}/CI" ];then
                echo ">>>>>>[ERROR] CI is not exist !!"
                exit 1
        fi
        build_service
}

main $@

