
CREATE TABLE IF NOT EXISTS T_GATHER_DB_STATS_FILTER_CLOUDSOP(
    OWNER  VARCHAR2(64) NOT NULL  PRIMARY KEY,
    FULL_ENABLE  BINARY_INTEGER NOT NULL DEFAULT 1,
    INCR_ENABLE  BINARY_INTEGER NOT NULL DEFAULT 1
); 


CREATE OR  REPLACE PROCEDURE P_GATHER_DB_STATS_CLOUDSOP(
    estimate_percent NUMBER  DEFAULT 10,
    force            BOOLEAN DEFAULT TRUE,
    max_minutes      INTEGER  DEFAULT 360
) 
--force false: don't gather when cbo is disable
--max_minutes: default 6 hours
IS
    cbo_enable   VARCHAR(3);
    start_time   DATE;
    curr_time    DATE;
    is_finish    boolean;
    snapshot_too_old  EXCEPTION;                    -- declare exception
    v_table      VARCHAR(130);
    PRAGMA EXCEPTION_INIT (snapshot_too_old, 715);  -- assign error code to exception
BEGIN   
    IF max_minutes < 1 OR max_minutes > 1440 THEN
        DBE_STD.THROW_EXCEPTION(-20000, 'max_minutes should between [1, 1440]');
    END IF; 

    --check cbo flag
    IF force = FALSE THEN       
        SELECT VALUE INTO cbo_enable FROM SYS.DV_PARAMETERS WHERE NAME='CBO';
        IF UPPER(cbo_enable) = 'OFF' THEN
            RETURN;
        END IF;
    END IF;
    
    start_time := SYSDATE;
    
    --only gather new heap table
    LOOP
        is_finish := false;
        
        BEGIN
        FOR ITEM IN (SELECT OWNER, TABLE_NAME FROM ADM_TABLES WHERE TABLE_TYPE in ('HEAP', 'NOLOGGING') AND LAST_ANALYZED is NULL
                     AND OWNER IN (SELECT X.OWNER FROM T_GATHER_DB_STATS_FILTER_CLOUDSOP X WHERE X.FULL_ENABLE = 1)) 
        LOOP
            curr_time := SYSDATE;
            IF curr_time > (start_time + max_minutes/1440) THEN
                RETURN;
            END IF;
            
            BEGIN
                v_table := '"'||ITEM.TABLE_NAME||'"';
                DBE_STATS.COLLECT_TABLE_STATS(ITEM.OWNER, v_table, null, estimate_percent);
            EXCEPTION
                WHEN OTHERS THEN
                  NULL;
            END;
        END LOOP;
        
        is_finish := true;
        
        EXCEPTION
          WHEN snapshot_too_old THEN                         -- handle exception
            NULL;
        END;
        
        IF is_finish = true THEN
            EXIT; 
        END IF;
    END LOOP;
    
    --only gather heap table
    LOOP
        is_finish := false;
        
        BEGIN
        FOR ITEM IN (SELECT OWNER, TABLE_NAME,LAST_ANALYZED FROM ADM_TABLES WHERE TABLE_TYPE in ('HEAP', 'NOLOGGING') AND 
                    LAST_ANALYZED < start_time 
                    AND OWNER IN (SELECT X.OWNER FROM T_GATHER_DB_STATS_FILTER_CLOUDSOP X WHERE X.FULL_ENABLE = 1)
                    ORDER BY LAST_ANALYZED) 
        LOOP
            curr_time := SYSDATE;
            IF curr_time > (start_time + max_minutes/1440) THEN
                RETURN;
            END IF;
            
            BEGIN
                v_table := '"'||ITEM.TABLE_NAME||'"';
                DBE_STATS.COLLECT_TABLE_STATS(ITEM.OWNER, v_table, null, estimate_percent);
            EXCEPTION
                WHEN OTHERS THEN
                  NULL;
            END;
        END LOOP;
        
        is_finish := true;
        
        EXCEPTION
          WHEN snapshot_too_old THEN                         -- handle exception
            NULL;
        END;
        
        IF is_finish = true THEN
            EXIT; 
        END IF;
    END LOOP;
END;
/


CREATE OR  REPLACE PROCEDURE P_GATHER_CHANGE_STATS_CLOUDSOP(
    estimate_percent NUMBER DEFAULT 10,
    change_percent   NUMBER DEFAULT 10,
    force            BOOLEAN DEFAULT TRUE,
    max_minutes      NUMBER  DEFAULT 60
) 
--force false: don't gather when cbo is disable
--max_minutes: default 1 hour
IS
    cbo_enable   VARCHAR(3);
    start_time   DATE;
    curr_time    DATE;
    is_finish    boolean;
    snapshot_too_old  EXCEPTION;                    -- declare exception
    v_table      VARCHAR(130);
    v_part       VARCHAR(130);
    PRAGMA EXCEPTION_INIT (snapshot_too_old, 715);  -- assign error code to exception
BEGIN
    IF max_minutes < 1 OR max_minutes > 1440 THEN
        DBE_STD.THROW_EXCEPTION(-20000, 'max_minutes should between [1, 1440]');
    END IF; 
    
    --check cbo flag
    IF force = FALSE THEN       
        SELECT VALUE INTO cbo_enable FROM SYS.DV_PARAMETERS WHERE NAME='CBO';
        IF UPPER(cbo_enable) = 'OFF' THEN
            RETURN;
        END IF;
    END IF;
        
    start_time := SYSDATE;
    --flush modification to table
    DBE_STATS.FLUSH_DB_STATS_INFO();    
    
    --(1)gather the new table
    LOOP
        is_finish := false;
        
        BEGIN
        FOR ITEM IN (SELECT OWNER, TABLE_NAME FROM ADM_TABLES WHERE TABLE_TYPE in ('HEAP', 'NOLOGGING') AND LAST_ANALYZED is NULL
		             AND OWNER IN (SELECT X.OWNER FROM T_GATHER_DB_STATS_FILTER_CLOUDSOP X WHERE X.FULL_ENABLE = 1)) 
        LOOP    
            curr_time := SYSDATE;
            IF curr_time > (start_time + max_minutes/1440) THEN
                RETURN;
            END IF;
                        
            BEGIN
                v_table := '"'||ITEM.TABLE_NAME||'"';
                DBE_STATS.COLLECT_TABLE_STATS(ITEM.OWNER, v_table, NULL, estimate_percent);
            EXCEPTION
                WHEN OTHERS THEN
                  NULL;
            END;
        END LOOP;
        
        is_finish := true;
        
        EXCEPTION
            WHEN snapshot_too_old THEN                         -- handle exception
            NULL;
        END;
        
        IF is_finish = true THEN
            EXIT; 
        END IF;
    END LOOP;
    
    --(2)gather the table changed 
    LOOP
        is_finish := false;
        
        BEGIN
        FOR ITEM IN (SELECT A.OWNER, A.TABLE_NAME, A.LAST_ANALYZED FROM ADM_TABLES A, ADM_TAB_MODIFICATIONS B 
        WHERE A.TABLE_TYPE in ('HEAP', 'NOLOGGING') AND A.OWNER = B.TABLE_OWNER AND A.TABLE_NAME=B.TABLE_NAME 
        AND B.PARTITION_NAME IS NULL AND A.LAST_ANALYZED < start_time AND
            ((NVL(B.INSERTS, 0) + NVL(B.UPDATES, 0) + NVL(B.DELETES, 0))>= (CHANGE_PERCENT * A.NUM_ROWS/100))
            AND A.OWNER IN (SELECT X.OWNER FROM T_GATHER_DB_STATS_FILTER_CLOUDSOP X WHERE X.FULL_ENABLE = 1)
            ORDER BY A.LAST_ANALYZED) 
        LOOP    
            curr_time := SYSDATE;
            IF curr_time > (start_time + max_minutes/1440) THEN
                RETURN;
            END IF;
                        
            BEGIN
                v_table := '"'||ITEM.TABLE_NAME||'"';
                DBE_STATS.COLLECT_TABLE_STATS(ITEM.OWNER, v_table, NULL, estimate_percent);
            EXCEPTION
                WHEN OTHERS THEN
                  NULL;
            END;
        END LOOP;
        
        is_finish := true;
        
        EXCEPTION
            WHEN snapshot_too_old THEN                         -- handle exception
            NULL;
        END;
        
        IF is_finish = true THEN
            EXIT; 
        END IF;
    END LOOP;
    
    --(3)gather the new partition 
    LOOP
        is_finish := false;
        
        BEGIN
        FOR ITEM IN (SELECT U.NAME AS OWNER, T.NAME AS TABLE_NAME, TP.NAME AS PARTITION_NAME
           FROM SYS.SYS_USERS U JOIN SYS.SYS_TABLES T ON U.ID = T.USER# 
           JOIN SYS.SYS_TABLE_PARTS TP ON T.USER# = TP.USER# AND T.ID = TP.TABLE# AND TP.ANALYZETIME IS NULL
                AND U.NAME IN (SELECT X.OWNER FROM T_GATHER_DB_STATS_FILTER_CLOUDSOP X WHERE X.INCR_ENABLE = 1))
        LOOP    
            curr_time := SYSDATE;
            IF curr_time > (start_time + max_minutes/1440) THEN
                RETURN;
            END IF;
                        
            BEGIN
                v_table := '"'||ITEM.TABLE_NAME||'"';
                v_part  := '"'||ITEM.PARTITION_NAME||'"';
                DBE_STATS.COLLECT_TABLE_STATS(ITEM.OWNER, v_table, v_part, estimate_percent);               
            EXCEPTION
                WHEN OTHERS THEN
                  NULL;
            END;
        END LOOP;
        
        is_finish := true;
        
        EXCEPTION
            WHEN snapshot_too_old THEN                         -- handle exception
            NULL;
        END;
        
        IF is_finish = true THEN
            EXIT; 
        END IF;
    END LOOP;
    
    --(4)gather the partition changed 
    LOOP
        is_finish := false;
        
        BEGIN
        FOR ITEM IN (SELECT U.NAME AS OWNER, T.NAME AS TABLE_NAME, TP.NAME AS PARTITION_NAME, TP.ANALYZETIME
           FROM SYS.SYS_USERS U JOIN SYS.SYS_TABLES T ON U.ID = T.USER# 
           JOIN SYS.SYS_TABLE_PARTS TP ON T.USER# = TP.USER# AND T.ID = TP.TABLE#
           JOIN SYS.SYS_DML_STATS MO ON T.USER# = MO.USER# AND T.ID = MO.TABLE# AND MO.PART# = TP.PART# 
           WHERE MO.PARTED = 1 AND MO.PART# <> -1 AND TP.ANALYZETIME < start_time AND
           ((NVL(MO.INSERTS, 0) + NVL(MO.UPDATES, 0) + NVL(MO.DELETES, 0))>= (CHANGE_PERCENT * TP.ROWCNT/100))
            AND U.NAME IN (SELECT X.OWNER FROM T_GATHER_DB_STATS_FILTER_CLOUDSOP X WHERE X.INCR_ENABLE = 1)
           ORDER BY TP.ANALYZETIME) 
        LOOP    
            curr_time := SYSDATE;
            IF curr_time > (start_time + max_minutes/1440) THEN
                RETURN;
            END IF;
                        
            BEGIN
                v_table := '"'||ITEM.TABLE_NAME||'"';
                v_part  := '"'||ITEM.PARTITION_NAME||'"';
                DBE_STATS.COLLECT_TABLE_STATS(ITEM.OWNER, v_table, v_part, estimate_percent);               
            EXCEPTION
                WHEN OTHERS THEN
                  NULL;
            END;
        END LOOP;
        
        is_finish := true;
        
        EXCEPTION
            WHEN snapshot_too_old THEN                         -- handle exception
            NULL;
        END;
        
        IF is_finish = true THEN
            EXIT; 
        END IF;
    END LOOP;
END;
/

DECLARE
 JOBNO NUMBER;
 JOB_COUNT NUMBER;
BEGIN
 FOR ITEM IN (SELECT JOB FROM SYS_JOBS WHERE WHAT LIKE '%P_GATHER_DB_STATS_CLOUDSOP(%' ) LOOP
    DBE_TASK.CANCEL(ITEM.JOB);
 END LOOP;
 DBE_TASK.SUBMIT(JOBNO,'P_GATHER_DB_STATS_CLOUDSOP(estimate_percent=>10, force=>FALSE);', TRUNC(SYSDATE+1) + 1/24, 'TRUNC(sysdate+1) +1/24');
 --DBE_TASK.SUSPEND(JOBNO,true);
 COMMIT;
END;
/

DECLARE
 JOBNO NUMBER;
 JOB_COUNT NUMBER;
BEGIN
 FOR ITEM IN (SELECT JOB FROM SYS_JOBS WHERE WHAT LIKE '%P_GATHER_CHANGE_STATS_CLOUDSOP(%' ) LOOP
    DBE_TASK.CANCEL(ITEM.JOB);
 END LOOP;
 DBE_TASK.SUBMIT(JOBNO,'P_GATHER_CHANGE_STATS_CLOUDSOP(estimate_percent=>10, change_percent=>10, force=>FALSE);', SYSDATE, 'SYSDATE+15/24/60');
 --DBE_TASK.SUSPEND(JOBNO,true);
 COMMIT;
END;
/
 

--DISABLE GATHER_NCE_DB_STATS/GATHER_NCE_CHANGE_STATS
BEGIN
 FOR ITEM IN (SELECT JOB AS JOBNO FROM SYS_JOBS WHERE WHAT LIKE '%GATHER_NCE_%' AND  BROKEN = 0) 
 LOOP    
     BEGIN   
         DBE_OUTPUT.PRINT_LINE(SYSDATE || ' INFO ' || 'DBE_TASK.SUSPEND(' || ITEM.JOBNO || ',TRUE)...');
         DBE_TASK.SUSPEND(ITEM.JOBNO,TRUE);
         COMMIT;
     EXCEPTION
         WHEN OTHERS THEN
           NULL;
     END;
 END LOOP;
END;
/


--INSERT T_GATHER_DB_STATS_FILTER_CLOUDSOP
TRUNCATE TABLE T_GATHER_DB_STATS_FILTER_CLOUDSOP;
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ADMINHOMEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('APIGATEWAY_AM_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('APIGOVERNANCEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('AUDITLOGDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('AUTODISCOVERYDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('CMDBCOREPROXYDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('CMDBCORESVRDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('CRONDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('DOMAINDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('EAMDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_0_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_1_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_2_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_3_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_4_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_5_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_6_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_7_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_8_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_9_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_10_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_11_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_12_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_13_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_14_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMDATA_15_DB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMFORWARDDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('FMMASTERDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ROOTCAUSEANALYSISDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('IDGENDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('INFOCENTERSERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('INVMETADATADB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('LICENSEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('LIFECYCLEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('LOGDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('LOGMGRSERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('MERESGRPDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('MOUISERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('NBICOMMONDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('NSCFRTCATALOGSERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ODAEACCESSPOINTSERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ODAECONFIGMGRDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ODAEDATACATALOGDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ODAEDUMPSERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ODAEOLAPAGENTSERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ODAEOLAPLOADERSERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ODAEOMDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ODAEPIPELINEMGRSERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ODAEQUERYENGINEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ODAESPARKDISPSERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('OMCDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('PRIVILEGEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('SECURITYCONFIGDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('RCACCESSCONFIGDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('RMCOORDINATEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('RMTASKMGMTDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('RNDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('SECONDARYAUTHDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('SIADB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('SYSFENSDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('SYSLOGDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('SYSPREFERENCESDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('TOPODB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('USERDB'); 

INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('CMCCLOUDSERVICEDB'); 
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('NBIPERFORMANCESERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('SNBCERTMGMTSERVICEDB');

INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('BACKUPDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('DBMGRDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('DEPLOYCONTROLLERDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('DEPLOYCOREDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('ENGRCOMMONSERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('MAINTENANCESERVICEDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('OSPATCHDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('PKGREPODB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('PRODUCTMONITORDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('SYSMGRDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('TASKMGRDB');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('HOFSDB1');
INSERT INTO T_GATHER_DB_STATS_FILTER_CLOUDSOP(OWNER) VALUES('REPOMGRSERVICEDB');

COMMIT;