# coding:utf-8
"""
功能：NodeLayoutTableBusiness类，该类主要涉及前端显示表格的数据处理
版权信息：华为技术有限公司，版本所有(C) 2010-2020
"""

import copy
import os
import re

from plugins.ROC.py_scripts.common.utils.parse_custom_json import ParseCustomJson
from plugins.ROC.py_scripts.common.utils.config_controls import ConfigControls


class NodeLayoutTableBusiness:
    """
    功能：涉及前端显示表格的数据处理
    """

    def __init__(self, kvs, ctrl_set, src_dir_path, custom_conditions):
        from ...lld.modify_view_scripts.filter_vm_res import filter_blade_node_relationships
        self.src_dir_path = src_dir_path
        self.ctrl_set = ctrl_set
        self.kvs = kvs
        self.custom_conditions = custom_conditions
        self.nodes_resource_dict = ParseCustomJson.get_lld_param_dict(src_dir_path,
                                                                      "nodes_resource.json")
        self.blade_node_relationships = filter_blade_node_relationships(kvs, custom_conditions,
                                                                        src_dir_path)

    def fulfill_table(self):
        """
        功能：表格填充
        :return:
        """
        # 返回扩容虚拟机节点布局
        if self.kvs.get("action") in ["expansion", "roc_expansion"]:
            return self.fulfill_table_expansion()
        num = 1
        controls = []
        server_type = self.kvs.get("server_type")
        cpu_type = self.kvs.get("cpu_type")

        for blade_node_rel in self.blade_node_relationships:
            blade_config = {}
            if cpu_type == "X86" and server_type == "E9000":
                blade_config = ConfigControls.get_config("virtuallayout_config_blade%d" % num,
                                                         "Blade" + blade_node_rel.get("blade_id",
                                                                                      ""))
            else:
                blade_config = ConfigControls.get_config("virtuallayout_config_blade%d" % num,
                                                         blade_node_rel.get("blade_id", ""))
            controls.append(blade_config)
            node_cnt = 1
            nodes_res = blade_node_rel.get("nodes")
            node_list = list()
            for i in range(1, 8):
                node = ConfigControls.get_config("virtuallayout_config_node%d_%d" % (num, i), "",
                                                 cfg_type="group",
                                                 other={"controls": []})
                node_list.append(node)
                controls.append(node)
            nodes_res_tmp = copy.deepcopy(nodes_res)
            self.append_node_list(node_cnt, node_list, nodes_res, nodes_res_tmp, num)
            num += 1
        self.ctrl_set["controls"] = controls
        return None

    @staticmethod
    def append_node_list(*args):
        """
        功能：增加节点
        :param args:
        :return:
        """
        node_cnt, node_list, nodes_res, nodes_res_tmp, num = args
        if len(nodes_res) % 7 != 0:
            for _ in range(len(nodes_res) % 7, 7):
                nodes_res_tmp.append({"nodeName": ""})

        for node_res in nodes_res_tmp:
            node_name = node_res.get("nodeName", "")
            if node_name.startswith("VRM"):
                node_name = node_name.replace("_", "")
            node_index = 6
            if node_cnt % 7 != 0:
                node_index = (node_cnt % 7) - 1
            node_config = ConfigControls.get_config(
                "virtuallayout_config_blade%d_%d" % (num, node_cnt), node_name)
            node_list[node_index].get("controls", []).append(node_config)
            node_cnt += 1

    def fulfill_table_expansion(self):
        """
        功能：表格填充
        :return:
        """
        from easysuite import settings
        from utils.i18n import i18nDict
        controls = []
        cpu_type = self.kvs.get("cpu_type")
        server_type = self.kvs.get("server_type")
        taskmgr_lang_zh = i18nDict(os.path.join(settings.TASKMGR_PATH), lang="zh_CN")
        taskmgr_lang_en = i18nDict(os.path.join(settings.TASKMGR_PATH), lang="en_US")
        if not cpu_type:
            cpu_type = self.kvs.get("hardware_architecture", "")

        expansion_param = ParseCustomJson.get_lld_param_dict(self.src_dir_path,
                                                             "expansion_param.json")
        new_nodes = [additions_nodes.get("blade_id") for additions_nodes in
                     expansion_param.get("additions_nodes_deployment")
                     if additions_nodes.get("nodes") and
                     additions_nodes.get("blade_id") not in
                     self.kvs.get("source_blade_switch",
                                  "").split(",")
                     ]
        old_node_deploy = self.get_org_nodes_deploy()
        for old_vm_list, res_changed_list, num in old_node_deploy:
            controls.append(ConfigControls.get_config("virtuallayout_config_blade%s" % num, num))
            controls.append(
                ConfigControls.get_config("virtuallayout_config_type_blade_%s" % num,
                                          "old_server",
                                          text_zh=taskmgr_lang_zh.get("old_server", ""),
                                          text_en=taskmgr_lang_en.get("old_server", ""))
            )
            new_vm_list = []
            for blade_node_rel in self.blade_node_relationships:
                if blade_node_rel.get("blade_id", "") == str(num):
                    new_vm_list = self.get_vm_lists(expansion_param, blade_node_rel.get("nodes"))
            controls.append(
                ConfigControls.get_config("virtuallayout_config_old_vm_%s" % num,
                                          ";".join(old_vm_list))
            )
            controls.append(
                ConfigControls.get_config("virtuallayout_config_new_vm_%s" % num,
                                          ";".join(new_vm_list))
            )
            controls.append(
                ConfigControls.get_config("virtuallayout_config_res_changed_vm_%s" % num,
                                          ";".join(res_changed_list))
            )
        # 填虚拟节点布局表
        for blade_node_rel in self.blade_node_relationships:
            if blade_node_rel.get("blade_id", "") not in new_nodes:
                continue
            controls.append(
                ConfigControls.get_config("virtuallayout_config_blade%s" % blade_node_rel.get("blade_id", ""),
                                          blade_node_rel.get("blade_id", "")))
            controls.append(
                ConfigControls.get_config("virtuallayout_config_type_blade_%s" % blade_node_rel.get("blade_id", ""),
                                          "new_server",
                                          text_zh=taskmgr_lang_zh.get("new_server", ""),
                                          text_en=taskmgr_lang_en.get("new_server", ""))
            )
            new_vm_list = self.get_vm_lists(expansion_param,
                                            blade_node_rel.get("nodes"))
            controls.append(
                ConfigControls.get_config("virtuallayout_config_old_vm_%s" % blade_node_rel.get("blade_id", ""),
                                          ";".join([]))
            )
            controls.append(
                ConfigControls.get_config("virtuallayout_config_new_vm_%s" % blade_node_rel.get("blade_id", ""),
                                          ";".join(new_vm_list))
            )
            controls.append(
                ConfigControls.get_config("virtuallayout_config_res_changed_vm_%s" % blade_node_rel.get("blade_id", ""),
                                          ";".join([]))
            )
        self.ctrl_set["controls"] = controls

    def get_org_nodes_deploy(self):
        # 获取源环境每个cna上面有哪些节点
        org_res_dict = self.kvs.get("org_res_dict", {})
        changed_node_vm = {node.get("nodeName"): node.get("node_status")
                           for node in self.kvs.get("changed_node_vm_res", [])}
        cna_set = set(
            [hosts.get("host_name", "") for hosts in org_res_dict.values()
             if hosts.get("host_name", "")])
        cna_set = sorted(cna_set)
        nodes = []
        num = 1
        for cna in cna_set:
            old_node = []
            res_changed_node = []
            try:
                num = int(re.search(r"\d+", cna).group())
            except AttributeError:
                pass
            for key, value in org_res_dict.items():
                if "VRM" in key:
                    continue
                if value.get("host_name", "") == cna:
                    if changed_node_vm.get(key) == "resource_changed":
                        res_changed_node.append(key)
                    else:
                        old_node.append(key)
            nodes.append((old_node, res_changed_node, num))
            num += 1
        return nodes

    @staticmethod
    def get_blade_config(blade_node_rel, cpu_type, server_type, num):
        """
        功能：获取每个blade_node_rel的blade_config
        :param blade_node_rel:
        :param cpu_type:
        :param server_type:
        :param num:
        :return:
        """
        blade_config = {}
        if cpu_type == "X86" and server_type == "E9000":
            blade_id = "Blade%s" % blade_node_rel.get("blade_id", "")
            blade_config = ConfigControls.get_config("virtuallayout_config_blade%d" % num,
                                                     blade_id,
                                                     text_zh=blade_id.replace("Blade", "刀片"),
                                                     text_en=blade_id)
        else:
            blade_config = ConfigControls.get_config("virtuallayout_config_blade%d" % num,
                                                     blade_node_rel.get("blade_id", ""))
        return blade_config

    def get_vm_lists(self, expansion_param, nodes_res):
        """
        功能：获取vm列表
        :param expansion_param:
        :param nodes_res:
        :return:
        """
        new_vm_list = list()
        changed_node_vm_res = self.kvs.get("changed_node_vm_res")
        changed_node_res_dict = {
            changed_node_vm.get("nodeName"): changed_node_vm.get("node_status")
            for changed_node_vm in changed_node_vm_res
        }
        for node_res in nodes_res:
            node_name = node_res.get("nodeName", "")
            if "VRM" in node_name:
                continue
            if changed_node_res_dict.get(
                    node_name) == "new" or node_name in expansion_param.get("additions_nodes",
                                                                            []):
                new_vm_list.append(node_name)
        return new_vm_list

    def exe(self):
        """
        填充前台资源表表格入口
        :return:
        """
        # 填充前台资源表表格入口
        self.fulfill_table()
