# coding:utf-8
"""
功能：NodeTypeTableBusiness，该类主要涉及节点类型处理
版权信息：华为技术有限公司，版本所有(C) 2010-2020
"""

import re
from utils.i18n import _zh, _en
from plugins.ROC.py_scripts.common.utils.parse_custom_json import ParseCustomJson
from plugins.ROC.py_scripts.common.utils.config_controls import ConfigControls
from ...lld.modify_view_scripts.filter_vm_res import filter_vm_res

NUM = 1
NODES_ALL = 0
CPU_ALL = 0
MEMORY_ALL = 0
STORAGE_ALL = 0


def get_node_name_and_node_num(*args):
    """
    功能：获取node_name，node_num
    :param args:
    :return:
    """
    vm_node, vm_nodes, node_type, node_type_dict, vm_nodes_dict = args
    node_name = vm_node.get("nodeName")
    node_num = 1
    if len(vm_nodes) == 1:
        node_name = node_type
        node_num = node_type_dict.get(node_type)
    else:
        node_num_temp = vm_nodes_dict[node_name]
        if node_num_temp != 1:
            node_name_start = node_name
            node_name_stop = node_name_start[0:-2] + str(
                int(node_name_start[-2:]) + node_num_temp - 1).zfill(2)
            node_name = node_name_start + "~" + node_name_stop
            node_num = node_num_temp
    return node_name, node_num

def get_controls_tmp(vm_node_input_tuple, node_name, node_num, node_vm_define):
    """
    功能：获取controls_tmp
    :param vm_node_input_tuple:
    :param node_name:
    :param node_num:
    :param node_vm_define:
    :return:
    """
    controls_params_tuple = vm_node_input_tuple[0]
    node_category = controls_params_tuple[0]
    node_category_en = controls_params_tuple[1]
    nodedes_zh = controls_params_tuple[2]
    nodedes_en = controls_params_tuple[3]
    protected = controls_params_tuple[6]
    deploy = controls_params_tuple[7]
    controls_tmp = []
    controls_tmp.append(
        ConfigControls.get_config("vrm.node_%d" % NUM, node_category,
                                  text_zh=node_category,
                                  text_en=node_category_en))
    controls_tmp.append(
        ConfigControls.get_config("vrm.name_%d" % NUM, node_name)
    )
    controls_tmp.append(
        ConfigControls.get_config("vrm.description_%d" % NUM,
                                  nodedes_zh,
                                  text_zh=nodedes_zh,
                                  text_en=nodedes_en)
    )
    controls_tmp.append(
        ConfigControls.get_config("vrm.protection_%d" % NUM,
                                  protected,
                                  text_zh=_zh(protected.lower()),
                                  text_en=_en(protected.lower()))
    )
    controls_tmp.append(
        ConfigControls.get_config("vrm.strategy_%d" % NUM, deploy,
                                  text_zh=_zh(deploy.lower()),
                                  text_en=_en(deploy.lower()))
    )
    controls_tmp.append(ConfigControls.get_config("vrm.vmnumber_%d" % NUM,
                                                  str(node_num)))
    controls_tmp.append(
        ConfigControls.get_config("vrm.vcpu_%d" % NUM,
                                  str(node_vm_define.get("CPU")))
    )
    controls_tmp.append(
        ConfigControls.get_config("vrm.memory_%d" % NUM,
                                  str(node_vm_define.get("memory")))
    )

    return controls_tmp

def get_sub_controls(storage_define, node_name, node_vm_define):
    """
    功能：获取sub_controls
    :param storage_define:
    :param node_name:
    :param node_vm_define:
    :return:
    """
    sub_controls = []
    system_storage = str(storage_define.get("default").get("system_storage"))
    default_data_storage_1 = storage_define.get("default").get("data_storage_1")
    if node_name.startswith("VRM"):
        system_storage_for_vrm = int(node_vm_define.get("storage"))
        storage_col_1 = ConfigControls.get_config("vrm.storage_%d_1" % NUM,
                                                  "系统盘：%d" % system_storage_for_vrm,
                                                  text_zh="系统盘：%d" % system_storage_for_vrm,
                                                  text_en="System Disk：%d" % system_storage_for_vrm)
    else:
        storage_col_1 = ConfigControls.get_config("vrm.storage_%d_1" % NUM,
                                                  "系统盘：%s" % system_storage,
                                                  text_zh="系统盘：%s" % system_storage,
                                                  text_en="System Disk：%s" % system_storage)

    sub_controls.append(storage_col_1)
    if not [node_type_item for node_type_item in
            storage_define.get("special_node").get("node_type") if
            node_name.startswith(node_type_item)]:
        if not node_name.startswith("VRM"):
            data_storage_1 = str(int(node_vm_define.get("storage"))
                                 - int(system_storage)
                                 )
            storage_col_2 = ConfigControls.get_config("vrm.storage_%d_2" % NUM,
                                                      "数据盘：%s" % data_storage_1,
                                                      text_zh="数据盘：%s" % data_storage_1,
                                                      text_en="Data Disk：%s" % data_storage_1)
            sub_controls.append(storage_col_2)
    else:
        data_storage_1 = default_data_storage_1
        for data_storage in storage_define.get("special_node").get("data_storage"):
            if data_storage.get("total_storage") == int(node_vm_define.get("storage")):
                data_storage_1 = str(data_storage.get("data_storage_1"))

        storage_col_2 = ConfigControls.get_config("vrm.storage_%d_2" % NUM,
                                                  "数据盘1：%s" % data_storage_1,
                                                  text_zh="数据盘1：%s" % data_storage_1,
                                                  text_en="Data Disk 1：%s" % data_storage_1)
        data_storage_2 = str(
            int(node_vm_define.get("storage")) - int(system_storage) - int(data_storage_1))
        storage_col_3 = ConfigControls.get_config("vrm.storage_%d_3" % NUM,
                                                  "数据盘2：%s" % data_storage_2,
                                                  text_zh="数据盘2：%s" % data_storage_2,
                                                  text_en="Data Disk 2：%s" % data_storage_2)
        sub_controls.append(storage_col_2)
        sub_controls.append(storage_col_3)
    return sub_controls

class NodeTypeTableBusiness:
    """
    功能：涉及节点类型处理
    """

    def __init__(self, kvs, ctrl_set, src_dir_path, custom_conditions):
        self.src_dir_path = src_dir_path
        self.ctrl_set = ctrl_set
        self.kvs = kvs
        self.custom_conditions = custom_conditions
        self.node_vm_res, self.old_node_list = filter_vm_res(self.kvs,
                                                             self.custom_conditions,
                                                             self.src_dir_path
                                                             )
        if kvs.get("action", "") in ["expansion", "roc_expansion"]:
            self.node_vm_res = self.kvs.get("changed_node_vm_res", [])
        self.nodes_resource_dict = ParseCustomJson.get_lld_param_dict(src_dir_path,
                                                                      "nodes_resource.json"
                                                                      )
        self._handle_special_node()

    def _handle_special_node(self):
        """节点的数据若不同，通过修改node_type来分开显示"""
        node_vm_res = self.nodes_resource_dict.get("node_vm_res")
        nce_node_type = self.nodes_resource_dict.get("nce_node_type")
        node_name_data_map = dict()
        for node in node_vm_res:
            node_name = node["nodeName"]
            node_vm_define = sorted(node["node_vm_define"].items(), key=lambda x: x[0])
            node_tag = "".join([char for char in str(node_name) if char.isalpha()] +
                               [str(value) for _, value in node_vm_define])
            node_name_data_map[node_name] = node_tag
        node_name_data_map = sorted(node_name_data_map.items(), key=lambda x: x[0])
        node_group = []
        temp_data = ""
        for node, data in node_name_data_map:
            if data != temp_data:
                node_group.append(list())
                temp_data = data
            node_group[-1].append(node)
        rec = re.compile(r"[0-9][0-9_]*")
        for idx, node in enumerate(nce_node_type):
            for group in node_group:
                if node["node_name"] in group:
                    num_tag = rec.findall(str(group[-1]))
                    if len(group) == 1:
                        nce_node_type[idx]["node_type"] = str(group[0])
                    elif num_tag:
                        nce_node_type[idx]["node_type"] = str(group[0]) + "~" + num_tag[-1]
                    break

    def get_node_type_dict(self):
        """
        功能：获取节点类型
        :return:
        """
        nce_node_type = self.nodes_resource_dict.get("nce_node_type")
        node_type_dict = {}
        for node_vm in self.node_vm_res:
            node_name = node_vm.get("nodeName")
            if node_vm.get("node_status", "") == "old":
                continue
            if not self.nodes_resource_dict.get("node_to_blade").get(node_name, ""):
                continue
            for node_type_def in nce_node_type:
                if node_type_def.get("node_name") == node_name:
                    node_type = node_type_def.get("node_type")
                    if node_type in node_type_dict:
                        node_type_dict.update({node_type: node_type_dict.get(node_type) + 1})
                    else:
                        node_type_dict.update({node_type: 1})
                    break
        return node_type_dict

    def get_vm_node_controls_params(self,
                                    node_type,
                                    node_desc_dict_en,
                                    node_desc_dict_zh):
        """
        功能：获取完整的controls参数
        :param node_type:
        :param node_desc_dict_en:
        :param node_desc_dict_zh:
        :return:
        """
        # 获取controls的参数
        vm_nodes = []
        vm_nodes_dict = {}

        for node_type_item in self.nodes_resource_dict.get("nce_node_type", []):
            if node_type == node_type_item.get("node_type"):
                node_name = node_type_item.get("node_name")
                for node_vm in self.node_vm_res:
                    if not self.nodes_resource_dict.get("node_to_blade", {}).\
                            get(node_vm.get("nodeName", ""), ""):
                        continue
                    if node_vm.get("nodeName") == node_name:
                        vm_nodes, vm_nodes_dict = self.get_vm_nodes_and_vm_nodes_dict(vm_nodes,
                                                                                      node_vm,
                                                                                      vm_nodes_dict
                                                                                      )
        node_desc_dict_zh.update(
            {"node_category_%s" % NUM: self.get_controls(node_type)[4],
             "node_desc_%s" % NUM: self.get_controls(node_type)[2]}
        )
        node_desc_dict_en.update(
            {"node_category_%s" % NUM: self.get_controls(node_type)[5],
             "node_desc_%s" % NUM: self.get_controls(node_type)[3]}
        )
        return (self.get_controls(node_type)[4],
                self.get_controls(node_type)[5],
                self.get_controls(node_type)[2],
                self.get_controls(node_type)[3],
                vm_nodes, vm_nodes_dict,
                self.get_controls(node_type)[1],
                self.get_controls(node_type)[0]
                )

    def get_controls(self, node_type):
        """
        功能：配合get_vm_node_controls_params 获取参数
        :param node_type:
        :return:
        """
        protected = ""
        deploy = ""
        nodedes_zh = ""
        nodedes_en = ""
        node_category = ""
        node_category_en = ""
        for node_type_item in self.nodes_resource_dict.get("nce_node_type", []):
            if node_type == node_type_item.get("node_type"):
                protected = node_type_item.get("protected")
                deploy = node_type_item.get("deploy")
                nodedes_zh = node_type_item.get("node_des_zh")
                nodedes_en = node_type_item.get("node_des_en")
                node_category = node_type_item.get("node_category")
                node_category_en = node_type_item.get("node_category_en")
                if self.kvs.get("support_minimize", "") == "Yes":
                    protected = "single"
                    deploy = "affinity"

        return deploy, protected,nodedes_zh, \
               nodedes_en, node_category, \
               node_category_en

    @staticmethod
    def get_vm_nodes_and_vm_nodes_dict(vm_nodes, node_vm, vm_nodes_dict):
        """
        功能：配合get_vm_node_controls_params 获取参数
        :param vm_nodes:
        :param node_vm:
        :param vm_nodes_dict:
        :return:
        """
        node_vm_define = node_vm.get("node_vm_define")
        if not vm_nodes:
            if not vm_nodes:
                vm_nodes.append(node_vm)
                vm_nodes_dict[node_vm.get("nodeName")] = 1
            else:
                flag = 0
                for vm_nodes_character in vm_nodes:
                    node_vm_define_01 = vm_nodes_character.get("node_vm_define")
                    if node_vm_define.get("CPU") == node_vm_define_01.get("CPU") and \
                            node_vm_define.get("memory") == node_vm_define_01.get("memory") and \
                            node_vm_define.get("storage") == node_vm_define_01.get("storage") and \
                            node_vm_define.get("IOPS") == node_vm_define_01.get("IOPS"):
                        vm_nodes_dict[vm_nodes_character.get("nodeName")] += 1
                        flag = 1

                if flag == 0:
                    vm_nodes.append(node_vm)
                    vm_nodes_dict[node_vm.get("nodeName")] = 1

        return vm_nodes, vm_nodes_dict

    @staticmethod
    def ful_fill_vm_node_controls(vm_node_input_tuple):
        """
        功能：填充vm_node
        :param vm_node_input_tuple:
        :return:
        """
        controls_params_tuple = vm_node_input_tuple[0]
        controls = vm_node_input_tuple[1]
        vm_nodes = controls_params_tuple[4]
        global NUM, NODES_ALL, CPU_ALL, MEMORY_ALL, STORAGE_ALL

        for vm_node in vm_nodes:
            node_vm_define = vm_node.get("node_vm_define")
            node_name, node_num = get_node_name_and_node_num(vm_node,
                                                             vm_nodes,
                                                             vm_node_input_tuple[2],
                                                             vm_node_input_tuple[3],
                                                             controls_params_tuple[5]
                                                             )
            controls_tmp = get_controls_tmp(vm_node_input_tuple,
                                            node_name,
                                            node_num,
                                            node_vm_define)
            storage_col = ConfigControls.get_config("vrm.storage_%d" % NUM,
                                                    str(node_vm_define.get("storage")),
                                                    cfg_type="group")
            storage_col["controls"] = get_sub_controls(vm_node_input_tuple[4],
                                                       node_name,
                                                       node_vm_define)
            controls_tmp.append(storage_col)
            controls_tmp.append(
                ConfigControls.get_config("vrm.iops_%d" % NUM, str(node_vm_define.get("IOPS")))
            )
            controls.extend(controls_tmp)
            NODES_ALL += int(node_num)
            CPU_ALL += int(node_vm_define.get("CPU")) * int(node_num)
            MEMORY_ALL += int(node_vm_define.get("memory")) * int(node_num)
            STORAGE_ALL += int(node_vm_define.get("storage")) * int(node_num)
            NUM += 1

    def fulfill_table(self):
        """
        功能：填充表格
        :return:
        """
        global NUM, NODES_ALL, CPU_ALL, MEMORY_ALL, STORAGE_ALL
        NUM = 1
        NODES_ALL = 0
        CPU_ALL = 0
        MEMORY_ALL = 0
        STORAGE_ALL = 0

        controls = []
        is_expansion = False
        if self.kvs.get("action") in ["expansion", "roc_expansion"]:
            is_expansion = True
        for node_type in self.get_node_type_dict():
            # 网管集中化场景 FS没有VRM节点
            if self.kvs.get("is_NFVI", "").lower() == "yes" and node_type == "VRM":
                continue
            controls_params_tuple = \
                self.get_vm_node_controls_params(node_type, {}, {})
            vm_node_input_tuple = (
                controls_params_tuple, controls, node_type,
                self.get_node_type_dict(), self.get_storage_define(),
                {}, {}, is_expansion, self.get_additions_nodes()
            )
            NodeTypeTableBusiness.ful_fill_vm_node_controls(vm_node_input_tuple)

        controls.append(
            ConfigControls.get_config("vrm.node_%d" % NUM, "All", text="All", text_zh="全部",
                                      text_en="All"))
        controls.append(ConfigControls.get_config("vrm.name_%d" % NUM, "--"))
        controls.append(ConfigControls.get_config("vrm.description_%d" % NUM, "--"))
        controls.append(ConfigControls.get_config("vrm.protection_%d" % NUM, "--"))
        controls.append(ConfigControls.get_config("vrm.strategy_%d" % NUM, "--"))
        # 处理全量显示及增量显示逻辑
        controls.append(ConfigControls.get_config("vrm.vmnumber_%d" % NUM,
                                                  str(NODES_ALL)))
        controls.append(ConfigControls.get_config("vrm.vcpu_%d" % NUM,
                                                  str(CPU_ALL)))
        controls.append(ConfigControls.get_config("vrm.memory_%d" % NUM,
                                                  str(MEMORY_ALL)))
        controls.append(ConfigControls.get_config("vrm.storage_%d" % NUM,
                                                  str(STORAGE_ALL)))

        controls.append(ConfigControls.get_config("vrm.iops_%d" % NUM, "--"))
        self.ctrl_set["controls"] = controls

    def get_storage_define(self):
        """
        功能：获取storage_define
        :return:
        """
        nfvi_param_dict = ParseCustomJson.get_lld_param_dict(self.src_dir_path,
                                                             "nodes_resource.json")
        return nfvi_param_dict.get("storage_define")

    def get_additions_nodes(self):
        """
        功能：获取additions_nodes
        :return:
        """
        expansion_param = ParseCustomJson.get_lld_param_dict(self.src_dir_path,
                                                             "expansion_param.json")
        additions_nodes = expansion_param.get("additions_nodes", [])
        return additions_nodes

    def exe(self):
        """
        填充前台资源表表格入口
        :return:
        """
        # 填充前台资源表表格入口
        self.fulfill_table()
