# coding:utf-8
"""
功能：AdddiskTableOnediskBusiness，该类主要涉及节添加填充节点Onedisk
版权信息：华为技术有限公司，版本所有(C) 2010-2020
"""
from plugins.ROC.py_scripts.common.utils.add_increase_node_depends import AddIncreaseNodeDepends
from plugins.ROC.py_scripts.common.utils.config_controls import ConfigControls
from plugins.ROC.py_scripts.common.model.depends_model import Depends
from plugins.ROC.py_scripts.common.utils.parse_custom_json import ParseCustomJson


class AdddiskTableOnediskBusiness():
    """
    功能：添加diskTable
    """

    def __init__(self, kvs, ctrl_set, src_dir_path, custom_conditions):
        self.src_dir_path = src_dir_path
        self.ctrl_set = ctrl_set
        self.kvs = kvs
        self.custom_conditions = custom_conditions

    def fulfill_table(self):
        """
        功能：填充表格
        :return:
        """
        scene = self.kvs.get("scene")
        node_vm_res = self.kvs.get("node_vm_res")
        fi_nodename_list = self.custom_conditions.get("fi_nodename_list")
        if not fi_nodename_list:
            self.ctrl_set["visible"] = "false"
            return

        server_type = self.kvs.get("server_type", "").lower()
        additions_nodes = self.custom_conditions.get("additions_nodes", [])
        if not set(additions_nodes).intersection(set(fi_nodename_list)):
            depends_show_all = Depends()
            depends_show_all.update_depends("is_show_all", "yes")
            ConfigControls.update_config_depends(self.ctrl_set, depends_show_all)

        if server_type in ["2288x_v5", "taishan2280"] \
                and len(fi_nodename_list) >= 3 \
                and scene in ['C00']:
            self.ctrl_set["visible"] = "false"
            return

        controls = []
        prefix = "node"
        node_adddisk_res = [node_vm for node_vm in node_vm_res if
                            node_vm.get("nodeName") in fi_nodename_list]

        changed_node_status = {node_vm.get("nodeName", ""): node_vm.get("node_status", "old")
                               for node_vm in self.kvs.get("changed_node_vm_res", [])}
        for node_vm in node_adddisk_res:
            controls.extend(self.get_controls_tmp(node_vm, prefix, node_res=changed_node_status))
        self.ctrl_set["controls"] = controls

    def get_controls_tmp(self, node_vm, prefix, node_res=None):
        """
        功能：获取controls_tmp
        :param node_vm:
        :param prefix:
        :return:
        """
        node_name = node_vm.get("nodeName")
        fmt_para = (prefix, self.kvs.get(node_name))
        total_disk = int(node_vm.get("node_vm_define", {}).get("storage"))
        storage_define = ParseCustomJson.get_lld_param_dict(
            self.src_dir_path, "nodes_resource.json").get("storage_define")
        storage_col_1 = storage_define.get("default").get("data_storage_1")
        product_id = self.custom_conditions.get("id")
        data_storage_list = storage_define.get("special_node").get("data_storage")
        if product_id in storage_define.get("exception_product_id", []):
            data_storage_list = storage_define.get(product_id, {}). \
                get("special_node", {}).get("data_storage", {})
        for data_storage in data_storage_list:
            if data_storage.get("total_storage") == total_disk:
                storage_col_1 = data_storage.get("data_storage_1")
        storage_col_2 = total_disk - storage_define.get("default").get("system_storage") - \
                        storage_col_1
        controls_tmp = list()
        controls_tmp.append(ConfigControls.get_config("%s_vm_addDisk_%s" %
                                                      fmt_para,
                                                      node_name))
        controls_tmp.append(
            ConfigControls.get_config("%s_vm_addDisk_size_%s" %
                                      fmt_para,
                                      str(storage_col_2),
                                      cfg_type="string",
                                      editable="true"))

        if node_res:
            node_status = node_res.get(node_name, "old")
            if node_status == "old":
                AddIncreaseNodeDepends.add_depends_to_configs(controls_tmp)
        return controls_tmp

    def exe(self):
        """
        填充前台资源表表格入口
        :return:
        """

        # 填充前台资源表表格入口
        self.fulfill_table()
